pragma yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

-- Шаг 0.1: выставляем условия

$mayak_launched_countries = AsList(
'Армения',
'Белоруссия',
'Грузия',
'Израиль',
'Казахстан',
'Киргизия',
'Латвия',
'Молдавия',
'Россия',
'Узбекистан',
'Финляндия',
'Эстония'
);

$today_dt = cast(CurrentUtcDate() as string);
$yesterday = cast(cast($today_dt as date) - DateTime::IntervalFromDays(1) as string);
-- $orders_window = 70;
$check_start = '2021-02-01'; -- желательно брать начало месяца
$check_end = $yesterday;

$launched_order_tariffs = AsList(
    'express',
    'courier',
);

-- Шаг 0.2: таблицы, в которые записываем результаты
$prefix = '//home/taxi-delivery/analytics/alena-lukina/delivery/oper_dash/';
$order_base = $prefix || 'order_base';


-- Шаг 1: СОБИРАЕМ ДАННЫЕ ПО ЧАСТЯМ --------------------------------------------------------

-- ГЕО
$geo = (
select distinct
            tariff_zone,
            tz_aggl_name_ru as city,
            tz_country_name_ru as country
from `//home/taxi-dwh/cdm/geo/v_dim_op_geo_hierarchy/v_dim_op_geo_hierarchy`
where node_type = 'agglomeration'
);

-- Мэтчинг заказов еды (food orders matching)

$food_orders_info = (
    Select
        orders.order_nr as eda_order_id,
        orders.rating as rating,
        orders.comment as comment,
        'Text' as tags,
    From (
        Select
            order_nr,
            order_feedback_id as feedback_id,
            feedback_comment as comment,
            feedback_rating_val as rating
        From
            range(`//home/eda-dwh/cdm/order/dm_order`, substring($check_start, 0, 7))
    ) as orders
);

$food_dispatched_via_taxi = (
     Select
        taxi.order_id as taxi_order_id,
        eda.order_nr as eda_order_id,
        taxi.utc_order_dt as utc_order_dt
    From (
        Select
            order_id,
            utc_order_dt,
            corp_client_id,
            cargo_ref_id,
            claim_uuid
        From range(`home/taxi-dwh/summary/dm_order`, substring($check_start, 0, 7)) as d
                join (select cargo_order_id, min(claim_uuid) as claim_uuid
                      from `//home/taxi/production/replica/postgres/cargo_claims/claim_segments`
                      group by cargo_order_id
                      ) as t on d.cargo_ref_id = 'order/' || t.cargo_order_id
        Where true
            and success_order_flg
            and corp_client_id is not null
    ) as taxi

    join (
        Select
            order_nr,
            taxi_dispatch_cargo_uuid_id
        From
            range(`//home/eda-dwh/cdm/order/dm_order`, substring($check_start, 0, 7))
    ) as eda
        On taxi.claim_uuid = eda.taxi_dispatch_cargo_uuid_id

);


$food_orders_matching_base =
    Select distinct
        taxi.taxi_order_id as taxi_order_id,
        taxi.eda_order_id as eda_order_id,

        food.rating as rating_value,
        food.comment as rating_comment,
        food.tags as rating_tags,

        (
            (
                (
                    food.rating <= 3
                    and
                    food.tags ilike "%курьер%"
                )

            )
            ??
            false
        ) as overall_defect_trip_flg
    From $food_dispatched_via_taxi as taxi

    left join $food_orders_info as food
        on taxi.eda_order_id == food.eda_order_id
;

-- Рейтинг B2B (taxi and b2b rating)

$b2b_rating =
(select order_id, cast( min(score) as double) as min_score
from `//home/taxi/production/replica/postgres/cargo_c2c/clients_feedbacks`
where
score is not null
GROUP BY order_id
)
;


-- Платное ожидание (paid waiting time)
$about_points =
(
select
    c.corp_client_id as corp_client_id,
    c.taxi_order_id as taxi_order_id,
    cs.cargo_order_id as cargo_order_id,
    csp.id as segment_point_id,
    cp.*,
    p.* without cp.hash,
    p.hash,
    cp.id,
    cp.updated_ts
from `//home/taxi/production/replica/postgres/cargo_claims/claim_points` as cp
    full join    `//home/taxi/production/replica/postgres/cargo_claims/points` as p
        on cp.point_id = p.id
    full join `//home/taxi/production/replica/postgres/cargo_claims/claims` as c
        on cp.claim_id = c.id
    full join (select cargo_order_id, max(claim_id) as claim_id
                from `//home/taxi/production/replica/postgres/cargo_claims/claim_segments`
                group by cargo_order_id) as cs on cs.claim_id = c.id
    inner join `//home/taxi/production/replica/postgres/cargo_claims/claim_segment_points` as csp
        ON csp.claim_point_id = cp.id
);

$batching =
(
select
     a.cargo_order_id as cargo_order_id
    , a.segment_point_id as segment_point_id
    , SUM_IF(event_time, new_visit_status = 'arrived') as arrived_time
    , SUM_IF(event_time, new_visit_status = 'skipped') as skipped_time
    , SUM_IF(event_time, new_visit_status = 'visited') as visited_time
from `//home/taxi/production/replica/postgres/cargo_claims/claim_segment_points_change_log` as a
where a.cargo_order_id is not null
GROUP BY cargo_order_id, segment_point_id
)
;

$only_sources =
(
select a.*, taxi_order_id,
    case when visited_time is not NULL and arrived_time is not null
    then visited_time - arrived_time
    when skipped_time is not NULL and arrived_time is not null
    then skipped_time - arrived_time
    else Null end as time_delta
from $batching as a
 inner join $about_points as b on a.cargo_order_id = b.cargo_order_id and a.segment_point_id = b.segment_point_id
 where taxi_order_id is not null and  b.type = 'source'
 )
 ;

 $paid_waiting =
 (
 select taxi_order_id, max(1.0 * time_delta/ 60) as time_delta
 from $only_sources
 where 1.0 * time_delta/ 60 > 10
 group by taxi_order_id
 )
 ;

-- Жалобы клиентов (complaints)
--- Не доставлен заказ
$all_chatterbox = (
select distinct
    Yson::ConvertToString(meta_info.order_id) as order_id,
    "груз_не_доставлена_посылка_упрощёнка" in Yson::ConvertToStringList(tags) as has_tag_not_elivered
from `//home/taxi/production/services/support-taxi/support_chatterbox`
where "груз_не_доставлена_посылка_упрощёнка" in Yson::ConvertToStringList(tags)
and Yson::ConvertToString(meta_info.order_id)  is not null
);

$all_form = (
select
    Yson::ConvertToString(answer.data.order_id.value) as order_id
from `//home/forms/answers/forms_int/production/46200/data`
where Yson::ConvertToString(answer.data.answer_choices_428013.value[0].key) in ("620602", "620601")
and  Yson::ConvertToString(answer.data.order_id.value) is not null
);

$cargo_claim_id_list_raw = (
select
    String::SplitToList(Yson::ConvertToString(answer.data.answer_long_text_511240.value), '\r\n') as claim_id
from `//home/forms/answers/forms_int/production/62797/data`
);

$cargo_claim_id_list = (
select claim_id from $cargo_claim_id_list_raw
flatten by claim_id
);

$all_mass_form = (
select order_id
from (
select
            Yson::ConvertToString(doc.taxi_order_id, Yson::Options(false as Strict)) as order_id,
            Yson::ConvertToString(doc.uuid_id, Yson::Options(false as Strict)) as uuid_id,
        from `//home/taxi-dwh/raw/cargo_claims/claims/2021`)
        where uuid_id in $cargo_claim_id_list
);


$bad_orders = (
select distinct order_id
from (
select
order_id from $all_chatterbox
union all
select order_id from $all_form
union all
select order_id from $all_mass_form
)
);

--- Все жалобы из формы 46200 (от Светы)

$all_form = (
select
    order_id,
    ListConcat(AggregateListDistinct(Yson::ConvertToString(answer.data.answer_choices_428013.value[0].text))
    , "; ")  as complaint_categories
from `//home/forms/answers/forms_int/production/46200/data`
where Yson::ConvertToString(answer.data.order_id.value) is not null
group by Yson::ConvertToString(answer.data.order_id.value) as order_id
);

-- Шаг 2: СОБИРАЕМ ИЗ ЧАСТЕЙ БАЗУ ПО ЗАКАЗАМ --------------------------------------------------------

$raw_orders = (
    Select distinct
        taxi.utc_order_dt                                   as utc_order_dt,
        taxi.order_id                                       as order_id,
        taxi.unique_driver_id                               as unique_driver_id,
        geo.country                                         as country,
        taxi.utc_order_dttm                                 as utc_order_dttm,
        taxi.success_order_flg                              as success_order_flg,
        case when status = 'finished' and taxi_status = 'failed'
        then True else False end                            as driver_cancel_flg,
        taxi.corp_order_flg                                 as corp_order_flg,
        taxi.corp_client_id                                 as corp_client_id,

        (
            (
                coalesce(min_score, taxi.rating_value) <= 3
                or
                food.overall_defect_trip_flg
                or
                notdel.order_id is not null
                or
                form.order_id is not null
                or
                paid.taxi_order_id is not null
            )
            ??
            false
        )                                                   as defect_order_flg,
        coalesce(min_score, taxi.rating_value)              as user_rating_value,
        courier.courier_score                               as courier_rating_value,

        case
            when (
                (Yson::ConvertToString(taxi.order_requirements.door_to_door) is not null)
                and
                (
                    (String::JoinFromList(Yson::ConvertToStringList(taxi.rating_reasons), '; ') ilike "%no_doortodoor%")
                )
            )
                then "no_doortodoor"

            when (
                (String::JoinFromList(Yson::ConvertToStringList(taxi.rating_reasons), '; ') ilike "%waiting%")
            )
                then "waiting"

            when (
                (String::JoinFromList(Yson::ConvertToStringList(taxi.rating_reasons), '; ') ilike "%long_trip%")
            )
                then "long_trip"

            when (
                (String::JoinFromList(Yson::ConvertToStringList(taxi.rating_reasons), '; ') ilike "%noconnection%")
            )
                then "noconnection"

            when (
                (String::JoinFromList(Yson::ConvertToStringList(taxi.rating_reasons), '; ') ilike "%rude%")
            )
                then "rude"

            when (
                (String::JoinFromList(Yson::ConvertToStringList(taxi.rating_reasons), '; ') ilike "%parking%")
            )
                then "parking"

            else "review_rules"

        end                                                         as defect_reason_code,
        case when coalesce(time_delta, driver_wait_time_min) > 10
        then True
        else False end                                              as paid_waiting_flg,
        case when notdel.order_id is not null
        then True
        else False end                                              as not_elivered_flg,
        coalesce(form.complaint_categories, "review_rules")         as complaint_category_list

    From range(`//home/taxi-dwh/summary/dm_order`, $check_start) as taxi

    left join $food_orders_matching_base as food
        on taxi.order_id == food.taxi_order_id

    left join $geo as geo
        on taxi.tariff_zone == geo.tariff_zone

    left join $b2b_rating as b2b on taxi.order_id == b2b.order_id

    left join $paid_waiting as paid on taxi.order_id == paid.taxi_order_id

    left join $bad_orders as notdel on taxi.order_id == notdel.order_id

    left join $all_form as form on taxi.order_id == form.order_id

    left join (select order_id, taximeter_order_id
    from range(`home/taxi-dwh/cdm/marketplace/fct_order`, $check_start)
    where  utc_order_created_dt between $check_start and $check_end
        and tariff_class_code in ("express", "courier")
    )as fct
        on taxi.order_id == fct.order_id

    left join (select taximeter_order_id, avg(1.0 * score) as courier_score
                from range(`//home/taxi-dwh/ods/taximeter/feedback`, $check_start)
                group by taximeter_order_id
              ) as courier on fct.taximeter_order_id == courier.taximeter_order_id

    Where true
        and (taxi.utc_order_dt between $check_start and $check_end)
        and if(taxi.order_tariff in $launched_order_tariffs, true, false)
        and if(geo.country in $mayak_launched_countries, true, false)
        and (taxi.order_tariff in ("express", "courier"))
        and (geo.country in $mayak_launched_countries)
);

$raw_orders_window = (
    Select
        *
    From
        $raw_orders
    Where
        utc_order_dt >= $check_start
);

INSERT INTO $order_base WITH TRUNCATE
select *
from $raw_orders_window
;

Commit;