import sys
import os
import pandas as pd
import numpy as np
import requests
import json
from business_models import hahn
from business_models.greenplum import GreenplumManager

if __name__=='__main__':

    query = '''
    USE hahn;
    PRAGMA AnsiInForEmptyOrNullableItemsCollections;
    pragma yt.InferSchema;
    pragma SimpleColumns;
    pragma yson.DisableStrict;
    pragma yt.DefaultMemoryLimit = '8G';
    pragma yson.DisableStrict;
    
    $hist_base =
    (select taximeter_park_id, max(coalesce(utc_modified_dttm, utc_create_dttm)) as utc_modified_dttm
    from `//home/taxi-dwh/ods/taximeter/park_hist/park_hist`
    GROUP BY taximeter_park_id
    );
    
    $contacts = (
    SELECT a.taximeter_park_id as db_id
        , park_id as clid
        , city as park_city
        , name as park_name
        , org_name
      --  , contact_list
         , Yson::ConvertToStringList(contact_list) as contact_list
        , SUBSTRING(utc_create_dttm, 0, 10) as utc_create_dt
    from `//home/taxi-dwh/ods/taximeter/park_hist/park_hist` as a 
        inner join $hist_base as b on a.taximeter_park_id = b.taximeter_park_id and a.utc_modified_dttm = b.utc_modified_dttm
    );
    
    $phones_step1 = (
    select taximeter_park_id,
        effective_from_dttm, effective_to_dttm,
        Yson::LookupString(contact, 'phones') as phone
    from (
        select taximeter_park_id,
            effective_from_dttm, effective_to_dttm,
            Yson::ConvertToList(contact_list) as list_of_contacts   -- list of Ysons
        from `//home/taxi-dwh/ods/taximeter/park_hist/park_hist`
    ) FLATTEN LIST BY list_of_contacts as contact                   -- contact - Yson
    );
    
    $phones_step2 =
    (select taximeter_park_id,
        max(effective_from_dttm) as effective_from_dttm
    from $phones_step1
    group by taximeter_park_id
    );
    
    $phones_step3 =
    (select db_id, some(phone) as phone
    from $phones_step1 as a
    inner join $phones_step2 as b on a.taximeter_park_id = b.taximeter_park_id and a.effective_from_dttm = b.effective_from_dttm
    group by a.taximeter_park_id as db_id
    );
    
    $parks = (
    SELECT  DISTINCT 
        id as db_id
        , is_active
        , IF(ListHas(Yson::ConvertToStringList(park_specifications) ,'delivery'),id,NULL) as delivery_db_id
        , CASE WHEN driver_partner_source IN ('self_assign', 'yandex','selfemployed_fns') THEN 'SMZ/IP'
               ELSE 'Park' END as park_type
    FROM `//home/taxi/production/replica/mongo/struct/pda_private/pda_parks` as a
    );
    
    INSERT INTO `//home/taxi-analytics/alena-lukina/express/supply/parks` with truncate
    select distinct a.db_id as db_id
            , clid
            , park_city
            , park_name
            , org_name, contact_list, phone
            , utc_create_dt
            , is_active
            , delivery_db_id
            , park_type
    from $parks as a
        inner join $contacts as b on a.db_id = b.db_id
        left join $phones_step3 as c on a.db_id = c.db_id
    ;
    '''


    # In[ ]:


    parks = hahn(query)


    # In[ ]:

    greenplum = GreenplumManager(user='alena-lukina',
                                 token=str(os.environ['GP_TOKEN']),
                                 connect_args={'sslmode': 'require'})


    greenplum.replicate(yt_path='//home/taxi-analytics/alena-lukina/express/supply/parks',
                        table_name='snb_taxi.ellenl_parks',
                        if_exists='replace')


    # In[ ]:


    greenplum('GRANT all privileges ON snb_taxi.ellenl_parks TO "alena-lukina", "robot-taxi-business"')


    # In[ ]:


    greenplum('GRANT SELECT ON snb_taxi.ellenl_parks TO analyst')

