-- use hahn;
pragma yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;


$format_dt = DateTime::Format('%Y-%m-%d');
$dm_order = 'home/taxi-dwh/summary/dm_order/' || substring('{0}', 0, 7);
$dm_order_nikita = 'home/taxi-analytics/nbobukh/express/demand/orders/' || substring('{0}', 0, 10);
$place_to_save = 'home/taxi-analytics/alena-lukina/express/demand/orders/' || '{0}';

$dm_order = (
select  order_id,
        utc_order_dt,
        utc_order_dttm,
        utc_order_due_dttm,
        utc_order_complete_dttm
from $dm_order
);

$order_cube = (
select  order_id,
        order_tariff as driver_tariff,
        if(folback_order, 'courier', order_tariff) as order_tariff,
        folback_order,
        expired_order_flg,
        supply_type,
        success_order_flg,
        user_cancell_before_assign,
        user_cancell_after_assign,
        reorder_cnt,
        logistic_order_flg,
        order_type,
        org_name,
        b2b_flg,
        city_ru as agl_name_ru,
        tariff_zone,
        driver_id,
        String::JoinFromList(
                LISTUniq(supply_plan), ' + ') as order_supply_plan,
        supply_plan_cargo,
        supply_plan_courier,
        supply_plan_express
from $dm_order_nikita
);

insert into $place_to_save
with truncate
select  a.order_id as order_id,
        a.driver_id as driver_id,
        supply_type,
        utc_order_dttm,
        utc_order_due_dttm,
        utc_order_complete_dttm,
        driver_tariff,
        order_tariff,
        folback_order as fallback_order_flg,
        expired_order_flg,
        success_order_flg,
        user_cancell_before_assign,
        user_cancell_after_assign,
        reorder_cnt,
        logistic_order_flg,
        order_type,
        org_name,
        b2b_flg,
        agl_name_ru,
        tariff_zone,
        order_supply_plan,
        supply_plan_cargo,
        supply_plan_courier,
        supply_plan_express
from $order_cube as a
join $dm_order as b
on a.order_id = b.order_id
;