import sys
import os
import pandas as pd
import numpy as np
from business_models import hahn
from business_models.greenplum import GreenplumManager
import datetime
from datetime import date, timedelta


if __name__=='__main__':

    start_date = str(datetime.datetime.today().date() + datetime.timedelta(-18)) # included
    print(start_date)

    start_date_v2 = str(datetime.datetime.today().date() + datetime.timedelta(-4)) # included
    print(start_date_v2)

    months = pd.date_range('2021-01-01',
                           pd.Timestamp.today().strftime('%Y-%m-%d'),
                           freq='MS')
    compare_date = pd.Timestamp.today() - pd.Timedelta(days=4)
    update_dt = [x.strftime('%Y-%m-%d') for x in months if x.month >= compare_date.month]


    # Для записи ошибок
    message_list = []


    with open('orders_data.sql', 'r') as reader:
        query = reader.read()
    for dt in update_dt:
        try:
            hahn(query.format(dt), syntax_version=1)
        except RequestException:
            message_list.append(('''
            1. Query Date - {0}
            Query Error
            '''.format(dt), False))
        except:
            exc_type, exc_val, traceback = sys.exc_info()
            message_list.append(('''
            1. Query Date - {0}
            Query Error:{1}
            Value:{2}
            '''.format(dt, str(exc_type), str(exc_val)), False))
        else:
            message_list.append(('1. Query Date - {0}\nYT Query done', True))


    orders = hahn("""
    use hahn;
    PRAGMA AnsiInForEmptyOrNullableItemsCollections;
    
    $format = DateTime::Format("%Y-%m-%d");
    $day_sometime_ago = $format(CurrentUtcTimestamp() - DateTime::IntervalFromDays(18));
    $start_of_prev_month = $format(DateTime::StartOfMonth(DateTime::MakeDatetime(DateTime::StartOfMonth(CurrentUtcTimestamp())) - DateTime::IntervalFromDays(1)));
    
    select agl_name_ru,
           b2b_flg,
           driver_id,
           driver_tariff,
           expired_order_flg,
           fallback_order_flg,
           logistic_order_flg,
           order_id,
           case when order_tariff = 'courier' then coalesce(supply_plan_courier, supply_plan_express)
           when order_tariff = 'express' then coalesce(supply_plan_express, supply_plan_courier)
           when order_tariff in ('cargo', 'cargocorp') then supply_plan_cargo
           else NULL end
           as order_supply_plan,
           order_tariff,
           order_type,
           org_name,
           reorder_cnt,
           success_order_flg,
           supply_type,
           tariff_zone,
           user_cancell_after_assign,
           user_cancell_before_assign,
           utc_order_complete_dttm,
           utc_order_dttm,
           utc_order_due_dttm
    from range('home/taxi-analytics/alena-lukina/express/demand/orders', $start_of_prev_month)
    where utc_order_dttm >= $day_sometime_ago 
    ;
    """)

    greenplum = GreenplumManager(user='alena-lukina', token=str(os.environ['GP_TOKEN']),
                                 connect_args={'sslmode': 'require'})

    greenplum(
    """
        delete 
        from snb_taxi.ellenl_orders_export_gp
        where utc_order_dttm >= '{dt}' or utc_order_dttm is Null
    """.format(dt=start_date)
    )


    greenplum.write(dataframe=orders, table_name='snb_taxi.ellenl_orders_export_gp', if_exists='append')


    with open('supply_data.sql', 'r') as reader:
        query = reader.read()
    for dt in update_dt:
        try:
            hahn(query.format(dt), syntax_version=1)
        except RequestException:
            message_list.append(('''
            1. Query Date - {0}
            Query Error
            '''.format(dt), False))
        except:
            exc_type, exc_val, traceback = sys.exc_info()
            message_list.append(('''
            1. Query Date - {0}
            Query Error:{1}
            Value:{2}
            '''.format(dt, str(exc_type), str(exc_val)), False))
        else:
            message_list.append(('1. Query Date - {0}\nYT Query done', True))


    sessions = hahn("""
    use hahn;
    PRAGMA AnsiInForEmptyOrNullableItemsCollections;
    
    $format = DateTime::Format("%Y-%m-%d");
    $day_sometime_ago = $format(CurrentUtcTimestamp() - DateTime::IntervalFromDays(4));
    $start_of_prev_month = $format(DateTime::StartOfMonth(DateTime::MakeDatetime(DateTime::StartOfMonth(CurrentUtcTimestamp())) - DateTime::IntervalFromDays(1)));
    
    select *
    from range('home/taxi-analytics/alena-lukina/express/supply/export_gp', $start_of_prev_month)
    where utc_dt >= $day_sometime_ago 
    ;
    """)


    greenplum("""
    delete 
    from snb_taxi.ellenl_supply_export_gp_v2
    where utc_dt >= '{dt}' or utc_dt is null
    """.format(dt=start_date_v2)
             )

    greenplum.write(dataframe=sessions, table_name='snb_taxi.ellenl_supply_export_gp_v2', if_exists='append')

    print('Done')

