use hahn;
pragma yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
$format = DateTime::Format('%Y-%m-%d');

$day_sometime_ago = $format(CurrentUtcTimestamp() - DateTime::IntervalFromDays(1));
$app_hist = '//home/taxi-analytics/kis/drivers_apps_history/' || substring('2021-01-01', 0, 10);
$cube_v3_dima = 'home/taxi-analytics/d-captain/driver_cube_v3/' || substring('{0}', 0, 10);
$sessions = "home/taxi-dwh/dds/driver_session_reduced";
$fct_supply_state_hist = '//home/taxi-dwh/cdm/supply/fct_supply_state_hist';
$dm_order = 'home/taxi-dwh/summary/dm_order/' || substring('{0}', 0, 7);
$place_to_save = 'home/taxi-analytics/alena-lukina/express/supply/export_gp/' || '{0}';

$geo = (
select  tariff_zone,
        tz_aggl_name_ru,
        tz_country_name_ru
from `//home/taxi-dwh/cdm/geo/v_dim_op_geo_hierarchy/v_dim_op_geo_hierarchy`
where node_type = 'agglomeration'
);

$exam = (
select  unique_driver_id,
        max(expeditor_exam_dttm) as expeditor_exam_dttm
from `home/taxi-analytics/nbobukh/express/supply/driver_exam_cube`
group by unique_driver_id
);

$taximetr = (
select  if(max(AppVersionName >= '9.32'), True, False) as multipoints_available, 
        driver_id,
        utc_dt
from $app_hist
group by 
driver_id,
event_dt as utc_dt
);

$tags_new = (
select  dbid_uuid,
        tag,
        cc,
        assigned,
        seen,
        $format(DateTime::FromSeconds(dt)) as utc_dt
from $cube_v3_dima as a
);


$tags = (
select a.*, unique_driver_id, 
    p.park_id||'_'||b.executor_profile_id as driver_id
from (  select *
        from $tags_new
        ) as a
join `home/taxi-dwh/cdm/supply/dm_executor_profile_act/dm_executor_profile_act` as b
on a.dbid_uuid = (b.park_taximeter_id || '_' || b.executor_profile_id)
join `home/taxi-dwh/ods/taximeter/park` as p
    on b.park_taximeter_id = p.taximeter_park_id
);

$supply_plans_step_1 = (
select  a.utc_dt as utc_dt,
        dbid_uuid,
        a.unique_driver_id as unique_driver_id,
        a.driver_id as driver_id,
      --  assigned,
      --  seen,
      --  coalesce((1.0 * coalesce(assigned,0)/ seen),0) as acceptance_rate,
        tag['walking_courier'] ?? 0.0 as walking_courier_tag,
        tag['auto_courier'] ?? 0.0 as auto_courier_tag,
        (cc['express'] > 0) ?? False as express_available,
        (cc['courier'] > 0) ?? False as courier_available,
        if(a.utc_dt > expeditor_exam_dttm, True, False) ?? False as expeditor_flg,
        multipoints_available ?? False as multipoints_available,
        if( -- Условия для доступа к thermobag_delivery
            tag['thermobag'] > 0, True, False) as thermobag_tag,
        if(
            tag['thermobag_confirmed'] > 0, True, False) as thermobag_confirmed_tag,
        if(
            tag['thermobox_option_on'] > 0, True, False) as thermobox_option_on_tag,
        if(
            tag['thermobag_off'] > 0, True, False) as thermobag_off_tag,
        if(
            tag['no_taxi_license'] > 0, True, False) as no_taxi_license_tag,
        if(
            tag['expeditor'] > 0, True, False) as expeditor_tag,
        if(
            tag['multipoints'] > 0, True, False) as multipoints_tag,
        if( -- Условия для доступа к car_couriers
            tag['walking_courier'] is null, True, False) as car_couriers,
        if(
            tag['delivery_mayak_block_corp'] > 0, True, False) as delivery_mayak_block_corp_tag,
        if(
            tag['eda_frequent_user_cancels'] > 0, True, False) as eda_frequent_user_cancels_tag,
        if(
            tag['eda_frauders_waiting'] > 0, True, False) as eda_frauders_waiting_tag,
        if(
            tag['frauder_long_driving_delivery'] > 0, True, False) as frauder_long_driving_delivery_tag,
        if(
            tag['frauder_long_transporting'] > 0, True, False) as frauder_long_transporting_tag,
        if(
            tag['taxi_frauders_waiting'] > 0, True, False) as taxi_frauders_waiting_tag,
        if(
            tag['disable_corp_delivery_rating'] > 0, True, False) as disable_corp_delivery_rating_tag,
        if(
            tag['hearing_impaired'] > 0, True, False) as hearing_impaired_tag,
        if(
            tag['delivery_call_unwilling_old'] > 0, True, False) as delivery_call_unwilling_old_tag,
        if(
            tag['delivery_call_unwilling_quality'] > 0, True, False) as delivery_call_unwilling_quality_tag,
        if(
            tag['lavka_frauders_waiting'] > 0, True, False) as lavka_frauders_waiting_tag,
        if(
            tag['medical_card'] > 0, True, False) as medical_card_tag,
        if(
            tag['medical_card_off'] > 0, True, False) as medical_card_off_tag,
        if( -- Условия для доступа к afcd_req_new
            tag['delivery_mayak_block_corp'] is null and 
            tag['delivery_call_unwilling_old'] is null and 
            tag['delivery_call_unwilling_quality'] is null and 
            tag['hearing_impaired'] is null and 
            tag['disable_corp_delivery_rating_below_4_80'] is null and 
            tag['lavka_frauders_waiting'] is null and 
            tag['eda_frauders_waiting'] is null and 
            tag['taxi_frauders_waiting'] is null, 
            True, False) as afcd_req_new
from $tags as a
left join $taximetr as b
on a.driver_id = b.driver_id and a.utc_dt = b.utc_dt
left join $exam as c
on a.unique_driver_id = c.unique_driver_id
);

$supply_plans = (
select  utc_dt, dbid_uuid, 
        walking_courier_tag,
        auto_courier_tag,
        express_available,
        courier_available,
        thermobag_tag,
        thermobag_confirmed_tag,
        thermobox_option_on_tag,
        thermobag_off_tag,
        no_taxi_license_tag,
        expeditor_tag,
        multipoints_tag,
        car_couriers,
        delivery_mayak_block_corp_tag,
        eda_frequent_user_cancels_tag,
        eda_frauders_waiting_tag,
        frauder_long_driving_delivery_tag,
        frauder_long_transporting_tag,
        taxi_frauders_waiting_tag,
        disable_corp_delivery_rating_tag,
        hearing_impaired_tag,
        delivery_call_unwilling_old_tag,
        delivery_call_unwilling_quality_tag,
        lavka_frauders_waiting_tag,
        afcd_req_new,
        medical_card_tag,
        medical_card_off_tag,
       -- acceptance_rate,
        max(unique_driver_id) as unique_driver_id,
        AGGREGATE_LIST(String::SplitToList(driver_id, '_')[0]) as clid_list,
        max(expeditor_flg) as expeditor_flg,
        max(multipoints_available) as multipoints_available
from $supply_plans_step_1 as a
group by utc_dt, dbid_uuid, 
        walking_courier_tag,
        auto_courier_tag,
        express_available,
        courier_available,
        thermobag_tag,
        thermobag_confirmed_tag,
        thermobox_option_on_tag,
        thermobag_off_tag,
        no_taxi_license_tag,
        expeditor_tag,
        multipoints_tag,
        car_couriers,
        delivery_mayak_block_corp_tag,
        eda_frequent_user_cancels_tag,
        eda_frauders_waiting_tag,
        frauder_long_driving_delivery_tag,
        frauder_long_transporting_tag,
        taxi_frauders_waiting_tag,
        disable_corp_delivery_rating_tag,
        hearing_impaired_tag,
        delivery_call_unwilling_old_tag,
        delivery_call_unwilling_quality_tag,
        lavka_frauders_waiting_tag,
        afcd_req_new,
        medical_card_tag,
        medical_card_off_tag
      --  acceptance_rate
);

$geosubs = (
select  dbid_uuid,
        $format(DateTime::FromSeconds(dt)) as utc_dt,
        nz_maxby_sh as tariff_zone,
        geobooking_subs
from $cube_v3_dima
);

$orders = (
select  dbid_uuid,
        tariff_zone,
        utc_order_dt as utc_dt,
        count(*) as orders,
        count_if(success_order_flg) as trips,
        count_if(order_tariff = 'express') as express_orders,
        count_if(order_tariff = 'express' and success_order_flg) as express_trips,
        count_if(order_tariff = 'courier') as courier_orders,
        count_if(order_tariff = 'courier' and success_order_flg) as courier_trips,
        sum_if(driver_net_income, success_order_flg) as driver_net_income
from $dm_order
group by    db_id || '_' || String::SplitToList(driver_id, '_')[1] as dbid_uuid,
            tariff_zone,
            utc_order_dt
);

$sessions = (
select  dbid_uuid,
        tariff_zone,
        utc_dt,
        1.0 * sum_if(duration_sec, status not in ("unavailable","verybusy")) / 3600 as sh,
        1.0 * sum_if(duration_sec, status  == "transporting") / 3600 as transporting,
        1.0 * sum_if(duration_sec, status  == "driving") / 3600 as driving,
        1.0 * sum_if(duration_sec, status  == "waiting") / 3600 as waiting,
        1.0 * sum_if(duration_sec, status  == "free") / 3600 as free
from range($sessions, substring('{0}', 0, 10), $day_sometime_ago)
where tariff_zone is not null
group by    taximeter_park_id || '_' || driver_uuid as dbid_uuid,
            tariff_zone,
            substring(utc_start_dttm, 0, 10) as utc_dt
);

$autocourier_sh =
(select dbid_uuid, 
tariff_zone, 
utc_dt ,
1.0 * SUM_IF(duration_sec, (ListHas(Yson::ConvertToStringList(lcl_available_tariff_class_code_list), 'courier') 
and ListHas(Yson::ConvertToStringList(lcl_available_tariff_class_code_list), 'express')
and ListLength(Yson::ConvertToStringList(lcl_available_tariff_class_code_list)) == 2))/ sum(duration_sec) as autocourier_sh_share,
1.0 * SUM_IF(duration_sec, (ListHas(Yson::ConvertToStringList(lcl_available_tariff_class_code_list), 'cargo') 
or ListHas(Yson::ConvertToStringList(lcl_available_tariff_class_code_list), 'cargocorp')))/ sum(duration_sec) as cargo_sh_share
from range($fct_supply_state_hist, substring('{0}', 0, 10), $day_sometime_ago)
where tariff_zone is not null
GROUP BY (park_taximeter_id || '_' || executor_profile_id) as dbid_uuid, 
tariff_geo_zone_code as tariff_zone, 
SUBSTRING(utc_valid_from_dttm, 0, 10) as utc_dt
)
;

insert into $place_to_save with truncate
select *
from $sessions as a
left join $orders as b
on a.dbid_uuid = b.dbid_uuid
and a.tariff_zone = b.tariff_zone
and a.utc_dt = b.utc_dt
join $supply_plans as c
on a.dbid_uuid = c.dbid_uuid
and a.utc_dt = c.utc_dt
left join $geosubs as d
on a.dbid_uuid = d.dbid_uuid
and a.tariff_zone = d.tariff_zone
and a.utc_dt = d.utc_dt
join $geo as g
on a.tariff_zone = g.tariff_zone
left join $autocourier_sh as e
on a.dbid_uuid = e.dbid_uuid
and a.tariff_zone = e.tariff_zone
and a.utc_dt = e.utc_dt
;
