# -*- coding: utf-8 -*-

import logging
import pandas as pd
import yt.wrapper as yt
from datetime import datetime
from projects.common.helpers import build_gdocs

gdocs = build_gdocs()
_LOG = logging.getLogger(__name__)
logging.basicConfig(
    level=logging.INFO,
    format=f'%(asctime)s %(filename)s %(levelname)s: %(message)s'
)

SCHEMA = [
    dict(name="author_login", type="string"),
    dict(name="chatterbox_url", type="string"),
    dict(name="judge_full_name", type="string"),
    dict(name="judge_login", type="string"),
    dict(name="msk_created_dt", type="string"),
    dict(name="order_id", type="string"),
    dict(name="reason", type="string"),
    dict(name="source", type="string")
]
DISPUTED_FINES = "//home/taxi-delivery/analytics/production/support/dwh/raw/disputed_fines"
COLUMNS = [
    "msk_created_dt", "author_login", "order_id", "reason", "chatterbox_url", "judge_login", "judge_full_name", "source"
]


def write_replica_gdocs():
    old_log = gdocs.read(
        table_name="Лист1",
        sheet_id="1Ry2r0djcqZ3-V0jeoi-1UgHHwzKOSCkwKNaAx_k8yXk",
        header=2
    ).iloc[:, 0:len(COLUMNS)]
    old_log.columns = COLUMNS
    old_log["source"] = "old_log"

    new_log = gdocs.read(
        table_name="Список",
        sheet_id="1Mrb-y8ULAY-PYKpT9TfKhHYtF_ucImw3cV0pgUkqf2k",
        header=2
    ).iloc[:, 0:len(COLUMNS)]

    new_log.columns = COLUMNS
    new_log["source"] = "new_log"

    fines_log = pd.concat([old_log, new_log])
    data = fines_log.to_dict(orient="records")
    for row in data:
        if row["source"] == "old_log":
            row["msk_created_dt"] += ".2021"
        elif row["source"] == "new_log":
            row["msk_created_dt"] += ".2022"
        try:
            row["msk_created_dt"] = datetime.strptime(row["msk_created_dt"], "%d.%m.%Y").strftime("%Y-%m-%d")
        except ValueError:
            row["msk_created_dt"] = None
    yt.write_table(yt.TablePath(DISPUTED_FINES, schema=SCHEMA), data)
    _LOG.info("finish write")


def main():
    write_replica_gdocs()


if __name__ == "__main__":
    yt.config.set_proxy("hahn")
    main()
