-- $start_date
CREATE TEMPORARY TABLE start_date
    ON COMMIT DROP
AS (
    SELECT (NOW() - INTERVAL '6 month')::Date AS start_date
) DISTRIBUTED RANDOMLY;
ANALYZE start_date;


-- $end_date
CREATE TEMPORARY TABLE end_date
    ON COMMIT DROP
AS (
    SELECT (NOW() - INTERVAL '1 day')::Date AS end_date
) DISTRIBUTED RANDOMLY;
ANALYZE end_date;


CREATE TEMPORARY TABLE link_ticket_order_act
    ON COMMIT DROP
AS (
    SELECT ticket_id
         , max(country_name_ru)       AS country
         , max(agglomeration_name_ru) AS city
         , max(corp_client_id)        AS corp_client_id
    FROM taxi_cdm_contactcenter.link_ticket_order_act
    WHERE country_name_ru is not null
       or agglomeration_name_ru is not null
       or corp_client_id is not null
    GROUP BY ticket_id
);


CREATE TEMPORARY TABLE tickets_actions
    ON COMMIT DROP
AS (
    SELECT a.ticket_id                 AS ticket_id,   -- считаем количество тикетов
           a.ticket_id || CAST(SUM(CASE
                                       WHEN a.meta_event_name IN
                                            ('create', 'reopen', 'new_message', 'answer_on_proactive',
                                             'reopen_after_dismiss')
                                           THEN 1
                                       ELSE 0
               END) over w AS VARCHAR) AS ticket_session,
           a.utc_event_dttm            AS utc_attribution_dttm,
           a.meta_event_name           AS meta_action,
           CASE
               WHEN meta_event_name IN ('create', 'new_message', 'appear', 'reopen', 'answer_on_proactive',
                                        'reopen_after_dismiss')
                   AND ((lead(meta_event_name) over w = 'forward'
                       AND LEAD(staff_login) over w = 'superuser')
                       OR lead(meta_event_name) over w IN ('proactive_support', 'proactive_message')
                       OR lead(meta_event_name) over w IS NULL)
                   THEN true
               ELSE false
               END                     AS exclude_flg,
           CASE
               WHEN meta_event_name IN ('create', 'new_message', 'appear', 'reopen', 'answer_on_proactive',
                                        'reopen_after_dismiss')
                   AND (NOT (lead(meta_event_name) over w = 'forward'
                       AND LEAD(staff_login) over w = 'superuser')
                            AND lead(meta_event_name) over w NOT IN ('proactive_support', 'proactive_message')
                       OR lead(meta_event_name) over w IS NULL)
                   THEN 1
               ELSE 0
               END                     AS overall,
           CASE
               WHEN meta_event_name IN
                    ('comment', 'communicate', 'call_success', 'close', 'temp_answer', 'comment_ml', 'communicate_ml',
                     'close_ml', 'defer_with_answer', 'forward', 'appear', 'tech_close')
                   AND lead(csat_value) over w = 5
                   THEN 5
               WHEN meta_event_name IN
                    ('comment', 'communicate', 'call_success', 'close', 'temp_answer', 'comment_ml', 'communicate_ml',
                     'close_ml', 'defer_with_answer', 'forward', 'appear', 'tech_close')
                   AND lead(csat_value) over w = 4
                   THEN 4
               WHEN meta_event_name IN
                    ('comment', 'communicate', 'call_success', 'close', 'temp_answer', 'comment_ml', 'communicate_ml',
                     'close_ml', 'defer_with_answer', 'forward', 'appear', 'tech_close')
                   AND
                    lead(csat_value) over w = 3
                   THEN 3
               WHEN meta_event_name IN
                    ('comment', 'communicate', 'call_success', 'close', 'temp_answer', 'comment_ml', 'communicate_ml',
                     'close_ml', 'defer_with_answer', 'forward', 'appear', 'tech_close')
                   AND
                    lead(csat_value) over w = 2
                   THEN 2
               WHEN meta_event_name IN
                    ('comment', 'communicate', 'call_success', 'close', 'temp_answer', 'comment_ml', 'communicate_ml',
                     'close_ml', 'defer_with_answer', 'forward', 'appear', 'tech_close')
                   AND
                    lead(csat_value) over w = 1
                   THEN 1
               ELSE NULL
               END                     AS csat_value,  --считаем ксат
           CASE
               WHEN meta_event_name IN
                    ('comment', 'communicate', 'call_success', 'close', 'temp_answer', 'comment_ml', 'communicate_ml',
                     'close_ml', 'defer_with_answer', 'tech_close')
                   AND
                    lead(meta_event_name) over w IN ('reopen', 'reopen_after_dismiss')
                   THEN true
               ELSE false
               END                     AS with_reopen, --считаем реопены
           CASE
               WHEN (lag(meta_event_name) OVER w = 'take' OR
                     (lag(meta_event_name) over w = 'assign' AND a.sector_name ilike '%%lavka%%'))
                   AND
                    meta_event_name IN
                    ('comment', 'communicate', 'call_success', 'close', 'temp_answer', 'comment_ml', 'communicate_ml',
                     'close_ml', 'defer_with_answer', 'forward')
                   THEN extract(epoch FROM (a.utc_event_dttm - lag(a.utc_event_dttm) over w))
               ELSE NULL
               END                     AS solve_time,
           date(utc_event_dttm)        AS utc_attribution_dt,
           CASE
               WHEN COALESCE(a.theme_manual_name, a.theme_by_tag_name) IS NOT NULL OR
                    a.meta_event_name IN
                    ('comment', 'communicate', 'close', 'temp_answer', 'comment_ml', 'communicate_ml',
                     'close_ml', 'defer_with_answer', 'dismiss', 'forward', 'tech_close')
                   THEN COALESCE(a.theme_manual_name, a.theme_by_tag_name, 'Unknown::Unknown::Unknown::Unknown')
               ELSE NULL
               END                     AS theme,
           a.sector_name               AS sector,
           a.promocode_id              AS promo_code,
           staff_login,
           b.country                   as country,
           b.city                      as city,
           b.corp_client_id            as corp_client_id
    FROM taxi_cdm_contactcenter.fct_ticket_action_markup AS a
             LEFT JOIN link_ticket_order_act b
                       ON b.ticket_id = a.ticket_id
    WHERE a.utc_event_dttm::DATE between (SELECT start_date FROM start_date) and (SELECT end_date FROM end_date)
      AND (a.meta_event_name IN ('reopen_after_dismiss', 'answer_on_proactive', 'temp_answer', 'tech_close',
                                 'comment_ml', 'communicate_ml', 'reopen', 'close', 'comment', 'close_ml',
                                 'defer_with_answer', 'create', 'new_message',
                                 'communicate', 'call_success', 'forward', 'take', 'dismiss', 'assign', 'appear',
                                 'proactive_support', 'proactive_message')
        OR csat_value IN (5, 4, 3, 2, 1)
        OR a.promocode_id IS NOT NULL)
        WINDOW w AS (PARTITION BY a.ticket_id ORDER BY a.event_number)
) DISTRIBUTED BY (ticket_session);
ANALYZE tickets_actions;


CREATE TEMPORARY TABLE pre_theme
    ON COMMIT DROP
AS (
    SELECT ticket_session,
           theme
    FROM (
             SELECT ticket_session,
                    theme,
                    ROW_NUMBER() OVER w AS rank
             FROM tickets_actions
                 WINDOW w AS (PARTITION BY ticket_session
                     ORDER BY CASE
                                  WHEN LENGTH(theme) = 0 OR LENGTH(theme) IS NULL
                                      THEN CAST(-1 AS DOUBLE PRECISION)
                                  WHEN theme = 'Unknown::Unknown::Unknown::Unknown'
                                      THEN CAST(0 AS DOUBLE PRECISION)
                                  ELSE CARDINALITY(string_to_array(COALESCE(theme, ''), '::')) -
                                       1 / CAST(LENGTH(theme) AS DOUBLE PRECISION)
                         END DESC
                     )
         ) AS a
    WHERE rank = 1
) DISTRIBUTED BY (ticket_session);
ANALYZE pre_theme;


-- $chatterbox_history
drop table if exists chatterbox_history;
CREATE TEMPORARY TABLE chatterbox_history
    ON COMMIT DROP
AS (
    SELECT a.utc_event_dttm  AS utc_attribution_dttm
         , a.event_number
         , a.ticket_id       AS ticket_id
         , a.meta_event_name AS meta_action
         , c.target_sla_mnt  AS sla_good
    FROM taxi_cdm_contactcenter.fct_ticket_action_markup a
             LEFT JOIN taxi_ods_chatterbox_support_taxi.sector_mapping c
                       ON c.sector_name = a.sector_name
    WHERE a.utc_event_dttm::DATE between (SELECT start_date FROM start_date) and (SELECT end_date FROM end_date)
) DISTRIBUTED BY (ticket_id);
ANALYZE chatterbox_history;


-- $first_reply
CREATE TEMPORARY TABLE first_reply
    ON COMMIT DROP
AS (
    SELECT utc_attribution_dttm
         , event_number
         , sla_good
         , ticket_id
         , meta_action
         , CASE
               WHEN meta_action IN
                    ('create', 'new_message', 'reopen', 'reopen_after_dismiss', 'answer_on_proactive') AND
                    (LEAD(meta_action) OVER w IS NULL
                        OR LEAD(meta_action) OVER w = 'close_backlog')
                   THEN NULL
               WHEN
                           meta_action IN
                           ('create', 'new_message', 'reopen', 'reopen_after_dismiss', 'answer_on_proactive')
                       AND LEAD(meta_action) OVER w IN
                           ('comment', 'communicate', 'call_success', 'close', 'temp_answer', 'comment_ml',
                            'communicate_ml',
                            'close_ml', 'defer_with_answer', 'tech_close')
                   THEN extract(epoch from LEAD(utc_attribution_dttm) OVER w - utc_attribution_dttm) / 60
               ELSE -1
        END AS first_reply
    FROM (
             SELECT utc_attribution_dttm
                  , event_number
                  , meta_action
                  , sla_good
                  , ticket_id
             FROM chatterbox_history
             WHERE meta_action IN
                   ('create', 'appear', 'new_message', 'reopen', 'reopen_after_dismiss', 'answer_on_proactive',
                    'comment', 'communicate', 'call_success',
                    'close', 'temp_answer', 'comment_ml', 'communicate_ml', 'close_ml', 'defer_with_answer',
                    'close_backlog',
                    'tech_close', 'proactive_message', 'finish_archive')
                 WINDOW w AS (PARTITION BY ticket_id
                     ORDER BY event_number
                     ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING
                     )
         ) t
    WHERE meta_action IN
          ('create', 'new_message', 'reopen', 'reopen_after_dismiss', 'answer_on_proactive',
           'comment', 'communicate', 'call_success', 'close', 'temp_answer', 'comment_ml', 'communicate_ml', 'close_ml',
           'defer_with_answer', 'close_backlog', 'tech_close', 'proactive_message', 'finish_archive')
        WINDOW w AS (PARTITION BY ticket_id
            ORDER BY event_number)
) DISTRIBUTED BY (ticket_id);
ANALYZE first_reply;


-- $session_sector_exclude
CREATE TEMPORARY TABLE session_sector_exclude
    ON COMMIT DROP
AS (
    SELECT ticket_session,
           sector
    FROM tickets_actions
    WHERE exclude_flg = true
) DISTRIBUTED BY (ticket_session);
ANALYZE session_sector_exclude;


-- $pre_with_sla
drop table if exists pre_with_sla;
CREATE TEMPORARY TABLE pre_with_sla
    ON COMMIT DROP
AS (
    SELECT a.with_reopen        AS with_reopen,
           a.csat_value         AS csat_value,
           a.promo_code         AS promo_code,
           a.solve_time         AS solve_time,
           a.ticket_id          AS ticket_id,
           a.ticket_session     AS ticket_session,
           a.sector             AS sector,
           a.country            as country,
           a.city               as city,
           a.corp_client_id     as corp_client_id,
           a.utc_attribution_dt AS utc_attribution_dt,
           p.theme              AS theme,
           b.first_reply        AS first_reply,
           b.sla_good           AS sla_good,
           a.overall            AS overall
    FROM tickets_actions AS a
             JOIN pre_theme AS p
                  ON a.ticket_session = p.ticket_session
             LEFT JOIN first_reply AS b
                       ON a.ticket_id = b.ticket_id AND a.utc_attribution_dttm = b.utc_attribution_dttm
) DISTRIBUTED BY (ticket_session);
ANALYZE pre_with_sla;


-- $pre_new
drop table if exists pre_new;
CREATE TEMPORARY TABLE pre_new
    ON COMMIT DROP
AS (
    SELECT utc_attribution_dt,
           ticket_id,
           ticket_session,
           theme,
           sector,
           country,
           city,
           corp_client_id,
           COUNT(promo_code) AS promo_code_count,
           CASE
               WHEN COUNT(CASE WHEN with_reopen = true THEN 1 END) > 0
                   THEN true
               ELSE false
               END           AS with_reopen,
           max(first_reply)  AS first_reply,
           max(csat_value)   AS csat_value,
           max(solve_time)   AS solve_time,
           max(sla_good)     AS sla_good,
           SUM(overall)      AS overall
    FROM pre_with_sla
    GROUP BY utc_attribution_dt,
             ticket_id,
             ticket_session,
             theme,
             sector,
             country,
             city,
             corp_client_id
) DISTRIBUTED BY (ticket_session);
ANALYZE pre_new;


-- $pre_0_1
CREATE TEMPORARY TABLE pre_0_1
    ON COMMIT DROP
AS (
    SELECT utc_attribution_dt,
           ticket_id,
           country,
           city,
           corp_client_id,
           p.ticket_session AS ticket_session,
           theme,
           p.sector         AS sector,
           promo_code_count,
           with_reopen,
           first_reply,
           csat_value,
           solve_time,
           sla_good,
           overall
    FROM pre_new AS p
             LEFT JOIN session_sector_exclude AS sse
                       ON p.ticket_session = sse.ticket_session
                           AND p.sector = sse.sector
    WHERE sse.ticket_session IS NULL
) DISTRIBUTED BY (ticket_session);
ANALYZE pre_0_1;


-- $pre_1
drop table if exists pre_1;
CREATE TEMPORARY TABLE pre_1
    ON COMMIT DROP
AS (
    SELECT COUNT(CASE WHEN with_reopen = true THEN with_reopen END)                             AS reopens,
           COUNT(CASE WHEN csat_value IS NOT NULL THEN 1 END)                                   AS csat_count,
           AVG(csat_value)                                                                      AS csat_value,
           SUM(promo_code_count)                                                                AS promocode_count,
           SUM(solve_time)                                                                      AS solve_time,
           AVG(CASE WHEN csat_value IS NOT NULL AND first_reply < sla_good THEN csat_value END) AS avg_csat_good,
           COUNT(CASE WHEN csat_value IS NOT NULL AND first_reply < sla_good THEN 1 END)        AS csat_good_count,
           COUNT(CASE WHEN first_reply < sla_good THEN 1 END)                                   AS solved_good,
           max(overall)                                                                         AS overall,
           tt.ticket_id                                                                         AS ticket_id,
           tt.ticket_session                                                                    AS ticket_session,
           tt.country                                                                           as country,
           tt.city                                                                              as city,
           tt.corp_client_id                                                                    as corp_client_id,
           tt.sector                                                                            AS sector,
           tt.utc_attribution_dt                                                                AS utc_attribution_dt,
           tt.theme                                                                             AS theme
    FROM pre_0_1 AS tt
    GROUP BY tt.ticket_id,
             tt.ticket_session,
             tt.country,
             tt.city,
             tt.corp_client_id,
             tt.sector,
             tt.utc_attribution_dt,
             tt.theme
) DISTRIBUTED BY (
    country, city, corp_client_id, sector, theme);
ANALYZE pre_1;


-- $pre
CREATE TEMPORARY TABLE pre
    ON COMMIT DROP
AS (
    SELECT SUM(overall)         AS tickets,
           SUM(reopens)         AS reopens,
           CASE
               WHEN SUM(csat_count) IS NULL OR SUM(csat_count) = 0
                   THEN 0
               ELSE CAST(SUM(COALESCE(csat_value, 0) * COALESCE(csat_count, 0)) AS DOUBLE PRECISION) /
                    CAST(SUM(csat_count) AS DOUBLE PRECISION)
               END              AS csat_value,
           CASE
               WHEN SUM(csat_count) IS NULL OR SUM(csat_count) = 0
                   THEN 0
               ELSE CAST(SUM(COALESCE(csat_value, 0) * COALESCE(csat_count, 0)) AS DOUBLE PRECISION) /
                    CAST(SUM(csat_count) AS DOUBLE PRECISION)
               END              AS csat_impact,
           SUM(csat_count)      AS csat_count,
           CASE
               WHEN SUM(csat_good_count) IS NULL OR SUM(csat_good_count) = 0
                   THEN 0
               ELSE CAST(SUM(COALESCE(avg_csat_good, 0) * COALESCE(csat_good_count, 0)) AS DOUBLE PRECISION) /
                    CAST(SUM(csat_good_count) AS DOUBLE PRECISION)
               END              AS csat_good_value,
           SUM(csat_good_count) AS csat_good_count,
           SUM(promocode_count) AS promocode_count,
           SUM(promocode_count) AS promocode_count_perc,
           AVG(solve_time)      AS solve_time,
           SUM(solved_good)     AS solved_good,
           SUM(solved_good)     AS solved_good_perc,
           country,
           city,
           corp_client_id,
           sector,
           utc_attribution_dt,
           theme
    FROM pre_1
    GROUP BY country, city, corp_client_id,
             utc_attribution_dt, sector, theme
) DISTRIBUTED BY (country, city, corp_client_id, sector, theme);
ANALYZE pre;


CREATE TEMPORARY TABLE result_table
    ON COMMIT DROP
AS (
    SELECT utc_attribution_dt AS utc_attribution_dt,
           country,
           city,
           corp_client_id,
           sector             AS sector_name,
           theme              AS theme_name,
           metric_name,
           metric_value,
           CASE
               WHEN metric_name IN ('csat_value', 'csat_impact') THEN COALESCE(csat_count, 0) --перевзвешиваем
               WHEN metric_name IN ('promocode_sum', 'avg_promocode_value')
                   THEN COALESCE(promocode_count, 0) --перевзвешиваем
               WHEN metric_name = 'csat_good_value' THEN COALESCE(csat_good_count, 0)--перевзвешиваем
               WHEN metric_name IN
                    ('promocode_count_perc', 'promocode_rub_use_count_perc', 'solved_good_perc', 'solve_time')
                   THEN COALESCE(tickets, 0) --процент промокодов от тикетов в тематиках
               ELSE NULL END  AS sub_metric_value
    FROM (
             SELECT utc_attribution_dt,
                    country,
                    city,
                    corp_client_id,
                    sector,
                    theme,
                    tickets,
                    reopens,
                    csat_count,
                    csat_good_count,
                    solved_good,
                    promocode_count,
                    unnest(array ['csat_value', 'csat_impact',
                        'csat_good_value', 'solved_good',
                        'promocode_count_perc', 'solved_good_perc', 'solve_time',
                        'tickets', 'reopens', 'csat_count', 'promocode_count', 'csat_good_count'
                        ])
                        AS metric_name,
                    unnest(array [csat_value, csat_impact,
                        csat_good_value, solved_good,
                        promocode_count_perc, solved_good_perc, solve_time,
                        tickets, reopens, csat_count, promocode_count, csat_good_count
                        ])
                        AS metric_value
             FROM pre
         ) AS a
    LEFT JOIN taxi_ods_support_gd.sector_meta_information b
    ON a.sector = b.sector_code
    WHERE metric_name NOT IN ('csat_count', 'csat_good_count')
      AND metric_value IS NOT NULL
      AND b.service_name_en = 'logistics'
) DISTRIBUTED BY (country, city, corp_client_id, sector_name, metric_name, theme_name);
ANALYZE result_table;


truncate table snb_delivery.support_fct_thematic_sector_board;
insert into snb_delivery.support_fct_thematic_sector_board
(_etl_processed_dttm, country, city, corp_client_id, sector_name, theme_name, metric_name, metric_value,
 sub_metric_value,
 utc_attribution_dt)
SELECT now()              as _etl_processed_dttm
     , country            as country
     , city               as city
     , corp_client_id     as corp_client_id
     , sector_name        as sector_name
     , theme_name         as theme_name
     , metric_name        as metric_name
     , metric_value       as metric_value
     , sub_metric_value   as sub_metric_value
     , utc_attribution_dt as utc_attribution_dt
FROM result_table;