# -*- coding: utf-8 -*-

import logging
from os import environ
import yt.wrapper as yt
from startrek_client import Startrek

client = Startrek(
    useragent="python client",
    base_url="https://st-api.yandex-team.ru",
    token=environ.get("TRACKER_TOKEN")
)

_LOG = logging.getLogger(__name__)
logging.basicConfig(level=logging.INFO)


def main():
    _LOG.info("start")
    for i in range(1, 28128):
        key = "CORPINVOICE-" + str(i)
        try:
            issue = client.issues[key]
        except BaseException:
            print(key)
            continue
        order_id = getattr(issue, "order_id", False)
        if not order_id:
            try:
                description = issue.description.split()
                order_id = description[description.index("заказа::") + 1]
                issue.update(**{"607580bed082d8793a2c48eb--order_id": order_id})
                print(order_id)
            except (ValueError, BaseException) as e:
                print(key, e)


if __name__ == "__main__":
    yt.config.set_proxy("hahn")
    main()
