# -*- coding: utf-8 -*-

import logging
from os import environ
import yt.wrapper as yt
from startrek_client import Startrek

client = Startrek(
    useragent="python client",
    base_url="https://st-api.yandex-team.ru",
    token=environ.get("TRACKER_TOKEN")
)

_LOG = logging.getLogger(__name__)
logging.basicConfig(level=logging.INFO)


def main():
    _LOG.info("start")
    issues = client.issues.find('Queue: CORPINVOICE type: newFeature status: Открыт')
    for issue in issues:
        print(issue.key)
        issue.update(**{"607580bed082d8793a2c48eb--tier": 1})
        issue.update(company="Я.Маркет")
        transition = issue.transitions['closed']
        transition.execute(
            comment="Автоматическое закрытие тикета. https://st.yandex-team.ru/LOGDATA-1492 ",
            resolution="dontDo"
        )


if __name__ == "__main__":
    yt.config.set_proxy("hahn")
    main()
