# -*- coding: utf-8 -*-

import logging
from os import environ
import yt.wrapper as yt
from startrek_client import Startrek

client = Startrek(
    useragent="python client",
    base_url="https://st-api.yandex-team.ru",
    token=environ.get("TRACKER_TOKEN")
)

_LOG = logging.getLogger(__name__)
logging.basicConfig(level=logging.INFO)


def main():
    _LOG.info("start")
    for i in range(34882, 1, -1):
        key = "CORPINVOICE-" + str(i)
        try:
            issue = client.issues[key]
        except BaseException:
            print(key)
            continue

        comments = list(issue.comments.get_all())
        courier_guilt = False
        service_guilt = False
        for comment in comments:
            if "вина курьера: да" in comment.text.lower():
                courier_guilt = True
            if "вина сервиса: да" in comment.text.lower():
                service_guilt = True

        if courier_guilt and service_guilt:
            issue.update(**{"607580bed082d8793a2c48eb--culprit_compensation": "Обоюдно"})
        elif courier_guilt:
            issue.update(**{"607580bed082d8793a2c48eb--culprit_compensation": "Курьер"})
        elif service_guilt:
            issue.update(**{"607580bed082d8793a2c48eb--culprit_compensation": "Сервис"})


if __name__ == "__main__":
    yt.config.set_proxy("hahn")
    main()
