import argparse
from collections import Counter
import time
import re

import datetime
from nile.api.v1 import aggregators as na
from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from nile.api.v1 import Record
from qb2.api.v1 import filters as qf
import numpy as np


from projects.batching.batching_custom_params import (
    VKUSVILL_CORP_CLIENT_ID, VV_ADDRESSES, VV_ADDRESSES_IDS,
    YARCHE_CORP_CLIENT_ID, YARCHE_ADDRESSES
)
from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as OrdersSessionsLogsDataContext

from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawServicesLogsDataContext
from projects.efficiency_metrics.project_config import get_project_cluster
from projects.batching.nile_blocks.corps import calc_a_density_reducer
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawLogs

if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    # parser.add_argument('--yt-path-dir-to', type=str,
    #                     default='//home/taxi-delivery/analytics/dev/{}')
    parser.add_argument('--start-date', type=str)
    parser.add_argument('--finish-date', type=str)

    args = parser.parse_args()

    cluster = get_project_cluster()

    # yt_path_dir_to = args.yt_path_dir_to
    start_date = args.start_date
    finish_date = args.finish_date

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(
        bytes_decode_mode='strict',
        yt_spec_defaults={'max_failed_job_count': 1000}
    )

    # job.table()

    # raw_logs_dc = RawLogs(
    #     job,
    #     datetime.datetime.strptime(start_date, '%Y-%m-%d'),
    #     datetime.datetime.strptime(finish_date, '%Y-%m-%d')
    # ).get_taxi_priority().filter(
    #     nf.custom(lambda x: x in ['samara', 'voronezh'], 'tariff_zone'),
    #     nf.custom(lambda x: 'auto_courier' in x, 'tags')
    # ).put('//home/taxi-delivery/analytics/dev/alive_batching/all')

    def _reducer(groups):
        for key, records in groups:

            _list = []
            for record in records:
                _list.append('multipoints' in record.tags)

            _l = []
            for el in _list:
                if len(_l) == 0:
                    _l.append(el)
                if el == _l[-1]:
                    continue
                if el != _l[-1]:
                    _l.append(el)

            yield Record(
                record,
                multipoints=_l
            )

    # job.table('//home/taxi-delivery/analytics/dev/alive_batching/all').groupby(
    #     'dbid_uuid'
    # ).sort(
    #     'timestamp_tp'
    # ).reduce(
    #     _reducer
    # ).put(
    #     '//home/taxi-delivery/analytics/dev/alive_batching/all_tagged'
    # )

    # job.table(
    #     '//home/taxi-delivery/analytics/dev/alive_batching/all_tagged'
    # ).filter(
    #     nf.custom(
    #         lambda x: x[-1] == True, 'multipoints'
    #     ),
    #     nf.custom(
    #         lambda x: len(x) > 1, 'multipoints'
    #     )
    # ).put(
    #     '//home/taxi-delivery/analytics/dev/alive_batching/all_tagged_filtered'
    # )

    # job.concat(
    #     job.table('//home/taxi-delivery/analytics/dev/alive_batching/all_tagged_filtered')
    # ).project(
    #     'dbid_uuid',
    #     tag=ne.const('cargo_dragon_batch_order_testing')
    # ).put(
    #     '//home/taxi-delivery/analytics/dev/alive_batching/all_tagged_filtered_tags'
    # )

    # job.table('//home/taxi-dwh/ods/mdb/order/2021-06-01').filter(
    #     nf.custom(lambda x: x in ['moscow'], 'tariff_zone')
    # ).project(
    #     ne.all(),
    #     # tariff_=ne.custom(lambda x: ('courier' in x) or ('express' in x), 'user_tariff_classes')
    # ).filter(
    #     nf.custom(lambda x: ('courier' in x) or ('express' in x), 'user_tariff_classes')
    # ).groupby(
    #     # 'order_source'
    #     'application'
    # ).aggregate(
    #     cnt=na.count()
    # ).put(
    #     '//home/taxi-delivery/analytics/dev/alive_batching/courier_express_disrt'
    # )
    # job.table('//home/taxi-dwh/ods/mdb/order/2021-06-01').filter(
    #     nf.custom(lambda x: x in ['moscow'], 'tariff_zone'),
    #     nf.custom(lambda x: x == 'agent_gepard', 'application'),
    #     nf.custom(lambda x: ('econom' in x),
    #               'user_tariff_classes')
    # ).project(
    #     ne.all(),
    #     utc_date=ne.custom(lambda x: x[:10], 'utc_order_created_dttm'),
    #     utc_date_hour=ne.custom(lambda x: x[:13], 'utc_order_created_dttm')
    #     # tariff_=ne.custom(lambda x: ('courier' in x) or ('express' in x), 'user_tariff_classes')
    # ).groupby(
    #     'utc_date_hour'
    # ).aggregate(
    #     cnt=na.count()
    # ).sort(
    #     'utc_date_hour'
    # ).put(
    #     '//home/taxi-delivery/analytics/dev/alive_batching/gepard_hour_econom'
    # )
    #
    job.table('//home/taxi-dwh/ods/mdb/order/2021-06-01').filter(
        nf.custom(lambda x: x in ['moscow'], 'tariff_zone'),
        nf.custom(lambda x: x == 'agent_gepard', 'application'),
        nf.custom(lambda x: ('econom' in x),
                  'user_tariff_classes')
    ).project(
        ne.all(),
        utc_date=ne.custom(lambda x: x[:10], 'utc_order_created_dttm'),
        utc_date_hour=ne.custom(lambda x: x[:13], 'utc_order_created_dttm')
        # tariff_=ne.custom(lambda x: ('courier' in x) or ('express' in x), 'user_tariff_classes')
    ).groupby(
        'utc_date'
    ).aggregate(
        cnt=na.count()
    ).sort(
        'utc_date'
    ).put(
        '//home/taxi-delivery/analytics/dev/alive_batching/gepard_daily_econom'
    )
    # .groupby(
    #         'utc_date'
    #         # 'application'
    #     ).aggregate(
    #         cnt=na.count()
    #     )

    # job.table('//home/taxi-dwh/ods/mdb/order/2021-06-01').filter(
    #     nf.custom(lambda x: x in ['moscow'], 'tariff_zone')
    # ).project(
    #     ne.all(),
    #     tariff_=ne.custom(lambda x: ('courier' in x) or ('express' in x), 'user_tariff_classes')
    # ).join(
    #     job.table('//home/taxi/production/replica/postgres/cargo_claims/claims'),
    #     type='inner', by_left='order_id', by_right='taxi_order_id'
    # ).groupby(
    #     'order_source'
    #     # 'application'
    # ).aggregate(
    #     cnt=na.count()
    # ).put(
    #     '//home/taxi-delivery/analytics/dev/alive_batching/order_2_claims_msc_source'
    # )
    #
    # job.table('//home/taxi-dwh/ods/mdb/order/2021-06-01').filter(
    #     nf.custom(lambda x: x in ['moscow'], 'tariff_zone')
    # ).project(
    #     ne.all(),
    #     tariff_=ne.custom(lambda x: ('courier' in x) or ('express' in x), 'user_tariff_classes')
    # ).groupby(
    #     'order_source'
    #     # 'application'
    # ).aggregate(
    #     cnt=na.count()
    # ).put(
    #     '//home/taxi-delivery/analytics/dev/alive_batching/order_msc_source'
    # )


    # -- select application, count(*) as cnt
    # select * from `//home/taxi-dwh/ods/mdb/order/2021-06-01` as a
    # inner join `//home/taxi/production/replica/postgres/cargo_claims/claims` as b
    # on a.order_id = b.taxi_order_id
    #
    # -- where ((
    # --     ListHas(Yson::ConvertToStringList( a.user_tariff_classes), 'courier')
    # --     or
    # --     ListHas(Yson::ConvertToStringList( a.user_tariff_classes), 'express')
    # --     ) and a.tariff_zone='moscow') --group by application

    # import geohash as gh
    # job.table('//home/taxi-delivery/analytics/production/claims_logs/2021-06-18/cl_p_s_w_o_st_final').project(
    #     'zone_id',
    #     geo_hash_4=ne.custom(lambda x, y: gh.encode(x, y, precision=4),
    #                          'latitude', 'longitude'),  # 'lat', 'lon')
    #     geo_hash_5=ne.custom(lambda x, y: gh.encode(x, y, precision=5),
    #                        'latitude', 'longitude'),#'lat', 'lon')
    #     geo_hash_6=ne.custom(lambda x, y: gh.encode(x, y, precision=6),
    #                        'latitude', 'longitude')  # 'lat', 'lon')
    # ).groupby('geo_hash_4', 'zone_id').aggregate(
    #     geo_hash_4_cnt=na.count()
    # ).put(
    #     '//home/taxi-delivery/analytics/production/claims_logs/2021-06-18/zones'
    # )

    job.run()