import argparse
from collections import Counter
from itertools import chain
import time
import re

import datetime
import six
from nile.api.v1 import aggregators as na
from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from nile.api.v1 import Record
from qb2.api.v1 import filters as qf
from qb2.api.v1 import typing as qt


from projects.batching.batching_custom_params import (
    YARCHE_ADDRESSES, VV_ADDRESSES_TMP
)
from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as OrdersSessionsLogsDataContext
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawServicesLogsDataContext
from projects.efficiency_metrics.project_config import get_project_cluster
from projects.batching.nile_blocks.corps import calc_a_density_reducer
from projects.common.gp_transfer import transfer_from_yt_2_gp


def calc_main_metrics_reducer(groups):
    for key, records in groups:
        n_claims = 0
        unique_taxi_orders = set()
        n_claims_ld = 0
        waybill_counter = Counter()
        for record in records:
            n_claims += 1
            unique_taxi_orders.add(record.taxi_order_id)
            n_claims_ld += ('logistic-dispatch' in record.chosen_waybill
                            if record.get('chosen_waybill') else 0)
            waybill_counter[record.chosen_waybill] += 1
        n_unique_taxi_orders = len(unique_taxi_orders)
        n_batched = sum([el for el in waybill_counter.values() if el > 1])
        yield Record(
            key,
            n_claims_ld=n_claims_ld,
            n_claims=n_claims,
            n_unique_taxi_orders=n_unique_taxi_orders,
            # n_batched_pairs=(n_claims - n_unique_taxi_orders) * 2,
            n_batched=n_batched,
            batched_share=(n_batched * 1. / n_claims)
            # batched_share=(n_claims - n_unique_taxi_orders) * 2 / n_claims
        )


if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    # parser.add_argument(
    #     '--yt-path-dir-to', type=str,
    #     default='//home/taxi-delivery/analytics/dev/batching/dead/{}'
    # )
    # parser.add_argument('--start-date', type=str)
    # parser.add_argument('--finish-date', type=str)
    #
    # args = parser.parse_args()

    cluster = get_project_cluster()

    # yt_path_dir_to = args.yt_path_dir_to
    # start_date = args.start_date
    # finish_date = args.finish_date

    # DATE = '2021-06-18'
    DATE = '2021-07-16'
    # DATE = '2021-07-25'

    with open('/home/nkozlovskaya/projects/pycharm_2_0/logistics-platform-analytics/projects/projects/burnt_orders_research/sla_120_sec.txt') as f:
        sla_120_sec = f.read().strip().split('\n')

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(
        bytes_decode_mode='strict',
        yt_spec_defaults={'max_failed_job_count': 1000}
    )
    tmp = job.table('//home/taxi-delivery/analytics/dev/batching/dead_tmp/{}/cl_p_s_w_o_st_final'.format(
        DATE
    )
    ).filter(
        nf.custom(lambda x: x != 'platform_usage', 'claim_kind'),
        # nf.custom(lambda x: x == '2021-06-15', 'utc_date'),
        nf.custom(lambda x: x in ['voronezh'], 'zone_id'), #, 'samara'
        nf.custom(lambda x: x == False, 'is_delayed'),
        nf.custom(lambda x: x in sla_120_sec, 'corp_client_id'),
        nf.custom(lambda x: x > 1626307200, 'timestamp'),
        nf.custom(lambda x: x < 1626393600, 'timestamp')
    ).sort(
        'timestamp', 'longitude', 'corp_client_id' #, 'taxi_order_id'
    ).put(
        '//home/taxi-delivery/analytics/production/claims_logs/{}/cl_p_s_w_o_st_final_'.format(DATE)
    )

    # job.table(
    #     '//home/taxi-delivery/analytics/dev/batching/dead_tmp/2021-06-16/cl_p_s_w_o_st_final_'
    # )\
    # tmp.join(
    #     job.table('//home/taxi/production/replica/postgres/cargo_orders/orders_performers').project(
    #         dbid_uuid=ne.custom(lambda x, y: '{}_{}'.format(x, y), 'park_id', 'driver_id'),
    #         cargo_order_id='order_id'
    #     ),
    #     type='inner', by='cargo_order_id'
    # ).filter(
    #     qf.defined('sec_till_delivered_returned')
    # ).project(
    #     ne.all(),
    #     timestamp_from='timestamp',
    #     timestamp_to=ne.custom(
    #         lambda x, y: (x + y), 'timestamp', 'sec_till_delivered_returned'
    #     )
    # ).put(
    #     '//home/taxi-delivery/analytics/production/claims_logs/{}/cl_p_s_w_o_st_final_ts_'.format(DATE)
    # )

    # .join(
    #         job.table('//home/taxi-delivery/analytics/dev/alive_batching/all_tagged_filtered_tags'),
    #         type='inner', by
    #     )





    job.run()