
import argparse
from collections import Counter
from itertools import chain
import time
import re

import json

import datetime
import six
from nile.api.v1 import aggregators as na
from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from nile.api.v1 import Record
from qb2.api.v1 import filters as qf
from qb2.api.v1 import typing as qt

from projects.common.nile.dates import range_selector
from projects.common.time_utils import datetime_2_timestamp, \
    parse_timestring

from projects.batching.launcher_2 import calc_time_till_cancell
from projects.batching.batching_custom_params import (
    YARCHE_ADDRESSES, VV_ADDRESSES_TMP
)
from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as OrdersSessionsLogsDataContext
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawServicesLogsDataContext
from projects.efficiency_metrics.project_config import get_project_cluster
from projects.batching.nile_blocks.corps import calc_a_density_reducer
from projects.common.gp_transfer import transfer_from_yt_2_gp




if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    # parser.add_argument('--dttm', type=str)
    # parser.add_argument(
    #     '--yt-path-dir-to', type=str,
    #     default='//home/taxi-delivery/analytics/dev/batching/dead/{}'
    # )
    # parser.add_argument('--start-date', type=str)
    # parser.add_argument('--finish-date', type=str)
    cluster = get_project_cluster()

    args = parser.parse_args()

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(
        bytes_decode_mode='strict',
        yt_spec_defaults={'max_failed_job_count': 2000}
    )

    # job.table(
    #     '//home/taxi-delivery/analytics/production/batch/batch_progress/data_for_Evgen_dash'
    # ).project(
    #     'taxi_order_id', 'batched_claim_marker', 'date_key'
    # ).filter(
    #     nf.custom(lambda x: x == 'batched claim', 'batched_claim_marker')
    #
    # ).unique('taxi_order_id')


    job.table(
        '//home/taxi-delivery/analytics/production/batch/aggregated_view/time_metrics'
    ).filter(
        nf.custom(lambda x: x == 'delivery', 'client_marker_batch'),
        nf.custom(lambda x: x >= '2021-11-17', 'date_key')
    ).project(
        'type_of_batch', 'date_key', 'waybill_id', 'batch_prettiness', 'route'

    ).join(
        job.table('//home/taxi-delivery/analytics/production/b2b_claims_monthly/2021-11-01').project(
            'waybill_external_ref', taxi_order_id='claim_taxi_order_id'
        ), by_left='waybill_id', by_right='waybill_external_ref', type='left'
    ).join(
        job.table('//home/taxi_ml/production/support/data/support_data').filter(
            qf.defined('meta_collect_data')
        ).project(
            'chatterbox_ticket',
            'first_message_text_CB',
            taxi_order_id=ne.custom(lambda x: x.get('order_id'), 'meta_collect_data')
        ), by='taxi_order_id', type='inner'
    ).put(
        '//home/taxi-delivery/analytics/dev/alive_batching/batch_2_support_v3'
    )


    # REJECT_REASON = 'different-corp-client-ids'
    # REJECT_REASON = 'l1-too-big-mileage-increase'
    REJECT_REASON = 'logistic-group-denies'
    # # 'out-of-geoarea-attractor'
    # # 'too-heavy-edge'
    # REJECT_REASON = 'too-long-proposition'

    # job.table(
    #     # '//home/taxi-delivery/analytics/production/ld/dispatch_metrics/claims_ld_stages_2021-06-27'
    #     '//home/taxi-delivery/analytics/production/ld/dispatch_metrics/calc_different_stats'
    # ).project(
    #     'segment_id',
    #     reject_reasons=ne.custom(lambda x: [el_dict['kind'] for el_dict in x], 'suspicious_entries')
    # ).put(
    #     '//home/taxi-delivery/analytics/production/ld/dispatch_metrics/reject_2021-06-27_{}'.format(REJECT_REASON)
    # )

    #.filter(
    #     nf.custom(
    #         lambda x:
    #         REJECT_REASON in [el_dict['kind'] for el_dict in x],
    #         'suspicious_entries'
    #     )
    # )

    job.run()

