import os
import json

from dotenv import load_dotenv

from gptransfer_client import GPTransferClient

from nile.api.v1 import (
    clusters,
    aggregators as na,
    extractors as ne
)

from qb2.api.v1 import extractors as se
from qb2.api.v1.typing import String, Int64, UInt64, Float



PYTHON3_LAYERS = [
    '//porto_layers/ubuntu-xenial-base.tar.xz',
    '//statbox/home/komendart/porto/nile_python3.7.tar.gz',
]

config = {
    'source_path':  '//home/taxi/production/replica/postgres/cargo_claims/claim_points',
    'interim_path': '//home/taxi-delivery/dev/kulichevskiy_claim_points',
    'final_path':   'analyst.nkozlovskaya_claim_points',
    'interim_schema': {
        'hash':     String,
        'id':       UInt64,
        'claim_id': UInt64,
        'sharing_key': String,
        'type':        String,
        'updated_ts':  Float,
        'return_comment': String,
        'uuid':           String,
        'visit_order':    UInt64,
        'visit_status':   String,
        'last_status_change_ts': Float,
        'skip_confirmation':     String,
        'point_id': UInt64,
        'uuid': String,
    },
    'source_schema': {
        'skip': [
            'id',
            'claim_id',
            'last_status_change_ts',
            'return_comment',
            'sharing_key',
            'type',
            'updated_ts',
            'uuid',
            'visit_order',
            'visit_status',
            'point_id',
        ],
        'convert': ['hash', 'skip_confirmation']
    }
}

cluster = clusters.YT("hahn")
# job = cluster.job()
#
# job = job.env(
#     yt_spec_defaults=dict(
#         mapper=dict(layer_paths=PYTHON3_LAYERS),
#         reducer=dict(layer_paths=PYTHON3_LAYERS),
#     )
# )
#
# result = (
#     job
#     .table(config['source_path'])
#     .project(
#         config['source_schema']['skip'],
#         se.custom('hash', lambda x: str(x), 'hash').with_type(str),
#         se.custom(
#             'skip_confirmation', lambda x: str(x), 'skip_confirmation'
#         ).with_type(str),
#     )
# )
#
# result.put(
#     path=config['interim_path'],
#     schema=config['interim_schema']
# )
#
# job.run()

# print (os.environ.get('GP_TRANSFER_TOKEN'))
#
# client = GPTransferClient(
#     token=os.environ.get('GP_TRANSFER_TOKEN'),
#     gp_user=os.environ.get('USER_NAME'),
#     gp_password=os.environ.get('GP_TOKEN'),

#     host='https://gptransfer.taxi.yandex.net',
#     verify_https=False
# )
import business_models
# business_models.greenplum.grant(
#     'analyst.nkozlovskaya_market', 'select', 'analyst',
#     gp_token=os.environ.get('GP_TOKEN')
# )

from business_models import greenplum
greenplum.dump('analyst.nkozlovskaya_market', '//tmp/nkozlovskaya/market', chunksize=5*10**5)

# process_uuid = client.yt_to_gp(
#    yt_table_path = config['interim_path'],
#    gp_table_name = config['final_path'],
#    column_list   = config['source_schema']['skip'] + config['source_schema']['convert']
# )

# process_uuid = client.gp_to_yt(
#    yt_table_path='//home/taxi-delivery/analytics/dev/burning_research/tmp/market', # целевая таблица должна быть создана
#    gp_table_name='analyst.nkozlovskaya_market',
#    column_list=['external_id', 'taxi_dispatch_cargo_uuid_id', 'claim_segment_uuid']
# )
#
# status = client.wait_till_finish(
#     process_uuid,
#     seconds_to_sleep=20,
#     timeout=5*60  # wait for 5 minutes
# )
#
# status