import argparse
# import time

import datetime

# from projects.efficiency_metrics.manager import Manager
from projects.efficiency_metrics.project_config import get_project_cluster
from nile.api.v1 import Record

from projects.batching.nile_blocks.orders import calc_net_income_mapper

if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    # parser.add_argument('--yt-path-to', required=True, type=str)
    # parser.add_argument('--from-date-hour', required=True, type=str)
    # parser.add_argument('--to-date-hour', required=True, type=str)
    # parser.add_argument('--city', required=True, type=str)
    # parser.add_argument(
    #     '--steps',
    #     required=True,
    #     nargs='+',
    #     choices=[
    #         'prepare_data',
    #         # 'calculate_metrics_by_tz'
    #         # 'calculate_metrics_by_performer',
    #     ],
    # )

    args = parser.parse_args()


    cluster = get_project_cluster()

    yt_path_dir_to = '//home/taxi-delivery/analytics/dev/{}'
    #
    from projects.data_sources.data_context.raw_services_logs import \
        DataContext as RawLogs

    from projects.data_sources.data_context.cargo import \
        DataContext as CargoLogsDataContext

    from projects.data_sources.data_context.raworders_dmorders_sessions import \
        DataContext as OrdersSessionsLogsDataContext

    import time

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(bytes_decode_mode='strict', yt_spec_defaults={'max_failed_job_count': 1000})

    VKUSVILL_CORP_CLIENT_ID = '27751a2d0b534affb80d243bc2f68981'
    from nile.api.v1 import filters as nf

    # start_date = '2021-02-07'
    # finish_date = '2021-02-15'
    start_date = '2021-02-15'
    finish_date = '2021-02-18'

    cargo_d_c = CargoLogsDataContext(
        job,
        datetime.datetime.strptime(
            start_date, '%Y-%m-%d')
        ,
        datetime.datetime.strptime(
            finish_date, '%Y-%m-%d'
        ),
    )

    cargo_d_c.get_claims().filter(
        nf.custom(lambda x: x == VKUSVILL_CORP_CLIENT_ID, 'corp_client_id')
    ).put(
        yt_path_dir_to.format('batching_vv/init_batches')
    )

    job.run()
    #
    # job = cluster.job('Couriers collection' + str(time.time()))
    # job = job.env(bytes_decode_mode='strict', yt_spec_defaults={'max_failed_job_count': 1000})
    #
    # job.table(yt_path_dir_to.format('batching_vv_new/init_batches')).filter(
    #     nf.custom(lambda x: x is None, 'taxi_order_id')
    # ).put(
    #     yt_path_dir_to.format('batching_vv_new/init_batches_order_id_is_none')
    # )
    # job.run()
    #
    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(bytes_decode_mode='strict', yt_spec_defaults={'max_failed_job_count': 1000})


    job.table(yt_path_dir_to.format('batching_vv/init_batches')).filter(
        nf.custom(lambda x: x is not None, 'taxi_order_id')
    ).put(
        yt_path_dir_to.format('batching_vv/init_batches_order_id_is_not_none')
    )
    job.run()

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(bytes_decode_mode='strict', yt_spec_defaults={'max_failed_job_count': 1000})


    vv_claims_2_taxi_orders = job.table(yt_path_dir_to.format('batching_vv/init_batches')).project(
        "corp_client_id"
        "dispatch_flow"
        "id"
        "status"
        "taxi_order_id"
        "timestamp"
        "zone_id"
    )




    orders_d_c = OrdersSessionsLogsDataContext(
        job,
        datetime.datetime.strptime(
            start_date, '%Y-%m-%d')
        ,
        datetime.datetime.strptime(
            finish_date, '%Y-%m-%d'
        ),
    )

    (
        orders_d_c.get_orders().project(
        'order_id', 'utc_order_dttm',
        'success_order_flg', 'travel_time_min', 'travel_distance_km',
        'order_cost', 'subsidy_value_w_commission',
        'holded_subsidy_value_w_commission', 'order_commission_w_discount_w_vat',
        'shift_commission', 'call_center_commission',
        'childchair_rent_value_w_vat', 'voucher_commission_wo_vat',
        'decoupling_success_flg', 'corp_order_flg', 'decoupling_driver_cost',
        'subsidy_value'
    )
            .join(
        orders_d_c.get_order_payment_info(),
        by='order_id', type='left'
    )
            .put(
        yt_path_dir_to.format('batching_vv/all_orders_dm_order')
    )
    )

    job.run()

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(bytes_decode_mode='strict', yt_spec_defaults={'max_failed_job_count': 1000})


    job.table(yt_path_dir_to.format('batching_vv/all_orders_dm_order')).map(
        calc_net_income_mapper
    ).put(
        yt_path_dir_to.format('batching_vv/net_income_table')
    )
    # TODO: батчи могут по-другому логироватьься
    job.run()
    #
    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(bytes_decode_mode='strict', yt_spec_defaults={'max_failed_job_count': 1000})


    job.table(yt_path_dir_to.format('batching_vv/net_income_table')).join(
        job.table(yt_path_dir_to.format('batching_vv/init_batches_order_id_is_not_none')),
        type='inner', by_left='order_id', by_right='taxi_order_id'
    ).put(
        yt_path_dir_to.format('batching_vv/vv_orders_net_income')
    )

    job.run()


    # job = cluster.job('Couriers collection' + str(time.time()))
    # job = job.env(bytes_decode_mode='strict', yt_spec_defaults={'max_failed_job_count': 1000})
    #
    #
    #
    # from qb2.api.v1 import filters as qf
    #
    #
    # cargo_d_c = CargoLogsDataContext(
    #     job,
    #     datetime.datetime.strptime(
    #         start_date, '%Y-%m-%d')
    #     ,
    #     datetime.datetime.strptime(
    #         finish_date, '%Y-%m-%d'
    #     ),
    # )
    #
    # waybills = cargo_d_c.get_waybills().filter(
    #     qf.defined('taxi_order_id')
    # )
    #
    # job.table(yt_path_dir_to.format('batching_vv_new/vv_orders_net_income')).join(
    #     waybills,
    #     type='inner', by_left='order_id', by_right='taxi_order_id'
    # ).put(
    #     yt_path_dir_to.format('batching_vv_new/waybills_orders_net_income')
    # )
    # # vkusvill, 16 feb
    # #
    #
    # job.run()

    # job = cluster.job('Couriers collection' + str(time.time()))
    # job = job.env(bytes_decode_mode='strict', yt_spec_defaults={'max_failed_job_count': 1000})
    #
    # (
    #     job.table(yt_path_dir_to.format('batching_vv_new/waybills_orders_net_income'))
    #     # .project(
    #     #     'external_ref', 'utc_order_dttm', 'taxi_order_id',
    #     #     # все поля, которые сделала в dm_order
    #     # )
    #     .join(
    #
    #     )
    # )
    # job.run()


    # job = cluster.job('Couriers collection' + str(time.time()))
    # job = job.env(bytes_decode_mode='strict', yt_spec_defaults={'max_failed_job_count': 1000})
    # #### TODO FROM
    # ### START: GEOMAP ####
    # VKUSVILL_CORP_CLIENT_ID = '27751a2d0b534affb80d243bc2f68981'
    # cl = cargo_d_c.get_claims().project(
    #     'corp_client_id', 'id', 'uuid_id'
    # ).filter(
    #     nf.custom(lambda x: x==VKUSVILL_CORP_CLIENT_ID, 'corp_client_id')
    # )
    #
    # p = cargo_d_c.get_points().project(
    #     'point_id', "longitude",
    #             "latitude",
    #             "fullname", 'comment'
    # )
    #
    # cl_p = cargo_d_c.get_claim_points().project(
    #     'point_id', 'claim_id'
    # )
    #
    # cl.join(
    #     cl_p, by_right='claim_id', by_left='id',type='inner'
    # ).join(
    #     p, by='point_id', type='inner'
    # ).groupby(
    #     'fullname'
    # ).reduce(
    #     get_last_record
    # ).put(
    #     yt_path_dir_to.format(
    #         'batching_vv/geo_map')
    # )
    # ### FINISH: GEOMAP ####
    # job.run()



    # from gptransfer_client import GPTransferClient
    # import os
    #
    # client = GPTransferClient(
    #     token=os.environ.get('GP_TRANSFER_TOKEN'),
    #     gp_user=os.environ.get('USER_NAME'),
    #     gp_password=os.environ.get('GP_TOKEN'),
    #     host='https://gptransfer.taxi.yandex.net',
    #     verify_https=False
    # )
    #
    # config = {
    #     'interim_path': yt_path_dir_to.format('{}/all_vv_points_a_2_tmp_tmp_tmp'.format(finish_date)),
    #     'final_path':   'analyst.nkozlovskaya_vv'
    # }
    #
    # process_uuid = client.yt_to_gp(
    #     yt_table_path=config['interim_path'],
    #     gp_table_name=config['final_path'],
    #     column_list=(
    #         schema.keys()
    #     )
    # )
    #
    # status = client.wait_till_finish(
    #     process_uuid,
    #     seconds_to_sleep=20,
    #     timeout=10 * 60  # wait for 10 minutes
    # )

    # cargo_d_c = CargoLogsDataContext(
    #     job,
    #     datetime.datetime.strptime(
    #         start_date, '%Y-%m-%d')
    #     ,
    #     datetime.datetime.strptime(
    #         finish_date, '%Y-%m-%d'
    #     ),
    # )
    #




    # cargo_d_c.get_claims_change_log().groupby(
    #     'claim_id'
    # ).sort(
    #     'updated_ts'
    # ).reduce(
    #     calc_time_till_cancell
    # ).put(
    #     yt_path_dir_to.format('{}/claims_log_statuses'.format(finish_date))
    # )

    # from qb2.api.v1 import filters as qf
    #
    # job.table(yt_path_dir_to.format('{}/all_vv_points_a'.format(finish_date))).join(
    #     job.table(
    #         yt_path_dir_to.format('{}/claims_log_statuses'.format(finish_date))
    #     ).filter(
    #         qf.defined('new_ts')
    #     ).project(
    #         ne.all(),
    #         sec_till_performer_lookup=ne.custom(
    #             lambda x, y: ((x or 0) - y) if (x is not None) else None,
    #             'performer_lookup_ts', 'new_ts'
    #         ),
    #         sec_till_cancelled=ne.custom(
    #             lambda x, y: ((x or 0) - y) if (x is not None) else None,
    #             'cancelled_ts', 'new_ts'
    #         )
    #     ),
    #     by='claim_id', type='left'
    # ).project(
    #     ne.all(),
    #     # sec_till_vv_gets_signal=ne.custom(
    #     #     lambda x: None if x < 0 else x, 'sec_till_vv_gets_signal'
    #     # )
    # ).put(
    #     # TODO: мы не знаем, где раскатан Эксклюзив, а где нет
    #     yt_path_dir_to.format('{}/all_vv_points_a_2_tmp_tmp'.format(finish_date))
    # )






    from qb2.api.v1 import typing as qt
    #import String, Int64, UInt64, Float

    # schema={
    #     # 'cargo_pricing_price',
    #     'chosen_waybill': qt.String,
    #     'claim_id': qt.String,
    #     'claim_point_id': qt.UInt64,
    #     'corp_client_id': qt.String,
    #     # 'courier_subsidies_w_commision_sum',
    #     # 'driver_potential_price',
    #     # 'external_order_id',
    #     # 'external_ref',
    #     # 'final_price',
    #     'fullname': qt.String,
    #     # 'id_vv_from_comment',
    #     # 'latitude',
    #     # 'longitude',
    #     # 'new_ts',
    #     'order_id': qt.String,
    #      # 'performer_lookup_ts',
    #     # 'point_id',
    #     'provider_order_id': qt.String,
    #      'sec_till_cancelled': qt.Float,
    #      'sec_till_performer_lookup': qt.Float,
    #     # 'segment_id',
    #     'status': qt.String,
    #      'taxi_order_id': qt.String,
    #     # 'timestamp',
    #     'utc_date': qt.String
    # }

    # job.table(
    #     yt_path_dir_to.format(
    #         '{}/all_vv_points_a_2_tmp_tmp'.format(finish_date)
    #     )
    # ).project(*schema.keys()).put(
    #     yt_path_dir_to.format('{}/all_vv_points_a_2_tmp_tmp_tmp'.format(finish_date)),
    #     schema=schema
    # )