import datetime
from typing import Dict, Optional
import six

from nile.api.v1.job import Job
from nile.api.v1 import clusters
from nile.api.v1 import Cluster

from projects.common.nile.environment import DEFAULT_CLUSTER
from projects.common.decorators import required_fields
# from projects.efficiency_metrics.pipeline import NilePipeline
from projects.efficiency_metrics.project_config import get_project_cluster

from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawServicesLogsDataContext
# DEFAULT_POOL = 'taxi-delivery'


class Manager:
    def __init__(
            self,
            *,
            yt_proxy: str = DEFAULT_CLUSTER,
            # yt_pool: str = DEFAULT_POOL,
            nile_pipeline_params: Optional[Dict[str, str]] = None,
    ):
        self.yt_proxy = yt_proxy
        self.nile_pipeline_params = nile_pipeline_params or {}
        # self.yt_pool = yt_pool

    def _get_cluster(self) -> Cluster:
        return get_project_cluster(
            parallel_operations_limit=10,
            proxy=self.yt_proxy,
            # yt_pool=self.yt_pool
        )

    @staticmethod
    def _run_job(job: Job) -> None:
        with job.driver.transaction():
            job.run()

    # def _get_nile_pipeline(self, job: Optional[Job] = None) -> NilePipeline:
    #     if job is None:
    #         job = self._get_cluster().job()
    #         job = job.env(bytes_decode_mode='strict')
    #     return NilePipeline(
    #         job=job,
    #         **self.nile_pipeline_params,
    #     )

    def get_ld_logs(self):
        job = self._get_cluster().job()
        job = job.env(bytes_decode_mode='strict')

        raw_services_d_c= RawServicesLogsDataContext(
            job,
            datetime.datetime.strptime(
                start_date, '%Y-%m-%d')
            ,
            datetime.datetime.strptime(
                finish_date, '%Y-%m-%d'
            ),
        )

        raw_services_d_c.get_ld_dispatch().put(
            yt_path_dir_to.format('{}/ld_dispatch_tmp'.format(finish_date))
        )

        self._run_job(job)