import argparse
from collections import Counter
from itertools import chain
import time
import re

import json

import datetime
import six
from nile.api.v1 import aggregators as na
from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from nile.api.v1 import Record
from qb2.api.v1 import filters as qf
from qb2.api.v1 import typing as qt

from projects.common.nile.dates import range_selector
from projects.common.time_utils import datetime_2_timestamp, \
    parse_timestring

from projects.batching.launcher_2 import calc_time_till_cancell
from projects.batching.batching_custom_params import (
    YARCHE_ADDRESSES, VV_ADDRESSES_TMP
)
from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as OrdersSessionsLogsDataContext
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawServicesLogsDataContext
from projects.efficiency_metrics.project_config import get_project_cluster
from projects.batching.nile_blocks.corps import calc_a_density_reducer
from projects.common.gp_transfer import transfer_from_yt_2_gp


def _mapper_ord_proc(records):
    for record in records:
        ts_created = datetime_2_timestamp(
            parse_timestring(record.created, 'UTC'))
        ts_seen = datetime_2_timestamp(
            parse_timestring(record.seen, 'UTC')
        ) if record.get('seen') is not None else None

        tz = record.tariff_zone

        n_cands = record.n_candidates
        c_i = record.candidate_index
        sp = record.get('sp')
        look_for_performer_time = (ts_seen - ts_created) if (
                ts_seen is not None) else (60 * 60.)

        # ORDER_REQS = ['thermobag_confirmed', 'car_couriers',
        #               'too_heavy_no_walking_courier', 'cargo_eds',
        #               'cargo_multipoints',
        #               'thermobox_option_on']
        # order_by_req.append([
        #     float(el in record.unique_special_reqs) for el in ORDER_REQS
        # ])
        status = '{}_{}'.format(
            six.ensure_str(record.status or 'None'),
            six.ensure_str(record.taxi_status or 'None')
        )
        # statuses[status] += 1

        eta = None
        dist = None
        tariff_class = None
        driver_classes = None
        if c_i is not None:
            eta = record.candidates[c_i]['time']
            dist = record.candidates[c_i]['dist']
            tariff_class = record.candidates[c_i]['tariff_class']
            driver_classes = record.candidates[c_i]['driver_classes']

        yield Record(
            updated=record.updated,
            tz=tz,
            c_i=c_i,
            ts_created=ts_created,
            sp=sp,
            look_for_performer_time=look_for_performer_time,
            taxi_order_status=status,
            taxi_order_id=record.order_id,
            # candidates=record.candidates,
            n_cands=n_cands,
            eta=eta,
            dist=dist,
            tariff_class=tariff_class,
            driver_classes=driver_classes
        )



def get_last_reducer(groups):
    for key, records in groups:
        last_rec = None
        for record in records:
            last_rec = record
        yield Record(
            key,
            last_rec
        )


if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    # parser.add_argument('--yt-proxy', type=str, default='Hahn')
    parser.add_argument('--dttm', type=str)
    # parser.add_argument(
    #     '--yt-path-dir-to', type=str,
    #     default='//home/taxi-delivery/analytics/dev/batching/dead/{}'
    # )
    # parser.add_argument('--start-date', type=str)
    # parser.add_argument('--finish-date', type=str)
    cluster = get_project_cluster()

    args = parser.parse_args()

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(
        bytes_decode_mode='strict',
        yt_spec_defaults={'max_failed_job_count': 1000}
    )

    N_HOURS = 24 * 12

    utc_datetime = datetime.datetime.utcnow()  # not .utcnow()
    # from_dttm = (utc_datetime - datetime.timedelta(hours=N_HOURS))
    # from_dttm = datetime.datetime.strptime('2021-05-15', '%Y-%m-%d')
    from_dttm = datetime.datetime.strptime('2021-08-01', '%Y-%m-%d')
    print(from_dttm)
    to_dttm = utc_datetime#.strftime('%Y-%m-%dT%H:%M:%S')

    orders_d_c = OrdersSessionsLogsDataContext(
        job,
        from_dttm,
        to_dttm + datetime.timedelta(hours=N_HOURS),
        ['light_order_proc']
    )

    # TODO: undo
    orders_table = orders_d_c.get_light_order_proc().project(
        ne.all()
    ).filter(
        qf.defined('created')
    ).project(
        ne.all(),
        timestamp=ne.custom(
            lambda x: datetime_2_timestamp(
                parse_timestring(x, 'UTC')
            ), 'created'
        )
    )
    print(from_dttm, to_dttm)

    cargo_d_c = CargoLogsDataContext(
        job,
        from_dttm,
        to_dttm
    )

    segments = cargo_d_c.get_segments().project(ne.all(['timestamp', 'source']))

    claims = (
        cargo_d_c.get_claims()
            .filter(
                nf.custom(lambda x: x != 'platform_usage', 'claim_kind'),
                # nf.custom(lambda x: x is not None, 'taxi_order_id')
            )
            .project(
                'taxi_order_id', 'uuid_id', 'timestamp', 'final_price',
                'corp_client_id',
                'status', 'zone_id', 'dispatch_flow', 'final_pricing_calc_id',
                'is_delayed', 'due', 'eta', 'currency',
                'last_status_change_ts',
                claim_id='id',
                utc_date=ne.custom(
                    lambda x:
                    datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%d'),
                    'timestamp'
                ),
                hour=ne.custom(
                    lambda x:
                    datetime.datetime.utcfromtimestamp(x).hour,
                    'timestamp'
                ),
                utc_date_hour=ne.custom(
                    lambda x:
                    datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%d %H'),
                    'timestamp'
                )
            )
    )


    claims_log_statuses = cargo_d_c.get_claims_change_log().groupby(
        'claim_id'
    ).sort(
        'updated_ts'
    ).reduce(
        calc_time_till_cancell
    ).filter(
        qf.defined('new_ts')
    ).project(
        ne.all(),
        sec_till_performer_lookup=ne.custom(
            lambda x, y: ((x or 0) - y) if (x is not None) else None,
            'performer_lookup_ts', 'new_ts'
        ),
        sec_till_cancelled=ne.custom(
            lambda x, y: ((x or 0) - y) if (x is not None) else None,
            'cancelled_ts', 'new_ts'
        ),
        sec_till_performer_found=ne.custom(
            lambda x, y: ((x or 0) - y) if (x is not None) else None,
            'performer_found_ts', 'new_ts'
        ),
        sec_till_delivered_returned=ne.custom(
            lambda x, y: ((x or 0) - y) if (x is not None) else None,
            'delivered_returned_ts', 'new_ts'
        ),
        sec_till_delivered=ne.custom(
            lambda x, y: ((x or 0) - y) if (x is not None) else None,
            'delivered_ts', 'new_ts'
        )
    )

    claims_2_segents = claims.join(
        segments, by_left = 'uuid_id', by_right = 'claim_id', type = 'inner'
    ).join(
        claims_log_statuses, by='claim_id', type='inner'
    )#.put(
    #     '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/tmp_claims_2_segments'
    # )

    employers = job.table('//home/taxi-delivery/production/batching/ld_experiment/employers_2021-03-14')

    # TODO: undo
    orders_2_claims_2_segments = orders_table.map(
        _mapper_ord_proc
    ).join(
        claims_2_segents,
        type='right', by='taxi_order_id'
    ).project(
        ne.all(),
        dispatch_type=ne.custom(
            lambda x: x.split('/')[0] if x is not None else None,
            'chosen_waybill'
        )
    ).join(
        employers, by='corp_client_id', type='left'
    ).groupby(
        'claim_id'
    ).sort(
        'updated'
    ).reduce(
        get_last_reducer
    )#.put(
    #     '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/tmp_orders_tmp_wo_taxi_order_id_unique'
    # )

    # # TODO: undo
    # orders_2_claims_2_segments = claims_2_segents.project(
    #     ne.all(),
    #     dispatch_type=ne.custom(
    #         lambda x: x.split('/')[0] if x is not None else None,
    #         'chosen_waybill'
    #     )
    # ).join(
    #     employers, by='corp_client_id', type='left'
    # ).groupby(
    #     'claim_id'
    # ).sort(
    #     'updated'
    # ).reduce(
    #     get_last_reducer
    # )#.put(
    # #     '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/tmp_orders_tmp_wo_taxi_order_id_unique'
    # # )

    # # TODO: drop tthis line
    # orders_2_claims_2_segments = job.table(
    #     '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/tmp_orders'
    # )


    local_now = datetime.datetime.now()- datetime.timedelta(days=1)
    to_local_dttm = (
            local_now.replace(
                minute=0, second=0, microsecond=0)
    )

    from_local_dttm = (
            (
                    local_now - datetime.timedelta(hours=N_HOURS)
            ).replace(minute=0, second=0, microsecond=0)
    )

    dttm_needed = [
        (
                from_local_dttm + datetime.timedelta(hours=x)
        ).strftime('%Y-%m-%dT%H:%M:%S')
        for x in range(N_HOURS)
    ]
    print(dttm_needed)



    # fake_group_table = job.table(
    #     '//home/taxi-delivery/analytics/dev/batching/dead/2021-03-12/exps'
    # )

    from projects.common.nile.dates import range_selector

    # realtime = job.table(
    #     '//home/logfeller/logs/taxi-exp3-log/1h/{}'.format(
    #         f'{{{",".join(dttm_needed)}}}'
    #     ),
    #     ignore_missing=True
    # ).filter(
    #     nf.custom(
    #         lambda x: x == 'cargo-dispatch/route_building_init', 'consumer'
    #     ),
    #     intensity='large_data'
    # )
    # history = job.table('//home/logfeller/logs/taxi-exp3-log/1d/{}'.format(
    #     range_selector(from_dttm, to_dttm + datetime.timedelta(hours=N_HOURS), '%Y-%m-%d')
    # ), ignore_missing=True).filter(
    #     nf.custom(
    #         lambda x: x == 'cargo-dispatch/route_building_init', 'consumer'
    #     ),
    #     intensity='large_data'
    # )

    print(
        'exps v3',
        f'{{{",".join(dttm_needed)}}}',
        range_selector(from_dttm, to_dttm + datetime.timedelta(hours=N_HOURS))
    )

    # https://yql.yandex-team.ru/Operations/YFhkv_MBw1gA6CCVwuGstrdO5ZZqJ_b_Q_UVTKKGtPY=


    # final = job.concat(
    #     realtime, history
    # )\


    # orders_2_claims_2_segments = job.table(
    #     # '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/tmp_orders_tmp'
    #     '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/tmp_orders_tmp_wo_taxi_order_id'
    # )
    # orders_2_claims_2_segments = job.table(
    #     # '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/tmp_orders_tmp'
    #     '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/tmp_orders_tmp_wo_taxi_order_id_unique'
    # )
    tmp=(
        job.table(
            '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/experiments_3_0_parsed/{}'.format(local_now.strftime('%Y-%m-%d'))
            # '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/history_exps_2021_08_28'
        ).project(
            'kwargs', 'matched',
            group_ts=ne.custom(lambda x: datetime_2_timestamp(
                parse_timestring(x, 'UTC')
            ), 'iso_eventtime'),
            group=ne.custom(lambda x: json.loads(x)[0].get('alias'), 'matched')
        )
            .filter(
            nf.custom(
                # lambda x: six.ensure_str(x) not in [
                #     'default'
                # ],
                lambda x: x in [
                    'ld_vs_taxi_dispatch_experiment_2021-03-11',
                    'ld_vs_taxi_dispatch_experiment_2021-03-11_control',
                    'corps_v4_31_03',
                    'corps_v4_31_03_control',
                    'ld_vs_taxi_dispatch_experiment_2021-04-14',
                    'ld_vs_taxi_dispatch_experiment_2021-04-14_control',
                    'russia_cities_15_04',
                    'russia_cities_15_04_control',
                    'ld_80_20_1205_test',
                    'ld_80_20_1205_control',
                    'russia_spb_vv_test',
                    'russia_spb_vv_control',
                    'svc_full_ld',
                    'ld_meznar_test',
                    'ld_meznar_control',
                    'segment_routers_testing_alive_batches_samara_voronezh',
                    'c2c_test',
                    'c2c_control',
                    'msc_ld_vs_taxi_test',
                    'msc_ld_vs_taxi_control',
                    'msc_switchback_exp',
                    'msc_switchback_control'
                ],
                'group'
            )
        )
            .project(
            'group',
            'group_ts',
            segment_id=ne.custom(lambda x: json.loads(x).get('segment_id'),
                                 'kwargs')
        )
    )#.put(
    #     '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/2021-04-14_exp_all_without_filtration'
    # )

    # tmp = job.table(
    #     '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/2021-04-14_exp'
    # )


    # tmp = job.table(
    #     '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/2021-04-14_exp_all_without_filtration'
    # )
    final = (

        tmp

        .join(
            orders_2_claims_2_segments,
            by='segment_id',
            # type='left',#
            # type='inner'#
            # type='right_only'
            type='inner'
        )
        .filter(
            qf.defined('claim_id')
        )
        .groupby(
            'claim_id'
        ).sort(
            'updated'
        ).reduce(
            get_last_reducer
        )

        .put(
            '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/realtime'
        )
    )

    job.run()

    # final = job.table('//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/realtime')
    #
    # # claim_id, group, status, dispatch_flow, segment_id, group_exp_3,
    # # eta кандидата, расстояние?
    #
    schema = {
        # 'tariff_zone': qt.String,
        # 'status': qt.String,
        # 'claim_id': qt.String,
        # 'utc_date': qt.String,
        # 'corp_client_id': qt.String,
        # 'taxi_order_id': qt.String,
        # 'fullname': qt.String,
        # 'sec_till_cancelled': qt.Float,
        # 'sec_till_performer_lookup': qt.Float,
        # 'cargo_pricing_price': qt.Float,
        # 'final_price': qt.Float,
        # 'is_cancelled_after_2_min': qt.Int64,
        # 'is_cancelled_after_5_min': qt.Int64,
        # 'is_cancelled_after_10_min': qt.Int64,
        # 'is_cancelled_after_30_min': qt.Int64,
        # 'is_failed_by_clients_flag': qt.Int64,
        # 'is_pay_cancelled_flag': qt.Int64,
        # 'is_cancelled_flag': qt.Int64,
        # 'is_failed_by_us_flag': qt.Int64,
        # 'is_cancelled_by_courier_flag': qt.Int64,
        # 'is_performer_not_found_flag': qt.Int64,
        # 'is_success_flag': qt.Int64,
        'dispatch_type': qt.String,
        # 'is_batched_flag': qt.Int64
        # 'tariff_zone':
        # cr
        # опоздание/ ооттложенный не отложенный

        "chosen_waybill": qt.String,
        "dispatch_flow": qt.String,
        "group": qt.String,
        'group_ts': qt.Int64,
        "status": qt.String,
        "utc_date": qt.String,
        "timestamp": qt.Int64,
        "c_i": qt.Int64,
        "claim_id": qt.String,
        "corp_client_id": qt.String,
        "currency": qt.String,
        "dist": qt.Int64,
        # "driver_classes"
        # "due"
        "eta": qt.Int64,
        # "final_price"
        # "final_pricing_calc_id"
        # "is_delayed"
        # "last_status_change_ts"
        "look_for_performer_time": qt.Float,
        "n_cands": qt.Int64,
        # "s_timestamp"
        # "segment_id"
        "sp": qt.Float,
        "tariff_class": qt.String,
        "taxi_order_id": qt.String,
        "taxi_order_status": qt.String,
        "ts_created": qt.Int64,
        # "tz"
        # "updated"
        # "uuid_id"
        'employer': qt.String,
        "zone_id": qt.String,
        'hour': qt.Int64,
        'utc_date_hour': qt.String,
        'type_of_dispatch': qt.String,
        'sec_till_cancelled': qt.Float,
        'sec_till_performer_lookup': qt.Float,
        'sec_till_performer_found': qt.Float,
        'sec_till_delivered_returned': qt.Float,
        'sec_till_delivered': qt.Float,
    }

    # def fill_fields_w_none_mapper().map(
    #         fill_fields_w_none_mapper
    #     )



    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(
        bytes_decode_mode='strict',
        yt_spec_defaults={'max_failed_job_count': 2000}
    )

    final = job.table(
        # '//home/taxi-delivery/analytics/dev/batching/dead/2021-03-12/claims_segments_orders_exp_unique_last'
        '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/realtime'
        # '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/realtime_cp_05_04'
    )
    final.project(
        *(schema.keys())
    ).project(
        ne.all(['look_for_performer_time']),
        look_for_performer_time=ne.custom(
            lambda x: float(x) if x is not None else None,
            'look_for_performer_time'
        ),

    ).project(
        ne.all(),

        type_of_dispatch=ne.custom(
            lambda x: x.split('/')[0] if x is not None else None, 'chosen_waybill'
        )
        # # hour=ne.custom(
        # #     lambda x: datetime.datetime.utcfromtimestamp(x).hour, 'ts_created'
        # # )
    ).filter(
        qf.defined('utc_date'),
        # nf.custom(lambda x: x >= '2021-03-25', 'utc_date')
        nf.custom(lambda x: x >= '2021-05-25', 'utc_date')

    ).put(
        '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/realtime_schema',
        schema=schema
    )

    job.run()


    # transfer_from_yt_2_gp(
    #     '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/realtime_schema',
    #     'analyst.nkozlovskaya_ld_realtie_monitoring',
    #     schema
    # )