import numpy as np
from nile.api.v1 import Record


def calc_a_density_reducer(groups):
    for key, records in groups:

        timestamp_s = []
        resolution_s = []
        n_orders = 0
        n_total_orders = 0
        daily_histogram = {}
        corp_id_histogram = {}
        for record in records:
            timestamp_s.append(record.timestamp)
            # resolution_s.append(record.resolution)
            n_orders += record.status in ['delivered_finish', 'returned_finish']
            n_total_orders += 1

            if record.utc_date in daily_histogram:
                daily_histogram[record.utc_date] += 1
            else:
                daily_histogram[record.utc_date] = 1

            if record.corp_client_id in corp_id_histogram:
                corp_id_histogram[record.corp_client_id] += 1
            else:
                corp_id_histogram[record.corp_client_id] = 1

        tmp = None
        if len(timestamp_s) >= 2:
            tmp = np.array(timestamp_s[1:]) - np.array(timestamp_s[:-1])

        yield Record(
            key,
            # timestamp_s=timestamp_s,
            # resolution_s=resolution_s,
            n_orders=n_orders,
            n_total_orders=n_total_orders,
            # corp_id_histogram=corp_id_histogram,
            # daily_histogram=daily_histogram,
            # time_btw_ts_mean=list(tmp) if tmp is not None else None,
            time_btw_ts_less_025_share=np.mean(
                tmp < 0.25 * 60) if tmp is not None else None,
            time_btw_ts_less_05_share=np.mean(
                tmp < 0.5 * 60) if tmp is not None else None,
            time_btw_ts_less_1_share=np.mean(
                tmp < 1 * 60) if tmp is not None else None,
            time_btw_ts_less_2_share=np.mean(
                tmp < 2 * 60) if tmp is not None else None,
            time_btw_ts_less_5_share=np.mean(
                tmp < 5 * 60) if tmp is not None else None,
            time_btw_ts_less_10_share=np.mean(
                tmp < 10 * 60) if tmp is not None else None,
            time_btw_ts_less_20_share=np.mean(
                tmp < 20 * 60) if tmp is not None else None,
            time_btw_ts_less_30_share=np.mean(
                tmp < 30 * 60) if tmp is not None else None,
            time_btw_ts_less_60_share=np.mean(
                tmp < 60 * 60) if tmp is not None else None,
            time_btw_ts_less_10_sum=np.sum(
                tmp < 10 * 60) if tmp is not None else None,
            time_btw_ts_less_20_sum=np.sum(
                tmp < 20 * 60) if tmp is not None else None,
            time_btw_ts_less_30_sum=np.sum(
                tmp < 30 * 60) if tmp is not None else None,
            time_btw_ts_less_60_sum=np.sum(
                tmp < 60 * 60) if tmp is not None else None,
            # density_tim=# TODO
        )