from nile.api.v1 import Record


def calc_net_income_mapper(records):
    for record in records:

        new_rec = Record(
            order_id=record.order_id,
            utc_order_dttm=record.utc_order_dttm,
            order_cost=record.order_cost,
            decoupling_success_flg=record.decoupling_success_flg,
            corp_order_flg=record.corp_order_flg,
            decoupling_driver_cost=record.decoupling_driver_cost,
            user_cost_vat=record.user_cost_vat,
            success_order_flg=record.success_order_flg
        )
        courier_order_cost = record.order_cost
        if record.decoupling_success_flg == True:
            courier_order_cost = record.decoupling_driver_cost
        if record.corp_order_flg == True:
            courier_order_cost = record.order_cost - record.get('user_cost_vat', 0)

        courier_income = (
            (courier_order_cost + record.get('subsidy_value', 0)) if
            (courier_order_cost > 0) else 0
        )

        tmp = (
                ((
                        record.get('subsidy_value_w_commission', 0)
                        or
                        record.get('holded_subsidy_value_w_commission', 0)
                ) or 0)
                - (record.get('order_commission_w_discount_w_vat', 0) or 0)
                - (record.get('shift_commission', 0) or 0)
                - (record.get('call_center_commission', 0) or 0)
                - (record.get('childchair_rent_value_w_vat', 0) or 0)
                - (record.get('voucher_commission_wo_vat', 0) or 0)
        )

        courier_net_income = (
            courier_order_cost + tmp
            if (courier_order_cost > 0) else 0
        )
        yield Record(
            new_rec,
            courier_order_cost=courier_order_cost,
            courier_net_income=courier_net_income,
            courier_income=courier_income

        )
