import os
import json

from dotenv import load_dotenv

from gptransfer_client import GPTransferClient

from nile.api.v1 import (
    clusters,
    aggregators as na,
    extractors as ne
)

from qb2.api.v1 import extractors as se
from qb2.api.v1.typing import String, Int64, UInt64, Float


PYTHON3_LAYERS = [
    '//porto_layers/ubuntu-xenial-base.tar.xz',
    '//statbox/home/komendart/porto/nile_python3.7.tar.gz',
]

config = {
    'source_path':  '//home/taxi/production/replica/postgres/cargo_claims/points',
    'interim_path': '//home/taxi-delivery/dev/kulichevskiy_points',
    'final_path':   'analyst.nkozlovskaya_points',
    'interim_schema': {
        'hash': String,
        'id': UInt64,
        'longitude': Float,
        'latitude': Float,
        'fullname': String,
        'country': String,
        'city': String,
        'street': String,
        'building': String,
        'porch': String,
        'floor': Int64,
        'flat': Int64,
        'door_code': String,
        'comment': String,
        'contact_personal_phone_id': String,
        'contact_name': String,
        'time_interval_from': Float,
        'time_interval_to': Float,
        'created_ts': Float,
        'updated_ts': Float,
        'contact_personal_email_id': String,
        'external_order_id': String,
        'uri': String,
        'sflat': String,
        'sfloor': String,
        'shortname': String,
        'ready_for_interact': Float,
    },
    'source_schema': {
        'skip': [
            'id',
            'longitude',
            'latitude',
            'country',
#             'city',
#             'street',
#             'building',
#             'porch',
#             'floor',
#             'flat',
#             'door_code',
#             'contact_personal_phone_id',
#             'contact_name',
#             'time_interval_from',
#             'time_interval_to',
            'created_ts',
            'updated_ts',
            'contact_personal_email_id',
#             'external_order_id',
#             'uri',
#             'sflat',
#             'sfloor',
#             'shortname',
#             'ready_for_interact',
        ],
        'convert': ['hash', 'fullname', 'comment', ]
    }
}

cluster = clusters.YT("hahn")
job = cluster.job()

job = job.env(
    yt_spec_defaults=dict(
        mapper=dict(layer_paths=PYTHON3_LAYERS),
        reducer=dict(layer_paths=PYTHON3_LAYERS),
    ),
    bytes_decode_mode='strict'

)

result = (
    job
    .table(config['source_path'])
    .project(
        config['source_schema']['skip'],
        se.custom('hash', lambda x: str(x), 'hash').with_type(str),
        se.custom(
            'fullname',
            lambda x: str(x).replace("'",'').replace('"',''), 'fullname'
        ).with_type(str),
        se.custom(
            'comment',
            lambda x: str(x).replace("'",'').replace('"',''), 'comment'
        ).with_type(str)
    )
)

result.put(
    path=config['interim_path'],
    schema=config['interim_schema']
)

job.run()

print (os.environ.get('GP_TRANSFER_TOKEN'))
print (os.environ.get('USER_NAME'))
print (os.environ.get('GP_TOKEN'))

client = GPTransferClient(
    token=os.environ.get('GP_TRANSFER_TOKEN'),
    gp_user=os.environ.get('USER_NAME'),
    gp_password=os.environ.get('GP_TOKEN'),
    host='https://gptransfer.taxi.yandex.net',
    verify_https=False
)

process_uuid = client.yt_to_gp(
   yt_table_path=config['interim_path'],
   gp_table_name=config['final_path'],
   column_list=(
           config['source_schema']['skip'] + config['source_schema']['convert']
   )
)

status = client.wait_till_finish(
    process_uuid,
    seconds_to_sleep=20,
    timeout=10 * 60  # wait for 10 minutes
)
