import argparse
import json
import time

from projects.efficiency_metrics.project_config import get_project_cluster


if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    parser.add_argument(
        '--yt-path-dir-to', type=str,
        default='//home/taxi-delivery/analytics/dev/batching/dead/{}'
    )
    # parser.add_argument('--start-date', type=str)
    # parser.add_argument('--finish-date', type=str)

    args = parser.parse_args()
    yt_path_dir_to = args.yt_path_dir_to
    # finish_date = args.finish_date

    cluster = get_project_cluster()

    finish_date = '2021-03-11'

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(
        bytes_decode_mode='strict',
        yt_spec_defaults={'max_failed_job_count': 1000}
    )
    from nile.api.v1 import filters as nf
    print(yt_path_dir_to.format(
            '{}/cl_p_s_w_o_st_pr_final_w_subsidies'.format(finish_date)))

    (
        job.table(
            '//home/taxi-delivery/analytics/dev/batching/dead/2021-03-11/cl_p_s_w_o_st_pr_final_w_subsidies'
        ).filter(
            nf.custom(
                lambda x: x in ['novosibirsk', 'ekb', 'rostovondon'],
                'zone_id'
            )
        ).unique(
            'corp_client_id', 'name', 'fullname'
        )
    .put(
            yt_path_dir_to.format('{}/corps_fullname_regions_filtered'.format(finish_date))
        )
    )
    from nile.api.v1 import extractors as ne

    from shapely.geometry import Point
    from shapely.geometry.polygon import Polygon

    # lon lat
    polygon = Polygon([[37.59031423863732, 55.80427119508335],
                       [37.52851776620668, 55.7801071382823],
                       [37.5844793750934, 55.75494578953191],
                       [37.67271332284731, 55.76307662400225],
                       [37.59031423863732, 55.80427119508335]])

    # [  [    37.59031423863732,    55.80427119508335  ],  [    37.52851776620668,    55.7801071382823  ],  [    37.5844793750934,    55.75494578953191  ],  [    37.67271332284731,    55.76307662400225  ],  [    37.59031423863732,    55.80427119508335  ]]
    # print(polygon.contains(point))

    # (
    #     job.table(
    #         '//home/taxi-delivery/analytics/dev/batching/dead/2021-03-11/cl_p_s_w_o_st_pr_final_w_subsidies'
    #     ).filter(
    #         nf.custom(
    #             lambda x: x in ['moscow'],
    #             'zone_id'
    #         )
    #     ).project(
    #         ne.all(),
    #         is_in_polygon=ne.custom(
    #             lambda x, y: polygon.contains(Point(x, y)),
    #             'longitude', 'latitude'
    #         )
    #         # geo_hash=ne.custom(lambda x, y: gh.encode(x, y, precision=5), 'lat', 'lon')
    #     )
    #     #     .unique(
    #     #     'corp_client_id', 'name'
    #     # )
    # .put(
    #         yt_path_dir_to.format('{}/corps_msc'.format(finish_date))
    #     )
    # )
    #
    # job.table(yt_path_dir_to.format('{}/corps_msc'.format(finish_date))).filter(
    #     nf.custom(lambda x: x == True, 'is_in_polygon')
    # ).unique(
    #     'corp_client_id', 'name'
    # ).put(
    #     yt_path_dir_to.format('{}/corps_msc_unique_filtered'.format(finish_date))
    # )
    #

    # TODO удалила случайно //home/taxi-delivery/analytics/dev/batching/dead/2021-03-11/fullnames_msc_unique_filtered

    job.run()
