import argparse
import json

import geog
import numpy as np
import shapely.geometry

from projects.efficiency_metrics.project_config import get_project_cluster


def get_config_from_geopoint(geo_set_of_polygon):
    return {
        "init": {
            "arg_name": "source_point",
            "arg_type": "linear_ring",
            "value": geo_set_of_polygon
        },
        "type": "falls_inside"
    }


def get_config_from_list_of_geopoints(geopoints):
    geopoints_list = []
    for geo_set_of_polygon in geopoints:
        geopoints_list.append(get_config_from_geopoint(geo_set_of_polygon))
    return geopoints_list


def build_poly(point, n_points=6, distance=200):
    p = shapely.geometry.Point(point)
    angles = np.linspace(0, 360, n_points)
    return geog.propagate(p, angles, distance).tolist()



if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    # parser.add_argument(
    #     '--yt-path-dir-to', type=str,
    #     default='//home/taxi-delivery/analytics/dev/batching/dead/{}'
    # )
    # parser.add_argument('--start-date', type=str)
    # parser.add_argument('--finish-date', type=str)
    cluster = get_project_cluster()

    args = parser.parse_args()
    #
    # raw="""'Калуга ул. Генерала Попова , д. 2/1 к. 3' – 54.492709, 36.218698
    # 'Нижний Новгород пр-кт Гагарина, д. 105' – 56.235105, 43.951477
    # 'Нижний Новгород, Первоцветная, 2' – 56.264522, 44.020719
    # 'Нижний Новгород, 42, Максима Горького, 156' – 56.314272, 43.990122"""
#
#     raw = """'Москва ул. Бажова, д. 8' –   55.832030, 37.661051
# 'Москва б-р Химкинский, д. 16, к. 1' – 55.851965, 37.443030
# 'Ростов-на-Дону ул. Большая Садовая, д. 78/67' – 47.221503, 39.715372
# 'Нижний Новгород пр-кт Гагарина, д. 105' – 56.235781, 43.952510
# 'Курск ул. Ленина, д. 94' – 51.747176, 36.193931
# 'Тула г.  Тула, ул. Первомайская 10' – 54.182211, 37.602579
# 'Брянск пр-т Ленина, д. 6а. ТЦ Родина' – 53.236249, 34.357083
# 'Ростов-на-Дону ул. Большая Садовая , д. 83/48' – 47.223859, 39.724382
# 'Ульяновск ул. Карла Маркса, д. 13А, к. 3' – 54.319769, 48.395945
# 'Саратов ул. Московская, д. 122/126' – 51.536940, 46.022650
# 'Санкт-Петербург пр-т Индустриальный, д. 27' – 59.948834, 30.475463
# 'Орел пл. Мира, д. 5' – 52.968125, 36.076809
# 'Москва, Ломоносовский проспект, 34' – 55.708599, 37.5107
# 'Москва, Лазоревый проезд, 1Ак2' – 55.847198, 37.638401
# 'Москва, улица Черняховского, 6' – 55.804401, 37.535301"""
#

    # raw = """'105203, Москва г, Первомайская ул, д.100' – 55.793274, 37.811061"""

    raw = """'117449, Москва г, Шверника ул, д.13' – 55.691597, 37.589049"""
    lines = raw.split('\n')
    print (lines[-1])

    points = []

    for l in lines:
        print (l),
        print (l.split('–')[1])
        coords = l.split('–')[1].strip().split(',')
        coords = [float(x) for x in coords]
        points.append(coords)

    [p.reverse() for p in points]

    # points = cluster.read(
    #     '//home/taxi-delivery/analytics/dev/batching/dead/2021-03-07/aa_test_test_group_2_points'
    # ).as_dataframe()[["longitude", "latitude"]].values

    # points = cluster.read(
    #     '//home/taxi-delivery/analytics/dev/batching/dead_tmp/2021-03-17/all_b2b_a_statistics_filtered_w_geo'
    # ).as_dataframe()[["longitude", "latitude"]].values

    # points = cluster.read(
    #     '//home/taxi-delivery/analytics/dev/batching/dead_tmp/2021-03-17/all_b2b_a_statistics_filtered_w_geo_whitetlist'
    # ).as_dataframe()[["longitude", "latitude"]].values

    # points = cluster.read(
    #     '//home/taxi-delivery/analytics/dev/batching/dead_tmp/2021-03-23/tmp_15_sec'
    # ).as_dataframe()[["longitude", "latitude"]].values

    polys = []

    for p in points:
        poly = build_poly(p)
        polys.append(poly)

    geopoints_list = get_config_from_list_of_geopoints(polys)

    template = {
      "init": {
        "predicates": [
          {
            "init": {
              "arg_name": "corp_client_id",
              "arg_type": "string",
                # "value": "4e69321b86d04af0a8bd763cb5c51fa7"
              # "value": "27751a2d0b534affb80d243bc2f68981" # vkusvill
            "value":"8b5bde577e0b42059d9650ef5529a959"
            },
            "type": "eq"
          },
            {"init": {"predicates": geopoints_list}, "type":"any_of"}
        ]
      },
      "type": "all_of"
    }
    print(json.dumps(template, indent=2, sort_keys=True))

    # import six
    # print (list(map(six.ensure_str, cluster.read(
    #     '//home/taxi-delivery/analytics/dev/batching/dead/2021-03-07/aa_test_test_group_2_points'
    # ).as_dataframe()['corp_client_id'].unique())))

    # import six
    # for el in (list(map(six.ensure_str, cluster.read(
    #     '//home/taxi-delivery/analytics/dev/batching/dead_tmp/2021-03-17/all_b2b_a_statistics_filtered_w_geo'
    # ).as_dataframe()['corp_client_id'].unique()))):
    #     print (el)



    # import six
    # for el in (list(map(six.ensure_str, cluster.read(
    #     '//home/taxi-delivery/analytics/dev/batching/dead_tmp/2021-03-17/all_b2b_a_statistics_filtered_w_geo_whitetlist'
    # ).as_dataframe()['corp_client_id'].unique()))):
    #     print (el)

    # import six
    # for el in (list(map(six.ensure_str, cluster.read(
    #     '//home/taxi-delivery/analytics/dev/batching/dead_tmp/2021-03-23/tmp_less'
    # ).as_dataframe()['corp_client_id'].unique()))):
    #     print (el)


    # import six
    # for el in (list(map(six.ensure_str, cluster.read(
    #     '//home/taxi-delivery/analytics/dev/batching/dead_tmp/2021-03-23/tmp_15_sec'
    # ).as_dataframe()['corp_client_id'].unique()))):
    #     print (el)
    #
    # import six
    # for el in (list(map(six.ensure_str, cluster.read(
    #     '//home/taxi-delivery/analytics/dev/batching/dead_tmp/2021-03-30/ld_exp_wave_2'
    # ).as_dataframe()['corp_client_id'].unique()))):
    #     print (el)

