import argparse
import sys
import time

import datetime
import geohash as gh
import numpy as np

from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from nile.api.v1 import Record
from qb2.api.v1 import filters as qf
from qb2.api.v1 import typing as qt

from projects.burnt_orders_research.ld_parsing_nile_block import \
    LogEntrySegmentDetector
from projects.burnt_orders_research.nile_blocks.main import (
    calc_different_stats, dup_mapper, main_reducer, get_all_waybills_by_segment,
    claim_ld_stages_mapper, claims_pattern_ld_stages_reducer
)
from projects.burnt_orders_research.nile_blocks.propositions import(
    proposition_reducer,
)
from projects.common.nile.dates import range_selector
from projects.data_sources.data_context.eda_logs import \
    DataContext as EdaOrdersDataContext
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawLogs
from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as TaxiOrdersDataContext
from projects.efficiency_metrics.project_config import get_project_cluster
from projects.burnt_orders_research.ld_parsing_nile_block import \
    LogEntrySegmentDetector


if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    # parser.add_argument('--from-date', type=str, required=True)
    # parser.add_argument('--to-date', type=str, required=True)

    args = parser.parse_args()

    cluster = get_project_cluster()

    # from_date = '2021-04-12'
    # from_date = '2021-05-05'
    # from_date = '2021-05-12'
    # to_date = '2021-05-26'
    # from_date = datetime.datetime.strptime(args.from_date, '%Y-%m-%d')
    # to_date = datetime.datetime.strptime(args.to_date, '%Y-%m-%d')

    yt_path_to = '//home/taxi-delivery/analytics/production/ld/candidates/{}'

    job = cluster.job('LD metrics' + str(time.time()))
    job = job.env(bytes_decode_mode='strict')

    # job.table('//home/eda-dwh/ods/couriers_schedule/courier_shift/2021-01-01').project(
    #     'utc_shift_start_dttm', 'utc_shift_end_dttm',
    #     'courier_id',
    #     'courier_delivery_zone_id'
    # ).filter(
    #     qf.defined('courier_id')
    # ).join(
    #     job.table('//home/taxi-dwh/ods/dbdrivers/executor_profile/executor_profile').filter(
    #         qf.defined('bigfood_courier_id')
    #     ).project(
    #         'bigfood_courier_id',
    #         dbid_uuid=ne.custom(
    #             lambda x, y: '{}_{}'.format(x, y),
    #             'park_taximeter_id', 'executor_profile_id'
    #         )
    #     ),
    #     by_left='courier_id', by_right='bigfood_courier_id', type='inner'
    # ).put(
    #     '//home/taxi-delivery/analytics/dev/nkozlovskaya/frozen/cour'
    # )

    #
    # import json
    #
    # def mapper(records):
    #     for record in records:
    #         # if record.get('request') is None:
    #         #     continue
    #         try:
    #             f = json.loads(record.request[14:])
    #             if 'eda' in f.get('allowed_classes'):
    #                 del f['zone_id']
    #                 del f['point']
    #                 # print json.dumps(f, sort_keys=True)
    #                 yield Record(request=json.dumps(f, sort_keys=True))
    #         except:
    #             pass
    #
    # # job.table('//home/taxi-delivery/analytics/dev/nkozlovskaya/frozen/assignment').project(
    # #     'request'
    # # ).map(
    # #     mapper
    # # ).put('//home/taxi-delivery/analytics/dev/nkozlovskaya/frozen/assignment__')
    #
    # # job.table('//home/taxi-delivery/analytics/dev/nkozlovskaya/frozen/assignment__').unique(
    # #     'request'
    # # ).put('//home/taxi-delivery/analytics/dev/nkozlovskaya/frozen/assignment_unique')
    #
    # def _mapper(records):
    #     for record in records:
    #         f = json.loads(record.request)
    #         del f['limit']
    #         del f['max_distance']
    #         # print f
    #         if 'eats_shift' in f:
    #             del f['eats_shift']#['zone_group']
    #             # TODO:  ne och akkuratno! luchshe byy zone_group
    #         yield Record(request=json.dumps(f, sort_keys=True))
    #
    # # job.table('//home/taxi-delivery/analytics/dev/nkozlovskaya/frozen/assignment_unique').map(
    # #     _mapper
    # # ).unique('request').put(
    # #     '//home/taxi-delivery/analytics/dev/nkozlovskaya/frozen/assignment_unique_unique'
    # # )
    #
    # def _ma(records):
    #     for record in records:
    #         # if record.get('request') is None:
    #         #     continue
    #         try:
    #             cands = json.loads(record.response).get('candidates')
    #         except:
    #             pass
    #         for cand in cands:
    #             if 'eda' in cand.get('classes'):
    #                 yield Record(
    #                     dbid_uuid=cand['id'],
    #                     ts=int(record._logfeller_timestamp)
    #                 )
    #
    #
    # # job.table('//home/taxi-delivery/analytics/dev/nkozlovskaya/frozen/assignment_c').map(
    # #     _ma
    # # ).put(
    # #     '//home/taxi-delivery/analytics/dev/nkozlovskaya/frozen/assignment_cands'
    # # )
    #
    # def _reducer(groups):
    #     for key, records in groups:
    #         cnt = None
    #         start_ts = None
    #         for record in records:
    #             if record.get('flag') == 'start':
    #                 cnt = 0
    #                 start_ts = record.ts
    #             if (cnt is not None) and (record.get('flag') is None):
    #                 cnt += 1
    #             if (cnt is not None) and (record.get('flag') == 'end'):
    #                 yield Record(
    #                     dbid_uuid=record.dbid_uuid,
    #                     cnt=cnt,
    #                     secs=(record.ts - start_ts)
    #                 )
    #                 cnt=None
    #                 start_ts=None
    #
    # from projects.common.time_utils import datetime_2_timestamp, \
    #     parse_timestring
    #
    # job.concat(
    #     job.table(
    #         '//home/taxi-delivery/analytics/dev/nkozlovskaya/frozen/cour'
    #     ).project(
    #         'dbid_uuid',
    #         # ts=ne.custom(lambda x: datetime.datetime.strptime(
    #         #     x, '%Y-%m-%d %H:%M:%S'
    #         # ), 'utc_shift_start_dttm'),
    #         ts=ne.custom(lambda x: datetime_2_timestamp(
    #             parse_timestring(x, 'UTC')
    #         ), 'utc_shift_start_dttm'),
    #         flag=ne.const('start')
    #     ),
    #     job.table(
    #         '//home/taxi-delivery/analytics/dev/nkozlovskaya/frozen/cour'
    #     ).project(
    #         'dbid_uuid',
    #         ts=ne.custom(lambda x: datetime_2_timestamp(
    #                     parse_timestring(x, 'UTC')
    #                 ),'utc_shift_end_dttm'),
    #         # ts=ne.custom(lambda x: datetime.datetime.strptime(
    #         #     x, '%Y-%m-%d %H:%M:%S'
    #         # ), 'utc_shift_end_dttm'),
    #         flag=ne.const('end')
    #     ),
    #     job.table(
    #         '//home/taxi-delivery/analytics/dev/nkozlovskaya/frozen/assignment_cands'
    #     )
    # ).filter(
    #     nf.custom(lambda x: x > 1627430400, 'ts'),
    #     nf.custom(lambda x: x < 1627516800, 'ts')
    # ).groupby(
    #     'dbid_uuid'
    # ).sort(
    #     'ts'
    # ).reduce(
    #     _reducer
    # ).put(
    #     '//home/taxi-delivery/analytics/dev/nkozlovskaya/frozen/_reducer_'
    # )

    job.run()

    from nile.api.v1 import aggregators as na

    job = cluster.job('LD metrics' + str(time.time()))
    job = job.env(bytes_decode_mode='strict')

    # job.table('//home/taxi-delivery/analytics/dev/nkozlovskaya/frozen/_reducer_').groupby(
    #     'dbid_uuid'
    # ).aggregate(
    #     secs=na.sum('secs'),
    #     cnt=na.sum('cnt')
    # ).put(
    #     '//home/taxi-delivery/analytics/dev/nkozlovskaya/frozen/_reducer__'
    # )
    #

    def _calc_everything_for_batch(groups):
        for key, records in groups:
            n = 0
            addresses = set()
            for record in records:
                n += 1
                addresses.add(record.source_adress)
            # if n > 1:
            yield Record(
                key,
                is_batch=int(n > 1),
                is_2_addresses=(len(addresses) > 1)
            )


    tmp = job.table('//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/based_on_kostya').groupby(
        'waybill_external_ref'
    ).reduce(
        _calc_everything_for_batch
    ).put(
        '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/based_on_kostya_tmp'
    )

    job.table(
        '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/based_on_kostya'
    ).join(
        tmp,
        # job.table('//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/based_on_kostya_tmp'),
        type='left', by='waybill_external_ref'
    ).put(
        '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/based_on_kostya_2'
    )


    job.run()

