import argparse
import sys
import time

import datetime
import geohash as gh
import numpy as np

from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from nile.api.v1 import Record
from qb2.api.v1 import filters as qf
from qb2.api.v1 import typing as qt

from projects.burnt_orders_research.ld_parsing_nile_block import \
    LogEntrySegmentDetector
from projects.burnt_orders_research.nile_blocks.main import (
    calc_different_stats, dup_mapper, main_reducer, get_all_waybills_by_segment,
    claim_ld_stages_mapper, claims_pattern_ld_stages_reducer
)
from projects.burnt_orders_research.nile_blocks.propositions import(
    proposition_reducer,
)
from projects.common.nile.dates import range_selector
from projects.data_sources.data_context.eda_logs import \
    DataContext as EdaOrdersDataContext
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawLogs
from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as TaxiOrdersDataContext
from projects.efficiency_metrics.project_config import get_project_cluster



if __name__ == '__main__':


    # python -m launcher_candidates --from-date 2021-05-12 --to-date 2021-06-03

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    parser.add_argument('--from-date', type=str, required=True)
    parser.add_argument('--to-date', type=str, required=True)

    args = parser.parse_args()

    cluster = get_project_cluster()

    # from_date = '2021-04-12'
    # from_date = '2021-05-05'
    # from_date = '2021-05-12'
    # to_date = '2021-05-26'
    from_date = datetime.datetime.strptime(args.from_date, '%Y-%m-%d')
    to_date = datetime.datetime.strptime(args.to_date, '%Y-%m-%d')

    yt_path_to = '//home/taxi-delivery/analytics/dev/ld/dispatch_metrics/dispatch_metrics/{}'

    CUSTOM_PARSED_LD_LOGS = (
        '//home/taxi-delivery/analytics/production/parsed_logs/segments_2_ld_parsed/{}'
    )

    CUSTOM_PARSED_TD_LOGS = (
        '//home/taxi-delivery/analytics/production/parsed_logs/segments_2_td/{}'
    )

    from projects.common.nile.dates import range_selector

    def _calc(groups):
        for key, records in groups:
            n_gambles = 0
            sec_btw_segment_and_assignment = None

            for record in records:
                n_gambles += 1
                if sec_btw_segment_and_assignment is None:
                    sec_btw_segment_and_assignment = record.sec_btw_segment_and_assignment

                # pass
            yield Record(
                key,
                n_gambles=n_gambles,
                sec_till_segment_created=record.sec_till_segment_created,
                sec_btw_claimcreated_and_assignment=record.sec_btw_claimcreated_and_assignment,
                sec_btw_segment_and_assignment=sec_btw_segment_and_assignment,
                n_candidates=record.n_candidates,
                winner_rt=record.winner_rt,
                winner_rd=record.winner_rd
            )

    job = cluster.job('LD metrics' + str(time.time()))
    job = job.env(bytes_decode_mode='strict')

    # job.table(
    #     CUSTOM_PARSED_TD_LOGS.format(range_selector(from_date, to_date, '%Y-%m-%d'))
    # ).project(
    #     "uuid_id",
    #     "chosen_waybill",
    #     "claim_id",
    #     "segment_id",
    #     "taxi_order_id",
    #     #
    #     "created",
    #     "due",
    #     # "geo_point",
    #     "is_delayed",
    #     # "winner_id",
    #     #
    #     # "candidates_meta",
    #     "s_timestamp",
    #     "timestamp",
    #     "timestamp_td",
    #     #
    #     sec_till_segment_created=ne.custom(
    #         lambda x, y: (x - y), 's_timestamp', 'timestamp'
    #     ),
    #     sec_btw_segment_and_assignment=ne.custom(
    #         lambda x, y: (x - y), 'timestamp_td', 's_timestamp'
    #     ),
    #     sec_btw_claimcreated_and_assignment=ne.custom(
    #         lambda x, y: (x - y), 'timestamp_td', 'timestamp'
    #     ),
    #     #
    #     n_candidates=ne.custom(
    #         lambda x: len([
    #             dbid_uuid for dbid_uuid, info in x.items()
    #             if (info['score'] is not None)
    #         ]), 'candidates_meta'
    #     ),
    #     winner_rt=ne.custom(
    #         lambda x, y: x[y]['rt'], 'candidates_meta', 'winner_id'
    #     ),
    #     winner_rd=ne.custom(
    #         lambda x, y: x[y]['rd'], 'candidates_meta', 'winner_id'
    #     )
    #
    # ).groupby(
    #     "uuid_id",
    #     "chosen_waybill",
    #     "claim_id",
    #     "segment_id",
    #     "taxi_order_id",
    #     #
    #     "created",
    #     "due",
    #     # "geo_point",
    #     "is_delayed",
    # ).sort(
    #     'timestamp_td'
    # ).reduce(
    #     _calc
    # ).put(
    #     yt_path_to.format('td_candidates_{}'.format(to_date.strftime('%Y-%m-%d')))
    # )

    # from projects.data_sources.data_context.cargo import \
    #     DataContext as CargoLogsDataContext
    #
    cargo_d_c = CargoLogsDataContext(job, from_date, to_date)


    claims = cargo_d_c.get_claims().project(
        'taxi_order_id', 'uuid_id', 'is_delayed', 'due', 'zone_id', 'corp_client_id',
        utc_date=ne.custom(
            lambda x:
            datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%d'),
            'timestamp'
        ),
        hour=ne.custom(
            lambda x:
            datetime.datetime.utcfromtimestamp(x).hour,
            'timestamp'
        ),
        utc_date_hour=ne.custom(
            lambda x:
            datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%d %H'),
            'timestamp'
        )

    )

    segments = cargo_d_c.get_segments().project(ne.all(['timestamp', 'source']))

    tmp = claims.join(
        segments, by_left='uuid_id', by_right='claim_id', type='inner'
    )
    #
    # job.table(yt_path_to.format('td_candidates_{}'.format(to_date.strftime('%Y-%m-%d')))).join(
    #     claims, by=[
    #         "taxi_order_id", 'uuid_id',
    #     ], type='inner'
    # ).put(
    #     yt_path_to.format(
    #         'td_candidates_{}_joined'.format(to_date.strftime('%Y-%m-%d')))
    # )

    # LD
    from nile.api.v1 import aggregators as na

    # job.table(
    #     CUSTOM_PARSED_LD_LOGS.format(
    #         range_selector(from_date, to_date, '%Y-%m-%d'))
    # ).filter(
    #     nf.equals('type', 'edges')
    # ).project(
    #     'segment_id',
    #     'timestamp_ld',
    #     n_candidates=ne.custom(
    #         lambda x: len([info for info in x if (info['kind'] == 'regular')]), 'available_candidates'
    #     )
    #
    # ).groupby(
    #     'segment_id'
    # ).aggregate(
    #     n_candidates=na.last('n_candidates', by='timestamp_ld')
    # ).put(
    #     yt_path_to.format(
    #         'ld_candidates_{}'.format(to_date.strftime('%Y-%m-%d')))
    # )

    # job.table(
    #     yt_path_to.format(
    #         'ld_candidates_{}'.format(to_date.strftime('%Y-%m-%d')))
    # ).join(
    #     tmp, by='segment_id', type='inner'
    # ).put(
    #     yt_path_to.format(
    #         'ld_candidates_{}_joined'.format(to_date.strftime('%Y-%m-%d')))
    # )


    job.run()
