import argparse
import sys
import time

import datetime
import geohash as gh
import numpy as np

from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from nile.api.v1 import Record
from qb2.api.v1 import filters as qf
from qb2.api.v1 import typing as qt

from projects.burnt_orders_research.ld_parsing_nile_block import \
    LogEntrySegmentDetector
from projects.burnt_orders_research.nile_blocks.main import (
    calc_different_stats, dup_mapper, main_reducer, get_all_waybills_by_segment,
    claim_ld_stages_mapper, claims_pattern_ld_stages_reducer
)
from projects.burnt_orders_research.nile_blocks.propositions import(
    proposition_reducer,
)
from projects.common.nile.dates import range_selector
from projects.data_sources.data_context.eda_logs import \
    DataContext as EdaOrdersDataContext
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawLogs
from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as TaxiOrdersDataContext
from projects.efficiency_metrics.project_config import get_project_cluster



if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    parser.add_argument('--from-date', type=str, required=True)
    parser.add_argument('--to-date', type=str, required=True)

    args = parser.parse_args()

    cluster = get_project_cluster()

    # from_date = '2021-04-12'
    # from_date = '2021-05-05'
    # from_date = '2021-05-12'
    # to_date = '2021-05-26'
    from_date = datetime.datetime.strptime(args.from_date, '%Y-%m-%d')
    to_date = datetime.datetime.strptime(args.to_date, '%Y-%m-%d')

    yt_path_to = '//home/taxi-delivery/analytics/dev/ld/dispatch_metrics/dispatch_metrics/{}'

    def _get_statuses_changes(groups):
        for key, records in groups:
            queue = []
            for record in records:
                queue.append([record.new_status, record.event_time])
            yield Record(
                key,
                queue=queue
            )

    job = cluster.job('LD metrics' + str(time.time()))
    job = job.env(bytes_decode_mode='strict')

    st = job.table('//home/taxi/production/replica/postgres/cargo_claims/claim_audit').groupby(
        'claim_id'
    ).sort(
        'event_time'
    ).reduce(
        _get_statuses_changes
    )#.put(
    #     yt_path_to.format('statuses_changes')
    # )

    # cargo_d_c = CargoLogsDataContext(job, from_date, to_date)
    #
    # claims = cargo_d_c.get_claims().project(
    #     'taxi_order_id', 'uuid_id', 'is_delayed', 'due', 'timestamp', 'id',
    #     'corp_client_id'
    # )
    # segments = cargo_d_c.get_segments()
    #
    # st_2 = claims.filter(
    #     nf.custom(lambda x: x != 'platform_usage', 'claim_kind')
    # ).join(
    #     segments,
    #     by_left='uuid_id', by_right='claim_id', type='left',
    # ).project(
    #     ne.all(),
    #     utc_date=ne.custom(
    #         lambda x:
    #         datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%d'),
    #         'timestamp'
    #     ),
    #     utc_date_hour=ne.custom(
    #         lambda x:
    #         datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%d %H'),
    #         'timestamp'
    #     )
    # ).filter(
    #     nf.custom(lambda x: x >= '2021-06-03', 'utc_date')
    # ).join(
    #     st,
    #     # job.table(yt_path_to.format('statuses_changes')),
    #     by_left='id', by_right='claim_id', type='inner'
    # ).put(
    #     yt_path_to.format('statuses_changes_2')
    # )

    def get_diff_in_sec_bts_statuses(from_status, to_status, x):
        from_ts = None
        to_ts = None
        for el in x:
            if el[0] == from_status:
                from_ts = el[1]
            elif el[0] == to_status:
                to_ts = el[1]
        return (to_ts - from_ts) if ((from_ts is not None) and (to_ts is not None)) else None


    job.table(yt_path_to.format('statuses_changes_2')).project(
        ne.all(),
        sec_from_new_2_estimating=ne.custom(
            lambda x: get_diff_in_sec_bts_statuses('new', 'estimating', x),
            'queue'
        ),
        sec_from_estimating_2_ready_for_approval=ne.custom(
            lambda x: get_diff_in_sec_bts_statuses('estimating', 'ready_for_approval', x),
            'queue'
        ),
        sec_from_ready_for_approval_2_accepted=ne.custom(
            lambda x: get_diff_in_sec_bts_statuses('ready_for_approval', 'accepted', x),
            'queue'
        ),
    ).join(
        job.table(yt_path_to.format('calc_different_stats_2_claims')),
        by=['segment_id', 'chosen_waybill'],
        type='inner'
    ).put(
        yt_path_to.format('statuses_changes_3')
    )

    from nile.api.v1 import aggregators as na

    def get_diff_(tl, qe):
        ts_fst_segment_info = None
        ts_fst_accepted = None

        ts_1 = None
        ts_2 = None
        for el in qe:
            if (ts_1 is None) and (el[0]=='accepted'):
                ts_1 = el[1]
                break
        if tl is not None:

            for el in tl:
                if (ts_2 is None) and(el[0] == 'segment_info'):
                    ts_2 = el[1]
                    break
        return (ts_2 - ts_1) if ((ts_1 is not None) and (ts_2 is not None)) else None



    # job.table(yt_path_to.format('statuses_changes_3')).project(
    #     ne.all(),
    #     sec_from_accepted_2_ld=ne.custom(lambda x, y: get_diff_(x, y) , 'timeline', 'queue')
    # ).put(
    #     yt_path_to.format('statuses_changes_5')
    # )

    def calc_tmp(groups):
        for key, records in groups:
            n_queue_str = 0
            examples = []
            for record in records:
                n_queue_str  += 1
                if len(examples) < 100:
                    examples.append(record.claim_id)
            yield Record(
                key,
                n_queue_str  = n_queue_str,
                examples=examples
            )

    # job.table(yt_path_to.format('statuses_changes_3')).project(
    #     ne.all(),
    #     queue_str=ne.custom(lambda x: ' '.join([el[0] for el in x]), 'queue'),
    # ).groupby(
    #     'queue_str'
    # ).reduce(
    #     calc_tmp
    # ).project(
    #     ne.all(),
    #     minus_n_queue_str=ne.custom(lambda x: -x, 'n_queue_str')
    # ).sort('minus_n_queue_str').put(yt_path_to.format('statuses_changes_4'))

    job.run()