import argparse
# import time

import datetime

from projects.efficiency_metrics.manager import Manager
from projects.efficiency_metrics.project_config import get_project_cluster

from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf

from projects.data_sources.data_context.eda_logs import \
    DataContext as EdaOrdersDataContext
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawLogs

from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
import time

from nile.api.v1 import filters as nf

import geohash as gh

if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')

    cluster = get_project_cluster()

    # from_date = '2021-05-17'
    to_date = '2021-05-21'

    # yt_path_to = '//home/taxi-delivery/analytics/dev/ld/dispatch_metrics/{}'

    yt_path_to = '//home/taxi-delivery/analytics/production/ld/dispatch_metrics/{}'


    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(bytes_decode_mode='strict')
                  #, yt_spec_defaults={'max_failed_job_count': 1000})

    from nile.api.v1 import Record

    def _parse_proposition_reducer(groups):
        for key, records in groups:

            # start_session_ts = None
            # finish_session_ts = None
            #
            queue = []
            for record in records:
                # contractor_id = record.contractor_id

                queue.append(
                    [
                        # contractor_id,
                        record.history_timestamp,
                        record.history_action,
                        record.order_id
                    ]
                )

                # if (contractor_id is not None) and (contractor_id != ''):
                #     start_session_ts = record.history_timestamp
                #
                # record.history_action
                # record.history_timestamp
                # record.order_id
                # pass
            yield Record(
                key,
                queue=queue
            )

    # job.table(
    #     '//home/taxi/testing/export/taxi-logistic-dispatcher-production/route_propositions_history/{}'.format(to_date)
    # ).groupby(
    #     'proposition_id', 'contractor_id'
    # ).sort(
    #     'history_timestamp'
    # ).reduce(
    #     _parse_proposition_reducer
    # ).put(
    #     yt_path_to.format('proposition_{}'.format(to_date))
    # )

    # это только логи ЛД
    # TODO - сделать по логам ТД
    # TODO -

    def calc_ts_diff_mapper(records):
        for record in records:
            queue = record.queue
            if len(queue) == 0:
                continue
            else:

                order_id = queue[-1][2]

                sec_interval = int(queue[-1][0]) - int(queue[0][0])
                yield Record(
                    contractor_id=record.contractor_id,
                    proposition_id=record.proposition_id,
                    sec_interval=sec_interval,
                    final_status=queue[-1][1],
                    order_id=order_id

                )

    job.table(yt_path_to.format('proposition_{}'.format(to_date))).map(
        calc_ts_diff_mapper
    ).put(
        yt_path_to.format('proposition_{}_map'.format(to_date))
    )

    # job.table(yt_path_to.format('proposition_{}_map'.format(to_date))).project(
    #     'contractor_id'
    # ).unique('contractor_id').put(
    #     yt_path_to.format('unique_{}'.format(to_date))
    # )

    # ['nizhnynovgorod']

    from projects.data_sources.data_context.raworders_dmorders_sessions import \
        DataContext as OrdersSessionsLogsDataContext
    from qb2.api.v1 import filters as qf

    from_date = '2021-05-21'
    to_date = '2021-05-22'

    orders_d_c = OrdersSessionsLogsDataContext(
        job,
        datetime.datetime.strptime(
            from_date, '%Y-%m-%d')
        ,
        datetime.datetime.strptime(
            to_date, '%Y-%m-%d'
        ),
        ['atlas_drivers', 'light_order_proc', 'sessions']
    )

    from projects.efficiency_metrics.nile_blocks import \
        sessions as sessions_nile_blocks

    # all_profiles = orders_d_c.get_sessions().filter(
    #     qf.defined('enabled_tariff_class_code_list'),
    #     nf.custom(
    #         lambda x: ('courier' in x) or ('express' in x),
    #         'enabled_tariff_class_code_list'
    #     )).groupby('dbid_uuid').sort('lcl_valid_from_dttm').reduce(sessions_nile_blocks.make_queue_statuses_aggregated
    # ).put(
    #     yt_path_to.format('all_logistic_sessions_{}_{}'.format(from_date, to_date))
    # )

    # job.table(
    #     yt_path_to.format('all_logistic_sessions_{}_{}'.format(from_date, to_date))
    # ).project(
    #     ne.all(['queue']),
    #     was_on_line=ne.custom(
    #         lambda x:
    #         int(
    #             sum(
    #                 [el[2] for el in x if el[1] not in set(['off', 'verybusy'])]
    #             ) > 0
    #         ),
    #         'queue'
    #     ),
    #     sh_wo_free=ne.custom(
    #         lambda x:
    #         sum([
    #             el[2] for el in x if (
    #                     el[1] in set(['driving', 'transporting', 'waiting']))
    #         ]),
    #         'queue'
    #     ),
    #     sh_free_more_than_0=ne.custom(
    #         lambda x: sum([el[2] for el in x if (el[1] in set(['free']))]),
    #         'queue'
    #     ),
    #     sh=ne.custom(
    #         lambda x:
    #         sum([
    #             el[2] for el in x if (
    #                     el[1] in set(['driving', 'transporting', 'waiting', 'free']))
    #         ]),
    #         'queue'
    #     ),
    # ).filter(
    #     nf.custom(lambda x: x > 0, 'was_on_line')
    # ).put(
    #     yt_path_to.format(
    #                 'on_line_{}_{}'.format(from_date, to_date))
    # )


    job.run()