import argparse
import sys
import time

import datetime
import geohash as gh
import numpy as np

from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from nile.api.v1 import Record
from qb2.api.v1 import filters as qf
from qb2.api.v1 import typing as qt

from projects.burnt_orders_research.ld_parsing_nile_block import \
    LogEntrySegmentDetector
from projects.burnt_orders_research.nile_blocks.main import (
    calc_different_stats, dup_mapper, main_reducer, get_all_waybills_by_segment,
    claim_ld_stages_mapper, claims_pattern_ld_stages_reducer
)
from projects.burnt_orders_research.nile_blocks.propositions import(
    proposition_reducer,
)
from projects.common.nile.dates import range_selector
from projects.data_sources.data_context.eda_logs import \
    DataContext as EdaOrdersDataContext
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawLogs
from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as TaxiOrdersDataContext
from projects.efficiency_metrics.project_config import get_project_cluster



if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    # parser.add_argument('--from-date', type=str, required=True)
    # parser.add_argument('--to-date', type=str, required=True)

    args = parser.parse_args()

    cluster = get_project_cluster()

    # from_date = '2021-04-12'
    # from_date = '2021-05-05'
    # from_date = '2021-05-12'
    # to_date = '2021-05-26'
    # from_date = datetime.datetime.strptime(args.from_date, '%Y-%m-%d')
    # to_date = datetime.datetime.strptime(args.to_date, '%Y-%m-%d')

    yt_path_to = '//home/taxi-delivery/analytics/dev/ld_lavka_debug/{}'

    job = cluster.job('LD metrics' + str(time.time()))
    job = job.env(bytes_decode_mode='strict')

    def _reducer(groups):
        for key, records in groups:
            write_to_yt = False
            for record in records:
                if (record.get('corp_client_id', '') == 'dc28c565829e48cca458b5feb161d5d6'):
                    write_to_yt = True

                if write_to_yt:
                    yield Record(record)
            write_to_yt = False


    # job.table('//home/taxi-delivery/analytics/production/parsed_logs/segments_2_ld_parsed/2021-05-18').groupby(
    #     'segment_id'
    # ).sort(
    #     'timestamp_ld'
    # ).reduce(
    #     _reducer
    # ).put(
    #     yt_path_to.format('segments_lavka')
    # )
    #
    # job.table(
    #     yt_path_to.format('segments_lavka')
    # ).filter(
    #     nf.equals('type', 'edges')
    # ).put(yt_path_to.format('segments_lavka_edges'))
    #
    #
    job.table(yt_path_to.format('segments_lavka_edges')).unique(
        'segment_id'
    ).put(yt_path_to.format('segments_lavka_edges_unique'))

    job.run()