import argparse
# import time

import datetime

from projects.efficiency_metrics.manager import Manager
from projects.efficiency_metrics.project_config import get_project_cluster

from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf

from projects.data_sources.data_context.eda_logs import \
    DataContext as EdaOrdersDataContext
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawLogs

from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
import time
import sys

import numpy as np

from qb2.api.v1 import typing as qt

from nile.api.v1 import filters as nf


import geohash as gh

from qb2.api.v1 import filters as qf
from projects.burnt_orders_research.ld_parsing_nile_block import \
    LogEntrySegmentDetector

from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as TaxiOrdersDataContext


from projects.burnt_orders_research.nile_blocks.main import (
    calc_different_stats, dup_mapper, main_reducer, get_all_waybills_by_segment
)
from projects.common.nile.dates import range_selector



def get_table_with_claims(from_date, to_date):

    cargo_d_c = CargoLogsDataContext(
        job,
        datetime.datetime.strptime(
            from_date, '%Y-%m-%d')
        ,
        datetime.datetime.strptime(
            to_date, '%Y-%m-%d'
        ),
    )

    claims = cargo_d_c.get_claims().project(
        'taxi_order_id', 'uuid_id', 'is_delayed', 'due', 'timestamp'
    )
    segments = cargo_d_c.get_segments()
    return (
        job.table(
            '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/realtime_schema'
        ).filter(
            nf.custom(
                lambda x: x in [
                    'ld_vs_taxi_dispatch_experiment_2021-03-11',
                    'corps_v4_31_03',
                    'ld_vs_taxi_dispatch_experiment_2021-04-14',
                    'russia_cities_15_04',
                    'ld_80_20_1205_test'
                ],
                'group'
            )
        ).join(
            claims.filter(
                nf.custom(lambda x: x != 'platform_usage', 'claim_kind')
            ).join(
                segments,
                by_left='uuid_id', by_right='claim_id', type='left',
            ).project(
                ne.all(),
                utc_date=ne.custom(
                    lambda x:
                    datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%d'),
                    'timestamp'
                ),
                utc_date_hour=ne.custom(
                    lambda x:
                    datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%d %H'),
                    'timestamp'
                )
            ).filter(
                nf.custom(lambda x: x >= from_date, 'utc_date')
            ).project(
                "claim_id",
                "due",
                "is_delayed",
                "s_timestamp",
                "segment_id",
                'employer',
                'utc_date',
                'utc_date_hour'
            ), type='left', by='claim_id'
        )
    )

if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')

    cluster = get_project_cluster()

    # from_date = '2021-04-12'
    from_date = '2021-05-05'
    to_date = '2021-05-18'
    yt_path_to = '//home/taxi-delivery/analytics/production/ld/dispatch_metrics/{}'

    job = cluster.job('LD metrics' + str(time.time()))
    job = job.env(bytes_decode_mode='strict')

    # job.table('//home/taxi-delivery/analytics/production/ld/dispatch_metrics/acceptance').project(
    #     'walking_courier', 'unset_unconfirmed_performer', 'transport_type',
    #     'seen_timeout', 'seen',
    #     'reject_autocancel', 'reject_manual', 'missingtariffs', 'offer_timeout',
    #     'finished_complete', 'driver_id', 'db_id',
    #     'chained', 'candidate_idx', 'assigned', 'auto_courier',
    #     'order_id'
    # ).join(
    #     job.table('//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/realtime_schema').project(
    #         'zone_id', 'claim_id', 'utc_date', 'group', 'status',
    #         'taxi_order_id'
    #     ).filter(
    #         nf.custom(lambda x: from_date < x < to_date, 'utc_date')
    #     ),
    #     by_left='order_id', by_right='taxi_order_id', type='inner'
    # ).put(
    #     '//home/taxi-delivery/analytics/production/ld/dispatch_metrics/full_acceptance'
    # )

    from nile.api.v1 import Record
    def _status_reducer(groups):
        for key, records in groups:
            for record in records:
                pass
            yield Record(
                key,

            )

    job.table(
        '//home/taxi-delivery/analytics/production/ld/dispatch_metrics/full_acceptance'
    ).groupby(
        'utc_date'
    ).reduce(
        _status_reducer
    ).put(
        '//home/taxi-delivery/analytics/production/ld/dispatch_metrics/_statuses'
    )

    #     .groupby(
    #     'taxi_order_id', 'driver_id'
    # )


    job.run()