import argparse
# import time

import datetime

# from projects.efficiency_metrics.manager import Manager
from projects.efficiency_metrics.project_config import get_project_cluster

from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf

from projects.data_sources.data_context.eda_logs import \
    DataContext as EdaOrdersDataContext
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawLogs

from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
import time

from nile.api.v1 import filters as nf

import geohash as gh

from qb2.api.v1 import filters as qf
from projects.burnt_orders_research.ld_parsing_nile_block import \
    LogEntrySegmentDetector

from nile.api.v1 import Record

from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as TaxiOrdersDataContext

from projects.burnt_orders_research.dry_run_ld import (
    get_ld_logs, parse_ld_logs, get_td_logs
)


if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    parser.add_argument('--from-date', type=str, default='Hahn')
    parser.add_argument('--to-date', type=str, default='Hahn')

    cluster = get_project_cluster()
    args = parser.parse_args()

    # target_date = args.target_date # -1 day
    from_date = args.from_date # -1 day
    to_date = args.to_date # +1 day / today

    yt_path_to = '//home/taxi-delivery/analytics/production/parsed_logs/{}'

    #

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(bytes_decode_mode='strict',
                  yt_spec_defaults={'max_failed_job_count': 1000})

    cargo_d_c = CargoLogsDataContext(
        job,
        datetime.datetime.strptime(
            from_date, '%Y-%m-%d')
        ,
        datetime.datetime.strptime(
            to_date, '%Y-%m-%d'
        ),
    )
    claims = cargo_d_c.get_claims().project(
        'taxi_order_id', 'uuid_id', 'is_delayed', 'due', 'timestamp',
        'claim_kind'
    )
    segments = cargo_d_c.get_segments()

    waybills_segments = cargo_d_c.get_waybills_segments()

    tmp = claims.filter(
        nf.custom(lambda x: x != 'platform_usage', 'claim_kind')
    ).join(
        segments,
        by_left='uuid_id', by_right='claim_id', type='left',
    ).put(
        yt_path_to.format('{}/{}'.format('segments', from_date))
    )
    job.run()

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(
        bytes_decode_mode='strict',
        yt_spec_defaults={'max_failed_job_count': 1000}
    )
    job = get_ld_logs(
        job, from_date, to_date,
        yt_path_to.format('{}/{}'.format('segments', from_date)),
        yt_path_to.format('{}/{}'.format('segments_2_ld', from_date))
    )
    job.run()

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(
        bytes_decode_mode='strict',
        yt_spec_defaults={'max_failed_job_count': 1000}
    )
    job = parse_ld_logs(
        job, from_date, to_date,
        yt_path_to.format('{}/{}'.format('segments_2_ld', from_date)),
        yt_path_to.format('{}/{}'.format('segments_2_ld_parsed', from_date))
    )
    job.run()

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(
        bytes_decode_mode='strict',
        yt_spec_defaults={'max_failed_job_count': 1000}
    )
    job = get_td_logs(
        job, from_date, to_date,
        yt_path_to.format('{}/{}'.format('segments', from_date)),
        yt_path_to.format('{}/{}'.format('segments_2_td', from_date))
    )
    job.run()


