import argparse
# import time

import datetime

from projects.efficiency_metrics.manager import Manager
from projects.efficiency_metrics.project_config import get_project_cluster

from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf

from projects.data_sources.data_context.eda_logs import \
    DataContext as EdaOrdersDataContext
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawLogs

from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
import time

from nile.api.v1 import filters as nf

import geohash as gh

if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')

    cluster = get_project_cluster()

    from_date = '2021-05-17'
    to_date = '2021-05-18'

    yt_path_to = '//home/taxi-delivery/analytics/dev/ld/dispatch_metrics/{}'

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(bytes_decode_mode='strict')
                  #, yt_spec_defaults={'max_failed_job_count': 1000})

    cargo_d_c = CargoLogsDataContext(
        job,
        datetime.datetime.strptime(
            from_date, '%Y-%m-%d')
        ,
        datetime.datetime.strptime(
            to_date, '%Y-%m-%d'
        ),
    )

    claims = cargo_d_c.get_claims().project(
        'taxi_order_id', 'uuid_id', 'is_delayed', 'due', 'timestamp',
        'claim_kind', 'zone_id'
    ).filter(
                nf.custom(lambda x: x != 'platform_usage', 'claim_kind'),
                nf.custom(lambda x: x is not None, 'taxi_order_id')
            )

    # type of supply
    # walking_courier + scooter_courier = курьер на самокате или велосипеде
    # auto_courier + bike_courier = курьер на мотоцикле или скутере
    # auto_courier
    # walking_courier
    # taxi_courier
    # [подключены express, courier,  ?? cargo]

    # сколько водителей, которые возят по ЛД - возят и в ТД
    # сколько водителей, которые возят по TД - возят и по ЛД

    # спец требования - взять из  ТД??
    # спец требования - взять ил reqs ??

    # как рассчитываеется eta для такого сапллая
    # не попадает в ЛД часть сапплая
    # (к клеймаам приджойнтиь исполнителя. и дальше определит ьтип сапплая, которым вывеезои)

    # - теги
    # - стьюпиды
    # - пеший
    # - авто
    # - мото
    # - ??
    #
    #
    # - воронка
    # - проверка кандидатов
    #
    # проверка сапплая/кандидатов
    # (1)
    # (2)
    # (3) все ли курьеры нанятые идут в диспатч ??
    # (4)

    # cargo_d_c.get_orders_performers().put(
    #     yt_path_to.format(
    #         'orders_performers_{}_{}'.format(from_date, to_date))
    # )

    # job.table()

    from projects.data_sources.data_context.raworders_dmorders_sessions import \
        DataContext as OrdersSessionsLogsDataContext
    from qb2.api.v1 import filters as qf

    orders_d_c = OrdersSessionsLogsDataContext(
        job,
        datetime.datetime.strptime(
            from_date, '%Y-%m-%d')
        ,
        datetime.datetime.strptime(
            to_date, '%Y-%m-%d'
        ),
        ['atlas_drivers', 'light_order_proc', 'sessions']
    )

    # all_profiles = orders_d_c.get_sessions().filter(
    #     qf.defined('enabled_tariff_class_code_list'),
    #     nf.custom(
    #         lambda x: ('courier' in x) or ('express' in x),
    #         'enabled_tariff_class_code_list'
    #     )
    # ).project(
    #     'dbid_uuid', 'driver_uuid', 'park_taximeter_id'
    # ).unique(
    #     'dbid_uuid', 'driver_uuid', 'park_taximeter_id'
    # ).put(
    #     yt_path_to.format('all_logistic_supply_{}_{}'.format(from_date, to_date))
    # )

    from projects.efficiency_metrics.nile_blocks import \
        sessions as sessions_nile_blocks
    # all_profiles = orders_d_c.get_sessions().filter(
    #     qf.defined('enabled_tariff_class_code_list'),
    #     nf.custom(
    #         lambda x: ('courier' in x) or ('express' in x),
    #         'enabled_tariff_class_code_list'
    #     )).groupby('dbid_uuid').sort('lcl_valid_from_dttm').reduce(sessions_nile_blocks.make_queue_statuses_aggregated
    # ).put(
    #     yt_path_to.format('all_logistic_sessions_{}_{}'.format(from_date, to_date))
    # )
    # заявки, которыее были вывезены logistic-dispatch
    # ??

    # job.table('//home/logfeller/logs/taxi-driver-priority-view-polling-priority-log/1d/{2021-05-15..2021-05-20}').project(
    #     'dbid_uuid', 'tags'
    # ).unique(
    #     'dbid_uuid'
    # ).filter(
    #     nf.custom(
    #         lambda x: (
    #                 ('walking_courier' in x) or
    #                 ('taxi_courier' in x) or
    #                 ('auto_courier' in x)), 'tags'
    #     )
    #
    # # auto_courier
    # # walking_courier
    # # taxi_courier
    # ).put(
    #     yt_path_to.format(
    #         'delivery_tags_{}_{}'.format(from_date, to_date))
    # )



    # взять всех исполнителей доставки и курььеераа. и

    # job.table(//home/taxi/production/replica/postgres/cargo_claims/claim_segments).project(
    # 'claim_uuid', 'cargo_order_id', 'provider_order_id',
    # 'special_requirements', 'allow_batch'
    # )

    # job.table(
    #     yt_path_to.format(
    #         'orders_performers_{}_{}'.format(from_date, to_date))
    # ).join(
    #     cargo_d_c.get_waybills(), by='cargo_order_id',
    #     type='inner'
    # ).project(
    #     ne.all(),
    #     dispatch_type=ne.custom(
    #         lambda x: x.split('/')[0] if x is not None else None,
    #         'external_ref'
    #     )
    # ).put(
    #     yt_path_to.format(
    #         'orders_performers_waybills_{}_{}'.format(from_date, to_date))
    # )

    # job.table(
    #     yt_path_to.format(
    #         'orders_performers_waybills_{}_{}'.format(from_date, to_date))
    # ).join(
    #     claims, by='taxi_order_id', type='inner'
    # ).join(
    #     job.table(yt_path_to.format(
    #         'delivery_tags_{}_{}'.format(from_date, to_date))),
    #     type='inner', by='dbid_uuid'
    # ).put(
    #     yt_path_to.format(
    #         'orders_performers_waybills_wo_eda_lavka_{}_{}'.format(from_date, to_date))
    # )

    def _s(tags):
        if ('walking_courier' in tags):
            if 'scooter_courier' in tags:
                return 'scooter_courier'
            else:
                return 'walking_courier'
        elif ('taxi_courier' in tags):
            return 'taxi_courier'
        elif ('auto_courier' in tags):
            if 'bike_courier' in tags:
                return 'bike_courier'
            else:
                return 'auto_courier'
        # walking_courier + scooter_courier = курьер на самокате или велосипеде
        #     # auto_courier + bike_courier

    # job.table(
    #     yt_path_to.format(
    #                 'orders_performers_waybills_wo_eda_lavka_{}_{}'.format(from_date, to_date))
    # ).project(
    #
    #     'dbid_uuid', 'dispatch_type', 'transport_type', 'zone_id', #tags,
    #     supply_type=ne.custom(lambda x: _s(x), 'tags')
    #
    # ).put(
    #     yt_path_to.format(
    #         'supply_type_{}_{}'.format(from_date, to_date))
    # )
    # dbid_uuid, dispatch_type, tags, transport_type


    # для каждого водителя  -> число SH ??; -> в каких роутер тайпах он участвовал

    # job.table(
    #     yt_path_to.format(
    #         'all_logistic_sessions_{}_{}'.format(from_date, to_date))
    # ).join(
    # job.table(
    #     yt_path_to.format(
    #         'delivery_tags_{}_{}'.format(from_date, to_date))
    # ), type='inner', by='dbid_uuid'
    # ).project(
    #     ne.all(['tags']),
    #     supply_type=ne.custom(lambda x: _s(x), 'tags'),
    # ).put(
    #     yt_path_to.format(
    #         'all_logistic_sessions_2_tags_{}_{}'.format(from_date, to_date))
    # )

    # job.table(yt_path_to.format('all_logistic_sessions_2_tags_{}_{}'.format(from_date, to_date))).project(
    #     ne.all(['queue']),
    #     was_on_line=ne.custom(
    #         lambda x:
    #         int(
    #             sum(
    #                 [el[2] for el in x if el[1] not in set(['off', 'verybusy'])]
    #             ) > 0
    #         ),
    #         'queue'
    #     ),
    #     sh_wo_free=ne.custom(
    #         lambda x:
    #         sum([
    #             el[2] for el in x if (
    #                     el[1] in set(['driving', 'transporting', 'waiting']))
    #         ]),
    #         'queue'
    #     ),
    #     sh_free_more_than_0=ne.custom(
    #         lambda x: sum([el[2] for el in x if (el[1] in set(['free']))]),
    #         'queue'
    #     ),
    #     sh=ne.custom(
    #         lambda x:
    #         sum([
    #             el[2] for el in x if (
    #                     el[1] in set(['driving', 'transporting', 'waiting', 'free']))
    #         ]),
    #         'queue'
    #     ),
    # ).filter(
    #     nf.custom(lambda x: x > 0, 'was_on_line')
    # ).put(
    #     yt_path_to.format(
    #                 'on_line_{}_{}'.format(from_date, to_date))
    # )


    from nile.api.v1 import Record
    def _red(groups):
        for key, records in groups:
            for record in records:
                pass
            yield Record(key, )

    # job.table(
    #     yt_path_to.format(
    #                 'on_line_{}_{}'.format(from_date, to_date))
    # ).join(
    #     job.table(yt_path_to.format(
    #         'orders_performers_waybills_{}_{}'.format(from_date, to_date))),
    #     type='left', by='dbid_uuid'
    # ).put(
    #     yt_path_to.format(
    #         'on_line_2_perfs_{}_{}'.format(from_date, to_date))
    # )

    from collections import Counter
    def _reducer_(groups):
        for key, records in groups:
            cnt_empty = Counter()
            cnt_normal_ld = Counter()
            cnt_normal_td = Counter()
            for record in records:
                if record.cargo_order_id is None:
                    cnt_empty[record.supply_type] += 1
            yield Record(
                key,

            )

    job.table(
        yt_path_to.format('on_line_2_perfs_{}_{}'.format(from_date, to_date))
    ).groupby(
        'tariff_zone'
    ).reduce(
        _reducer_
    ).put(
        yt_path_to.format('on_line_2_perfs__2_tz_{}_{}'.format(from_date, to_date))
    )

    # сколько водителей, которые вышли на линию, но не получили заказ
    # сколько водителей, которые вышли на линию6 сделали 1 заказ

    # кандидаты:
    # доля кандидатов, которых не было в ЛД весь день
    # которые не было в ТД весь день

    job.run()


