
from nile.api.v1 import Record


def proposition_reducer(groups):

    # В рамках proposition находим первое событие по history_timestamp —
    # это время создания пропозишена.
    # В рамках proposition находим первую строчку с непустым order_id —
    # это время, когда из propositions_journal получили данные о заказе такси.
    # События approved/rejected — реакция на предложение от курьера.
    for key, records in groups:
        queue = []
        fst_ts_order_id_is_not_none = None
        fst_approved_or_reject_ts = None
        for record in records:
            queue.append([
                int(record.history_timestamp),
                record.contractor_id,
                record.history_action,
                record.order_id
            ])
            if (fst_ts_order_id_is_not_none is None) and (record.order_id != ""):
                fst_ts_order_id_is_not_none = int(record.history_timestamp)
            if (fst_approved_or_reject_ts is None) and (
                    record.history_action in ['rejected', 'approved']):
                fst_approved_or_reject_ts = int(record.history_timestamp)
        proposition_ts_created = queue[0][0]
        approved_or_rejected_ts = (
                queue[-1][0] #if (queue[-1][2] in ['rejected', 'approved'])
                #else None
            )
        yield Record(
            key,
            queue=queue,
            proposition_ts_created=proposition_ts_created,
            fst_ts_order_id_is_not_none=fst_ts_order_id_is_not_none,
            approved_or_rejected_ts=approved_or_rejected_ts,
            fst_approved_or_reject_ts=fst_approved_or_reject_ts,

            sec_from_created_proposition_to_order_id=float(
                    fst_ts_order_id_is_not_none - proposition_ts_created
            ) if (fst_ts_order_id_is_not_none is not None) and (
                    proposition_ts_created is not None) else None,
            sec_from_order_id_to_1st_reject_or_approve=float(
                    fst_approved_or_reject_ts - fst_ts_order_id_is_not_none
            ) if (fst_approved_or_reject_ts is not None) and (
                    fst_ts_order_id_is_not_none is not None) else None,
            sec_full_cycle_proposition=float(
                approved_or_rejected_ts - proposition_ts_created
            ) if (approved_or_rejected_ts is not None) and (
                    proposition_ts_created is not None) else None
        )