
-- INSERT INTO "analyst.nkozlovskaya_tmp"
select o.msk_created_dttm                                                                                as created_at,
       o.order_asap_flg::integer                                                                         as is_asap,
       o.order_id                                                                                        as order_id,
       o.order_nr                                                                                        as order_nr,
       o.order_status                                                                                    as status,
       case when o.order_status = 4 then 'Доставлен' else o.cancel_reason_name end                       as cancel_reason,
       case when o.order_status = 4 then 'Доставлен' else o.cancel_reason_group_code end                 as cancel_reason_group,
       o.region_id                                                                                       as region_id,
       o.region_name                                                                                     as region_name,
       o.courier_type                                                                                    as courier_type,
       o.place_name                                                                                      as place_name,
       o.place_id                                                                                        as place_id,
       o.place_lat                                                                                       as place_latitude,
       o.place_lon                                                                                       as place_longitude,
       o.location_lat                                                                                    as client_latitude,
       o.location_lon                                                                                    as client_longitude,
       o.courier_delivery_zone_name                                                                      as zone_name,
       o.place_delivery_zone_id                                                                          as delivery_zone_id,
       o.place_delivery_zone_name                                                                        as delivery_zone_type,
       case when o.order_asap_flg and o.order_status = 4 and
                 round(extract(epoch from o.msk_arrival_to_customer_fact_dttm - o.msk_call_center_confirmed_dttm) / 60)
                     - o.time_to_delivery_max > 10 then 1
            when not o.order_asap_flg and o.order_status = 4 and
                 round(extract(epoch from o.msk_arrival_to_customer_fact_dttm - o.msk_delivery_dttm)) > 600 then 1
            else 0
            end                                                                                          as is_delay,
       case when o.order_status = 4 and o.order_asap_flg then
                 round(extract(epoch from o.msk_arrival_to_customer_fact_dttm - o.msk_call_center_confirmed_dttm) / 60)
            end                                                                                          as "CTE",
       round(extract(epoch from o.msk_arrival_to_customer_fact_dttm - o.msk_order_taken_fact_dttm) / 60) as from_rest_time,
       round(extract(epoch from o.msk_order_taken_fact_dttm - o.msk_arrival_to_place_fact_dttm) / 60)    as inrest_time,
       round(extract(epoch from o.msk_arrival_to_place_fact_dttm - o.msk_courier_assigned_dttm) / 60)    as torest_time,
       case when o.order_asap_flg then
                 round(extract(epoch from o.msk_arrival_to_place_fact_dttm - o.msk_call_center_confirmed_dttm) / 60)
            end                                                                                          as assigned_time,
       case when o.place_name = 'Яндекс.Лавка' then 1 else 0 end                                         as is_lavka,
       o.distance_to_customer                                                                            as distance_to_customer,
       o.msk_courier_assigned_dttm                                                                       as courier_assigned_at,
       o.msk_call_center_confirmed_dttm                                                                  as call_center_confirmed_at,
       o.msk_place_confirmed_dttm                                                                        as place_confirmed_at,
       o.msk_arrival_to_place_fact_dttm                                                                  as actual_arrived_to_place,
       o.msk_order_taken_fact_dttm                                                                       as actual_order_taken,
       o.msk_arrival_to_customer_fact_dttm                                                               as actual_arrived_to_customer,
       o.courier_id                                                                                      as courier_id,
       case when o.order_asap_flg then
            extract(epoch from (o.msk_call_center_confirmed_dttm)) + (o.pre_delivery_time - o.time_to_delivery) * 60
        end                                                                                              as forecast_place_ready_to_delivery_at,
       o.msk_cancelled_dttm                                                                              as cancelled_at,
       case when o.order_asap_flg then
            round((extract(epoch from o.msk_call_center_confirmed_dttm) + (o.pre_delivery_time - o.time_to_delivery) * 60
                       - extract(epoch from o.msk_call_center_confirmed_dttm)) / 60) end                 as forecasted_cooking_time,
       round((extract(epoch from o.msk_cancelled_dttm)
                 - case when o.order_asap_flg then
                        extract(epoch from (o.msk_call_center_confirmed_dttm)) + (o.pre_delivery_time - o.time_to_delivery) * 60
                   end) / 60)                                                                            as time_between_cancel_and_forecast_place_ready,
       o.surged_order_flg::integer                                                                       as is_surged,
       o.confirmed_flg::integer                                                                          as flag_accept_rev,
       case when o.taxi_dispatch_final_order_w_vat_cost_lcy is null then 0 else 1 end                    as paid_to_taxi,
       case when o.order_status = 4
                 then 'Delivered'
            when o.taxi_dispatch_reason_code is null then 'Cancelled due to false ML response'
            when o.msk_courier_assigned_dttm is null
                 then 'Courier is not assigned'
            when o.msk_place_confirmed_dttm is null and o.msk_cancelled_dttm >= o.msk_courier_assigned_dttm
                 then 'Courier is assigned, place did not confirm'
            when o.msk_arrival_to_place_fact_dttm is null and o.msk_cancelled_dttm >= o.msk_place_confirmed_dttm
                 then 'Place confirmed, courier did not arrive to place'
            when o.msk_order_taken_fact_dttm is null and o.msk_cancelled_dttm >= o.msk_arrival_to_place_fact_dttm
                 then 'Courier arrived to place, courier did not take order'
            when o.msk_arrival_to_customer_fact_dttm is null and o.msk_cancelled_dttm >= o.msk_order_taken_fact_dttm
                 then 'Courier took order, courier did not arrive to customer'
            when o.msk_cancelled_dttm >= o.msk_arrival_to_customer_fact_dttm
                 then 'After courier arrived to customer'
            end                                                                                          as "Cancelled_at_which_moment",
       o.order_place_cost_lcy * o.currency_rate                                                          as gmv,
       o.payment_type                                                                                    as payment_method_correct,
       coalesce(o.fact_place_commission_value_lcy * o.currency_rate, 0)                                  as commission_correct,
       case when o.order_delivery_type = 'native'
                     and o.delivery_fee_w_vat_lcy > 0
                     and (o.incentive_rejected_order_lcy = 0 or o.incentive_rejected_order_lcy is null)
                 then o.delivery_fee_w_vat_lcy * o.currency_rate
            else 0 end                                                                                   as delivery_fee,
       case when o.payment_type = 'card' and o.currency_code = 'KZT' then 0.024
            when o.payment_type = 'card' and o.currency_code = 'RUB' and
                  coalesce(o.msk_place_confirmed_dttm, o.msk_created_dttm) < '2020-04-15' then 0.0155
            when o.payment_type = 'card' and o.currency_code = 'RUB' and
                  coalesce(o.msk_place_confirmed_dttm, o.msk_created_dttm) >= '2020-04-15' then 0.01
            else 0 end * o.user_cost_w_vat_lcy * o.currency_rate                                         as acquiring_fee_total,
       o.promocode_type                                                                                  as promocode_type,
       o.promocode_value_lcy                                                                             as promocode_value,
       case when o.incentive_rejected_order_lcy > 0
                   then o.incentive_rejected_order_lcy * o.currency_rate
                            - coalesce(o.delivery_cost_w_vat_lcy, 0) * o.currency_rate
            else 0
            end                                                                                          as rejected_orders,
       coalesce(incentive_refunds_lcy * currency_rate, 0)                                                as refunds,
       taxi_dispatch_final_order_wo_vat_cost_lcy                                                         as cpo,

       coalesce(o.taxi_dispatch_reason_code, 'no_request')                                               as taxi_dispatch_reason,
       o.taxi_dispatch_cargo_uuid_id                                                                     as cargo_uuid_id,
       o.taxi_dispatch_attempt_cnt                                                                       as request_attempts,
       round((extract(epoch from o.local_created_dttm) - extract(epoch from o.msk_created_dttm)) / 3600)::integer
                                                                                                         as delta
  from eda_cdm_marketplace.dm_order as o
  left join eda_ods_bigfood.courier as c on o.courier_id = c.id
 where 1 = 1
   and o.msk_created_dttm > current_date - interval '120 day'
   and (order_status = 4 or order_status = 5)
   and o.order_delivery_type = 'native'
   and ((o.taxi_dispatch_reason_code is not null and o.taxi_dispatch_reason_code != 'redirected_by_supply')
            or o.place_delivery_zone_courier_type_code = 'yandex_taxi'
            or (o.taxi_dispatch_reason_code = 'redirected_by_supply'
                    and (c.source = 'virtual' or o.courier_id is null)))