-- HIERARCHY FOR RUSSIA: FEDERAL DISTRICT > AGGLOMERATION > TARIFF ZONE. Special Conditions for MSC, SPB
drop table if exists ru_region_geo;
create temp table ru_region_geo as
select geo.tariff_zone as tariff_zone,
       geo.name_en as region
from core_cdm_geo.v_dim_full_geo_hierarchy as geo
where 1=1
    and geo.tag_list = '{federal district}';

drop table if exists full_geo_w_ru_region;
create temp table full_geo_w_ru_region as
select h.tariff_zone as tariff_zone,
       h.name_ru as tz_aggl_name_ru,
       h.tz_country_name_ru as tz_country_name_ru,
       coalesce(r.region, h.tz_country_name_en) as region_name_en
from core_cdm_geo.v_dim_full_geo_hierarchy h
         left join ru_region_geo r
                   on r.tariff_zone = h.tariff_zone
where h.node_type = 'agglomeration'
  and h.root_node_id = 'br_root';

DROP TABLE IF EXISTS cancels_extra_statuses_tmp;
CREATE TEMP TABLE cancels_extra_statuses_tmp AS
    SELECT utc_claim_created_dttm::date as dt

     , claim_id
     , claim_uuid
     --, claim_external_order_id
     , order_id

     , COALESCE(name_pretty, 'C2C_claim') as name_pretty
     , COALESCE(corp_client_id, 'C2C_claim') as corp_client_id

     , source_address
     , source_location_lat
     , source_location_lon
     , destination_address
     , destination_lat
     , destination_lon
     --, source_location_point_geohash
     --, point_id
     --, brand_name

     , g.tz_country_name_ru as country_name_ru
     , g.region_name_en as region
     , g.tz_aggl_name_ru as city_name_ru
     , claim_tariff_zone_code

--     , taxi_user_fraud_flg
     , COALESCE(taxi_tariff_class_code, array_to_string(available_tariff_class_code_list, ', ')) as tariff_class_code

     , utc_claim_created_dttm
--      , utc_claim_new_dttm
     , utc_claim_created_status_dttm as utc_claim_accepted_dttm
--      , utc_claim_failed_dttm
--      , utc_claim_performer_lookup_dttm
--      , utc_claim_performer_draft_dttm
     , utc_claim_performer_found_dttm
--      , utc_claim_delivered_finish_dttm
--      , utc_claim_returned_finish_dttm
--      , utc_claim_cancelled_dttm
--      , utc_claim_cancelled_with_payment_dttm
--      , utc_claim_cancelled_with_items_on_hands_dttm
--      , utc_claim_cancelled_by_taxi_dttm
--      , utc_claim_performer_not_found_dttm
     , utc_claim_pickup_arrived_dttm
     , utc_claim_pickuped_dttm
     , utc_claim_delivery_arrived_dttm
     , utc_claim_delivered_dttm
     , utc_claim_returning_dttm
     , utc_claim_return_arrived_dttm
     , utc_claim_returned_dttm
     , utc_claim_due_dttm
     , CASE WHEN utc_claim_due_dttm is null then 'soon'
            WHEN EXTRACT(EPOCH FROM (utc_claim_due_dttm - utc_claim_created_status_dttm)) < 2100 THEN 'soon'
            ELSE 'due'
        END as due_soon

     , status_code
     , CASE status_code
                WHEN 'delivered_finish' THEN 'delivered'
                WHEN 'returned_finish' THEN 'returned'
                WHEN 'performer_not_found' THEN status_code
                -- TODO нет таймстемпа времени когда не найден исполнитель нужны интервалы, жду DWH
                WHEN 'failed' THEN status_code
        --             CASE WHEN utc_claim_performer_found_dttm is null and utc_claim_pickup_arrived_dttm is null THEN 'failed_before_assignment'
        --                  WHEN utc_claim_performer_found_dttm is not null THEN 'failed_after_assignment'
        --                  ELSE 'failed_CHECK'
        --             END
                WHEN 'cancelled_with_items_on_hands' THEN concat('client_', status_code)--, '_on_point_B')
        --             CASE WHEN utc_claim_delivery_arrived_dttm is not null then concat(status_code, '_on_point_B')
        --                  ELSE concat(status_code, '_during_delivery')
        --             END
                WHEN 'cancelled' THEN
                    CASE WHEN utc_claim_performer_found_dttm is null and utc_claim_pickup_arrived_dttm is null THEN
                                CASE --WHEN EXTRACT(EPOCH FROM (COALESCE(claim_cancelled_utc_dttm, claim_cancelled_with_payment_utc_dttm) - claim_accepted_utc_dttm)) < 60 THEN concat(status_code, '_during_performer_search_0-1min')
                                     --WHEN EXTRACT(EPOCH FROM (claim_cancelled_utc_dttm - claim_accepted_utc_dttm)) < 120 THEN concat(status_code, '_during_performer_search_0-2min')
                                     WHEN EXTRACT(EPOCH FROM (utc_claim_finish_dttm - utc_claim_created_status_dttm)) < 300 THEN concat('client_', status_code, '_after_creation_0-5min')
                                     --WHEN EXTRACT(EPOCH FROM (claim_cancelled_utc_dttm - claim_accepted_utc_dttm))< 600 THEN concat(status_code, '_during_performer_search_5-10min')
                                     WHEN EXTRACT(EPOCH FROM (utc_claim_finish_dttm - utc_claim_created_status_dttm)) < 900 THEN concat('client_', status_code, '_after_creation_5-15min')
                                     WHEN EXTRACT(EPOCH FROM (utc_claim_finish_dttm - utc_claim_created_status_dttm)) < 1800 THEN concat('client_', status_code, '_after_creation_15-30min')
                                     ELSE concat('client_', status_code, '_after_creation_30+min')
                                END
                         WHEN utc_claim_performer_found_dttm is not null and utc_claim_pickup_arrived_dttm is null and utc_claim_pickuped_dttm is null THEN
                             CASE WHEN EXTRACT(EPOCH FROM (utc_claim_finish_dttm - utc_claim_performer_found_dttm)) < 600 THEN concat('client_', status_code, '_0-5min_after_assignment')
                                  WHEN EXTRACT(EPOCH FROM (utc_claim_finish_dttm - utc_claim_performer_found_dttm)) < 900 THEN concat('client_', status_code, '_5-15min_after_assignment')
                             ELSE concat('client_', status_code, '_15+min_after_assignment')
                             END
                         WHEN utc_claim_performer_found_dttm is not null and utc_claim_pickup_arrived_dttm is not null and utc_claim_pickuped_dttm is null THEN
                                CASE WHEN EXTRACT(EPOCH FROM (utc_claim_finish_dttm - utc_claim_pickup_arrived_dttm)) < 600 THEN concat('client_', status_code, '_on_point_A_0-10min')
                                     WHEN EXTRACT(EPOCH FROM (utc_claim_finish_dttm - utc_claim_pickup_arrived_dttm)) < 1800 THEN concat('client_', status_code, '_on_point_A_10-30min')
                                     ELSE concat('client_', status_code, '_on_point_A_30+min')
                                END
                         WHEN utc_claim_performer_found_dttm is not null and utc_claim_pickup_arrived_dttm is not null and utc_claim_pickuped_dttm is not null and utc_claim_delivery_arrived_dttm is null and utc_claim_delivered_dttm is null THEN concat('client_', status_code, '_during_delivery')
                         WHEN utc_claim_performer_found_dttm is not null and utc_claim_pickup_arrived_dttm is not null and utc_claim_pickuped_dttm is not null and utc_claim_delivery_arrived_dttm is not null and utc_claim_delivered_dttm is null THEN concat('client_', status_code, '_on_point_B')
                         ELSE concat('client_', status_code, '_CHECK')
                    END
                WHEN 'cancelled_with_payment'  THEN concat('client_', status_code)
        --             CASE WHEN utc_claim_performer_found_dttm is null and utc_claim_pickup_arrived_dttm is null THEN concat(status_code, '_during_performer_search')
        --                  WHEN utc_claim_performer_found_dttm is not null and utc_claim_pickup_arrived_dttm is null and utc_claim_pickuped_dttm is null and utc_claim_delivery_arrived_dttm is null THEN concat(status_code, '_before_point_A')
        --                  WHEN utc_claim_performer_found_dttm is not null and utc_claim_pickup_arrived_dttm is not null and utc_claim_pickuped_dttm is null THEN concat(status_code, '_on_point_A')
        --                  WHEN utc_claim_performer_found_dttm is not null and utc_claim_pickup_arrived_dttm is not null and utc_claim_pickuped_dttm is not null and utc_claim_delivery_arrived_dttm is null and utc_claim_delivered_dttm is null THEN concat(status_code, '_during_delivery')
        --                  WHEN utc_claim_performer_found_dttm is not null and utc_claim_pickup_arrived_dttm is not null and utc_claim_pickuped_dttm is not null and utc_claim_delivery_arrived_dttm is not null and utc_claim_delivered_dttm is null and utc_claim_delivered_finish_dttm is null THEN concat(status_code, '_on_point_B')
        --                  ELSE concat(status_code, '_CHECK')
        --             END
                WHEN 'cancelled_by_taxi' THEN
                    CASE WHEN utc_claim_performer_found_dttm is null and utc_claim_pickup_arrived_dttm is null then concat('performer_cancelled', '_CHECK')
                         WHEN utc_claim_performer_found_dttm is null and utc_claim_pickup_arrived_dttm is not null THEN concat('performer_cancelled', 'holy_sht')
                         WHEN utc_claim_performer_found_dttm is not null and utc_claim_pickup_arrived_dttm is null and utc_claim_pickuped_dttm is null THEN
                             CASE WHEN EXTRACT(EPOCH FROM (utc_claim_finish_dttm - utc_claim_performer_found_dttm)) < 600 THEN concat('performer_cancelled', '_0-5min_after_assignment')
                                  WHEN EXTRACT(EPOCH FROM (utc_claim_finish_dttm - utc_claim_performer_found_dttm)) < 900 THEN concat('performer_cancelled', '_5-15min_after_assignment')
                             ELSE concat('performer_cancelled', '_15+min_after_assignment')
                             END
                         WHEN utc_claim_performer_found_dttm is not null and utc_claim_pickup_arrived_dttm is not null and utc_claim_pickuped_dttm is null THEN --and utc_claim_delivery_arrived_dttm is null  THEN
                                CASE WHEN EXTRACT(EPOCH FROM (utc_claim_finish_dttm - utc_claim_pickup_arrived_dttm)) < 600 THEN concat('performer_cancelled', '_on_point_A_0-10min')
                                     WHEN EXTRACT(EPOCH FROM (utc_claim_finish_dttm - utc_claim_pickup_arrived_dttm)) < 1800 THEN concat('performer_cancelled', '_on_point_A_10-30min')
                                     ELSE concat('performer_cancelled', '_on_point_A_30+min')
                                END
                        ELSE concat('performer_cancelled', '_after_point_A')
        --                 WHEN utc_claim_performer_found_dttm is not null and utc_claim_pickup_arrived_dttm is not null and utc_claim_pickuped_dttm is not null and utc_claim_delivery_arrived_dttm is null and utc_claim_delivered_dttm is null THEN concat(status_code, '_during_delivery')
        --                  --WHEN utc_claim_performer_found_dttm is not null and utc_claim_pickup_arrived_dttm is not null and utc_claim_pickuped_dttm is not null and utc_claim_delivery_arrived_dttm is not null and utc_claim_delivered_dttm is null THEN concat(status_code, '_on_point_B')
        --                  ELSE concat(status_code, '_CHECK')
                    END
                ELSE concat('XX_',status_code)
         END as status_extra
     , utc_claim_finish_dttm as utc_final_status_dttm

from taxi_cdm_logistic.fct_delivery as d
left join snb_delivery.logvinenko_delivery_client as c
on d.corp_client_id = c.id
left join full_geo_w_ru_region as g on d.claim_tariff_zone_code=g.tariff_zone
where
            1=1
--            (group_source_company != 'eda' or group_source_company is null)
            and (((available_tariff_class_code_list  COLLATE "C") not in ('{lavka}', '{eda}')) or available_tariff_class_code_list is null)
            and courier_type not in ('eda', 'lavka')
            and claim_id is not null
            --and corp_client_id is not null
            and status_code is not null
            and utc_claim_created_status_dttm is not null
            and utc_claim_created_dttm::date >= (current_date - interval '5 month');
-- DISTRIBUTED by (claim_id);
-- ANALYZE cancels_extra_statuses_tmp;


--- cancels draft tbl
drop table if exists snb_delivery.logvinenko_cancels;
create table snb_delivery.logvinenko_cancels as
select dt
     --, claim_id
     , name_pretty
     , corp_client_id
     , min(source_address) as source_address
     , source_location_lat as source_location_lat
     , source_location_lon as source_location_lon
     --, source_location_point_geohash
     , status_code
     --, point_id
     --, brand_name
     , tariff_class_code
     , country_name_ru
     , region
     , city_name_ru
     , claim_tariff_zone_code
--     , taxi_user_fraud_flg
     , status_extra
     , due_soon
     , count(distinct claim_id) as claims
from cancels_extra_statuses_tmp

group by dt
     --, claim_id
     , name_pretty
     , corp_client_id
--     , source_address
     , source_location_lat
     , source_location_lon
     --, source_location_point_geohash
     , status_code
     , status_extra
     --, point_id
     --, brand_name
     , tariff_class_code
     , country_name_ru
     , region
     , city_name_ru
     , claim_tariff_zone_code
     , due_soon;
--     , taxi_user_fraud_flg;

GRANT SELECT ON snb_delivery.logvinenko_cancels TO public;

--- cancels source data
drop table if exists snb_delivery.logvinenko_cancels_raw;
create table snb_delivery.logvinenko_cancels_raw as
select * from cancels_extra_statuses_tmp
where dt >= (current_date - interval '13 days');
GRANT SELECT ON snb_delivery.logvinenko_cancels_raw TO public;
