import tvmauth
import os
import json
import httplib2
from business_models.databases.gdocs import GoogleDocs

LOGDATA_SRC_TVM_ID = 2027260
LOGDATA_PROXY_USER = 'logdata'


def build_tvm_client(dsts, self_tvm_id=LOGDATA_SRC_TVM_ID):
    return tvmauth.TvmClient(
        tvmauth.TvmApiClientSettings(
            self_tvm_id=self_tvm_id,
            enable_service_ticket_checking=True,
            enable_user_ticket_checking=tvmauth.BlackboxEnv.Test,
            self_secret=os.environ['TVM_SECRET'],
            dsts=dsts,
        ),
    )


def build_tvm_client_for_zora(self_tvm_id=LOGDATA_SRC_TVM_ID):
    return build_tvm_client({'gozora': 2023123}, self_tvm_id)


def build_gdocs(self_tvm_id=LOGDATA_SRC_TVM_ID, proxy_user=LOGDATA_PROXY_USER):
    """
    Возвращает GoogleDocs объект, совместимый с текущим окружением (используется прокси, если процесс запущен в нирване)
    """
    if os.environ.get('NV_YT_OPERATION_ID'): # python запущен в нирване, нужен прокси
        tvm_client = build_tvm_client_for_zora(self_tvm_id)
        tvm_ticket = tvm_client.get_service_ticket_for('gozora')

        http = httplib2.Http(
            proxy_info=httplib2.ProxyInfo(
                httplib2.socks.PROXY_TYPE_HTTP,
                'go.zora.yandex.net',
                1080,
                proxy_user=proxy_user,
                proxy_pass=tvm_ticket,
            ),
            disable_ssl_certificate_validation=True,
        )

    else:
        http = None

    return GoogleDocs(http=http)


def read_script_config():
    with open(os.path.expanduser(os.environ['LOGDATA_LAUNCHER_SCRIPT_CONFIG'])) as f:
        return f.read()


def read_script_config_json():
    with open(os.path.expanduser(os.environ['LOGDATA_LAUNCHER_SCRIPT_CONFIG'])) as f:
        return json.load(f)
