import argparse
import calendar
import datetime

from nile.api.v1 import clusters
from nile.api.v1 import extractors as ne
from qb2.api.v1 import extractors as qe

from projects.efficiency_metrics.project_config import get_project_cluster


def get_num_of_days_in_month(year, month):
    return calendar.monthrange(year, month)[1]


if __name__ == '__main__':
    parser = argparse.ArgumentParser()

    parser.add_argument('--yt-proxy', type=str, required=False, default='hahn')
    parser.add_argument('--date-str', type=str, required=True)
    parser.add_argument('--from-path', type=str, required=True)
    parser.add_argument('--to-path', type=str, required=True)

    args = parser.parse_args()

    date_str = args.date_str
    from_path = args.from_path
    to_path = args.to_path

    cluster = get_project_cluster()

    # parsing arguments
    date = datetime.datetime.strptime(date_str, '%Y-%m-%d')
    date = date.replace(day=1)
    print(date)

    num_of_days_in_month = get_num_of_days_in_month(date.year, date.month)
    print (num_of_days_in_month)

    dates_range = [
        (date + datetime.timedelta(days=i)
         ).strftime('%Y-%m-%d') for i in range(num_of_days_in_month)]
    print (dates_range)

    cur_month_str = date.strftime('%Y-%m')
    print (cur_month_str)

    root_path = from_path.format('')[:-1]
    print (root_path)

    # starting job
    job = cluster.job('asd')
    job = job.env(
        bytes_decode_mode='strict',
        yt_spec_defaults={'max_failed_job_count': 1000}
    )

    init_table = []

    for date in dates_range:
        print(date)
        if not cluster.driver.exists(from_path.format(date)):
            continue

        tmp = job.table(from_path.format(date)).project(
            ne.all(),
            qe.table_path('calc_date')
        ).project(
            ne.all(),
            calc_date=ne.custom(lambda x: x.split('/')[-1], 'calc_date')
        )

        init_table.append(tmp)

    job.concat(
        *init_table
    ).sort(
        'calc_date'
    ).put(
        to_path.format(cur_month_str),
        merge_strategy='always'
    )

    job.run()