
import datetime

from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from nile.api.v1 import Record
from qb2.api.v1 import filters as qf

from projects.common.decorators import cached_method
from projects.common.nile import filters as pf
from projects.common.nile.dates import range_selector
from projects.common.time_utils import datetime_2_timestamp, parse_timestring
from . import paths


class DataContext:
    def __init__(
            self,
            job,
            begin_dttm: datetime.datetime,
            end_dttm: datetime.datetime,
            sources=None,
    ):
        sources = sources or ['eda_orders']

        self._cache = dict()
        self._job = job
        self.begin_dttm = begin_dttm
        self.end_dttm = end_dttm

        self._sources = sources
        self._source_logs_map = {
            'eda_orders': self.get_eda_orders
        }

        self.time_filter = lambda ts_field: pf.dttm_between(
            begin_dttm, end_dttm, ts_field,
        )

    def get_job(self):
        return self._job


    @cached_method
    def get_sources_logs(self, sources=None):
        sources = sources or self._sources
        sources_logs = [
            self._source_logs_map.get(sources)() for sources in sources
        ]
        return self._job.concat(*sources_logs)

    @cached_method
    def get_eda_orders(self):
        return (
            self._job.table(
                paths.EDA_ORDERS.format(
                    range_selector(self.begin_dttm, self.end_dttm, '%Y-%m')
                )
            ).project(
                ne.all()
                # 'candidates_meta',
                # 'created',
                # 'order_id',
                # 'winner_applied',
                # 'winner_id',
                # 'geo_point',
                # timestamp=ne.custom(lambda x: int(x), '_logfeller_timestamp')
            )
            .filter(
                pf.dttm_between(self.begin_dttm, self.end_dttm, 'utc_created_dttm')
            )
            .project(
                ne.all(),
                source=ne.const('eda_orders')
            )
        )