-- HIERARCHY FOR RUSSIA: FEDERAL DISTRICT > AGGLOMERATION > TARIFF ZONE. Special Conditions for MSC, SPB
drop table if exists russia_geo_hierarchy;
create temp table russia_geo_hierarchy as
select geo.tariff_zone, geo.tz_aggl_name_en, coalesce(coalesce(mow.name_en, case when spb.region = 'SPb and SPb region' then 'SPb region' else spb.region end), geo.name_en) as region
from core_cdm_geo.v_dim_full_geo_hierarchy as geo
         left join (select distinct tariff_zone, name_en
                    from core_cdm_geo.v_dim_full_geo_hierarchy
                    where name_en in ('Moscow (Middle Region)',
                                      'Moscow (Near Region)',
                                      'Moscow (adm)',
                                      'Far Moscow Region')) as mow
                   on geo.tariff_zone = mow.tariff_zone
         left join (select min(name_en) as region,
                tariff_zone
                    from core_cdm_geo.v_dim_full_geo_hierarchy
                    where name_en in ('SPb and SPb region', 'Saint-Petersburg (adm)')
group by tariff_zone) as spb
                   on geo.tariff_zone = spb.tariff_zone
where geo.tag_list = '{federal district}'
;

-- FULL HIERARCHY WITH RUSSIAN REGIONS
drop table if exists regions_geo_hierarchy;
create temp table regions_geo_hierarchy as
select h.tariff_zone, h.name_en as tz_aggl_name_en, h.tz_country_name_en, coalesce(region, h.tz_country_name_en) as region_name_en, total_population, population_group
from core_cdm_geo.v_dim_full_geo_hierarchy h
         left join russia_geo_hierarchy r
                   on r.tariff_zone = h.tariff_zone
where h.node_type = 'agglomeration'
  and h.root_node_id = 'br_root'
;

-- GEOBOOKING: AMOUNTS FROM FCT_ORDER_SUBSIDY USING A LIST OF RULES IN DELIVERY TARIFFS FROM SUBVENTION_RULES
drop table if exists geo_booking_by_rules;
create temp table geo_booking_by_rules as
select ((s.utc_event_dttm at time zone 'utc') at time zone geo.time_zone_code)::date as lcl_event_dt,
       s.tariff_geo_zone_code                                                       as tariff_geo_zone_code,
       sum(coalesce(subsidy_value, 0.0) * r.rate)                                   as subsidy_booking_geo_guarantee
from taxi_cdm_finance.fct_order_subsidy as s
         inner join dds.dim_currency_rate as r
                    on s.utc_transaction_dttm::date = r.date
                        and s.currency_code = r.source_cur
         inner join core_cdm_geo.v_dim_full_geo_hierarchy as geo
                    on s.tariff_geo_zone_code = geo.tariff_zone
--          inner join core_cdm_geo.dim_geo_node as tz
--                     on geo.agglomeration_node_id = tz.agglomeration_node_id
where 1 = 1
  and utc_transaction_dttm >= '2021-01-01'
  and geo.node_type = 'agglomeration'
  and geo.root_node_id = 'br_root'
  and billing_type = 'expenses'
  and subvention_rule_id
    in (select distinct id
        from ritchie.taxi_ods_mdb.subvention_rule
        where classes && '{"courier", "express","cargo","cargocorp", "night", "ubernight"}'
            and kind = 'geo_booking'
            and end_dttm >= (current_date - interval '7 month')
           or end_dttm is null)
  and r.target_cur = 'RUB'
  and detailed_product_name = 'subsidy_booking_geo_guarantee'
--   and tz.node_type = 'agglomeration'
--   and tz.root_node_id = 'br_root'
group by lcl_event_dt,
         tariff_geo_zone_code
;

-- AMOUNTS FROM FCT_ORDER_METRIC
drop table if exists raw_fct_order_m;
create temp table raw_fct_order_m as
select
--     utc_order_created_dt,
--     utc_order_created_dttm,
--     taximeter_park_id|| '_' || executor_profile_id as dbid_uuid,
--     unique_driver_id,
    lcl_order_created_dttm,
    lcl_order_created_dt,
    order_id,
    success_order_flg,
    expired_order_flg,
    tariff_class_code,
    tariff_geo_zone_code,
    order_before_surge_cost * currency_rate * success_order_flg::int as order_before_surge_cost,
    gmv_amt * currency_rate as gmv,
    driver_incentives_amt * currency_rate * success_order_flg::int as subsidy,
    (rider_incentives_amt + fee_branding_chargeback_amt) * currency_rate * success_order_flg::int as discount,
    gross_commission_revenue_amt * currency_rate as comission,
    b2b_decoupling_amt * currency_rate * success_order_flg::int as decoupling,
--     success_order_flg::int *
--             ( coalesce(order_commission_w_discount_wo_vat_value, 0)
--             + coalesce(order_commission_discount_wo_vat_value, 0)
--             + coalesce(shift_commission_wo_vat_value, 0)
--             + coalesce(acquiring_commission_value, 0)
--             + coalesce(agency_commission_wo_vat_value, 0)
--             + coalesce(call_center_commission_wo_vat_value, 0)
--             + coalesce(hiring_commission_wo_vat_value, 0)
--             + coalesce(hiring_shift_commission_wo_vat_value, 0)
--             + coalesce(childchair_rent_wo_vat_value,0)
--             + coalesce(driver_fix_comission_wo_vat_amt,0)
--             + coalesce(driver_fix_comission_for_fraud_wo_vat_amt,0)
--             + coalesce(rebate_w_vat_value,0)
--             + coalesce(voucher_commission_wo_vat_value,0))
--             * currency_rate as comission_check,
--     success_order_flg:: int * (discount_compensation_value
--                                 + promocode_compensation_value
--                                 + holded_discount_value
--                                 + dmd_value
--                                 + holded_dmd_value)
--                                 * currency_rate  as discount_check,
--     success_order_flg::int *
--                                 (subsidy_value
--                                 + holded_subsidy_value
--                                 + dms_value
--                                 + holded_dms_value
--                                 + subsidy_commission_discount_value
--                                 - subsidy_commission_value)
--                                 * currency_rate  as subsidy_check,
--     net_inflow_amt as net_inflow_check,
--     order_cost * currency_rate * success_order_flg::int as gmv_check,
--     decoupling_success_flg::int * success_order_flg::int *
--                             ( coalesce(decoupling_user_cost, 0)
--                             - coalesce(decoupling_driver_cost, 0))
--                             * currency_rate as decoupling_check,
    balance_rate as surge_k,
    delivery_point_cnt,
    case when balance_rate > 1.0 and success_order_flg then true else false end as trip_w_surge_flg
from  taxi_cdm_marketplace.fct_order_metric as fct
where 1=1
and tariff_class_code  in ('cargo', 'cargocorp', 'courier', 'express', 'night', 'ubernight')
and not mqc_order_flg
and lcl_order_created_dt>= (current_date - interval '7 month')
distributed by (order_id);
analyze raw_fct_order_m
;


-- SEEN AND ASSIGNED PERFORMERS FROM FCT_ORDER_CANDIDATE
drop table if exists order_assignments;
create temp table order_assignments as
select
        order_id,
        count(utc_seen_dttm) as cnt_seen,
        count(utc_assigned_dttm) as cnt_assigned
from taxi_cdm_supply.fct_order_candidate as a
where utc_candidate_created_dttm>= (current_date - interval '7 month')
group by order_id
distributed by (order_id);
analyze order_assignments
;

-- ORDERS & DELIVERIES FROM FCT_DELIVERY
drop table if exists n_claims;
create temp table n_claims as
select
    --utc_claim_created_dttm::date as dt,
    ((f.utc_claim_created_dttm at time zone 'utc') at time zone geo.time_zone_code)::date               as lcl_dt,
    claim_tariff_zone_code                                                                             as tariff_zone_code,
    taxi_tariff_class_code                                                                             as tariff,
    count(distinct case when status_code in ('delivered_finish', 'returned_finish') and taxi_tariff_class_code is not null then claim_id end) as n_success,
    count(distinct case when status_code ='performer_not_found' then claim_id end) as n_performer_not_found,
    count(distinct claim_id) - count(distinct case when status_code in ('delivered_finish', 'returned_finish') and taxi_tariff_class_code is null then claim_id end)                                                                           as n_all
from taxi_cdm_logistic.fct_delivery as f
         inner join core_cdm_geo.v_dim_full_geo_hierarchy as geo
                    on f.claim_tariff_zone_code = geo.tariff_zone
--          inner join core_cdm_geo.dim_geo_node as tz
--                     on geo.agglomeration_node_id = tz.agglomeration_node_id
where utc_claim_created_dttm >= (current_date - interval '7 month')
  and claim_id is not null
  and utc_claim_created_status_dttm is not null
  and available_tariff_class_code_list <> '{eda}'
  and available_tariff_class_code_list <> '{lavka}'
  and geo.node_type = 'agglomeration'
  and geo.root_node_id = 'br_root'
--   and tz.node_type = 'agglomeration'
--   and tz.root_node_id = 'br_root'
group by lcl_dt,
         --dt,
         tariff_zone_code, tariff;



drop table if exists n_orders;
create temp table n_orders as
select --utc_order_created_dttm::date as dt,
       ((f.utc_order_created_dttm at time zone 'utc') at time zone geo.time_zone_code)::date as lcl_dt,
       taxi_tariff_geo_zone_code                                                            as tariff_zone_code,
       taxi_tariff_class_code                                                               as tariff,
       count(expired_order_flg or null)                                                     as n_performer_not_found,
       count(distinct case when taxi_success_order_flg then f.order_id end)                   as n_success,
       count(distinct f.order_id)                                                             as n_all
from taxi_cdm_logistic.fct_delivery as f
         inner join core_cdm_geo.v_dim_full_geo_hierarchy as geo
                    on f.taxi_tariff_geo_zone_code = geo.tariff_zone
--          inner join core_cdm_geo.dim_geo_node as tz
--                     on geo.agglomeration_node_id = tz.agglomeration_node_id
        inner join taxi_cdm_marketplace.fct_order as fo
                    on fo.order_id=f.order_id
where f.utc_order_created_dttm >= (current_date - interval '7 month')
  and fo.utc_order_created_dt >= (current_date - interval '7 month')
  and fo.tariff_class_code in ('courier', 'express','cargo','cargocorp', 'night', 'ubernight')
  and f.order_id is not null
  and claim_id is null
  and geo.node_type = 'agglomeration'
  and geo.root_node_id = 'br_root'
--   and tz.node_type = 'agglomeration'
--   and tz.root_node_id = 'br_root'
group by lcl_dt,
         tariff_zone_code,
         tariff;

-- UNION ORDERS & CLAIMS
drop table if exists n_all_orders;
create temp table n_all_orders as
select lcl_dt, tariff_zone_code, tariff, sum(n_all) as n_all, sum(n_success) as n_success, sum(n_performer_not_found) as n_not_found
from (
         (select lcl_dt,
         tariff_zone_code,
         coalesce(tariff, 'unknown') as tariff,
         n_performer_not_found,
         n_success,
         n_all
         from n_claims as с)
         union all
         (select lcl_dt,
         tariff_zone_code,
         tariff,
         n_performer_not_found,
         n_success,
         n_all
         from n_orders as o)
     ) as n_all
group by lcl_dt, tariff_zone_code, tariff;

-- ADDING SEEN & ASSIGNMENTS TO ECONOMICS
drop table if exists economics_no_geo_booking;
create temp table economics_no_geo_booking as
select
    fct.lcl_order_created_dt,
    fct.tariff_geo_zone_code,
    fct.tariff_class_code,
    count(fct.order_id) as orders,
--     count(distinct fct.unique_driver_id) as drivers,
    count(success_order_flg or null) as n_success,
    count(trip_w_surge_flg or null) as trips_w_surge,
    count(fct.order_id) as n_order,
    count(expired_order_flg or null) as n_expired,
    sum(gmv) as gmv,
    sum(subsidy) as subsidy,
    sum(discount) as discount,
    sum(comission) as comission,
    sum(decoupling) as decoupling,
    sum(order_before_surge_cost) as order_before_surge_cost,
--     sum(gmv_check) as gmv_check,
--     sum(subsidy_check) as subsidy_check,
--     sum(discount_check) as discount_check,
--     sum(comission_check) as comission_check,
--     sum(decoupling_check) as decoupling_check,
--     sum(comission_check) + sum(decoupling_check) - sum(discount_check) - sum(subsidy_check) as net_inflow_check0,
--     sum(net_inflow_check) as net_inflow_check,
    sum(delivery_point_cnt) as n_success_deliveries,
    sum(comission) + sum(decoupling) - sum(discount) - sum(subsidy) as net_inflow,
    sum(cnt_assigned) as cnt_assigned,
    sum(cnt_seen) as cnt_seen

from raw_fct_order_m as fct
join order_assignments as cand
on fct.order_id = cand.order_id

group by
    lcl_order_created_dt,
    tariff_geo_zone_code,
    tariff_class_code
;

-- EXTENDING TRANSFERRED SUPPLY TABLE WITH EXTRA COLUMNS
drop table if exists supply_for_economics_extended;
create temp table supply_for_economics_extended as
select lcl_order_created_dt::date
    , tariff_geo_zone_code
    , courier_type
    , walking_courier
    , auto_courier
    , free_sh_day
    , transporting_sh_day
    , driving_sh_day
    , waiting_sh_day
    , sh_day
    , split_part(population_group, '_',1) as country_code
    , split_part(population_group, '_',2) as population
    , case when total_population < 100000 then '100K-'
    when total_population < 300000 then '100k+'
    when total_population < 500000 then '300k+'
    when total_population < 1000000 then '500k+'
    else '1000k+' end as population_new
    , region_name_en
    , tz_country_name_en
    , tz_aggl_name_en
    , total_population
    , null::varchar as tariff_class_code
    , null::bigint as orders
--     , null as drivers
    , null::numeric as n_success_check
    , null::numeric as n_all_check
    , null::numeric as n_not_found
    , null::bigint as n_success
    , null::bigint as n_success_deliveries
    , null::bigint as trips_w_surge
    , null::bigint as n_order
    , null::bigint as n_expired
    , null::numeric as order_before_surge_cost
    , null::numeric as gmv
    , null::numeric as subsidy
    , null::numeric as discount
    , null::numeric as comission
    , null::numeric as decoupling
    , null::numeric as sub_geo_booking
    , null::numeric as cnt_seen
    , null::numeric as cnt_assigned
    , null::numeric as net_inflow
from snb_delivery.logvinenko_supply_for_economics
    as a
left join regions_geo_hierarchy as b
on a.tariff_geo_zone_code = b.tariff_zone
where lcl_order_created_dt is not null
and a.tariff_geo_zone_code in (select distinct tariff_geo_zone_code from economics_no_geo_booking);


-- ADDING GEOBOOKING TO ECONOMICS
drop table if exists economics_no_supply;
create temp table economics_no_supply as
select
    coalesce(ec.lcl_order_created_dt, o.lcl_dt) as lcl_order_created_dt,
    coalesce(ec.tariff_geo_zone_code, o.tariff_zone_code) as tariff_geo_zone_code,
    coalesce(ec.tariff_class_code, o.tariff) as tariff_class_code,
    orders,
--     drivers,
    o.n_success as n_success_check,
    o.n_all as n_all_check,
    ec.n_success,
    o.n_not_found as n_not_found,
    n_success_deliveries,
    trips_w_surge,
    n_order,
    n_expired,
    order_before_surge_cost,
    gmv,
    subsidy + case when tariff_class_code = 'courier' then  coalesce(gb.subsidy_booking_geo_guarantee, 0) else 0 end as subsidy,
    case when tariff_class_code = 'courier' then  coalesce(gb.subsidy_booking_geo_guarantee, 0) else 0 end as sub_geo_booking,
    discount,
    cnt_seen,
    cnt_assigned,
    comission,
    decoupling,
    net_inflow - case when tariff_class_code = 'courier' then  coalesce(gb.subsidy_booking_geo_guarantee, 0) else 0 end as net_inflow
    , split_part(population_group, '_',1) as country_code
    , split_part(population_group, '_',2) as population
    , case when total_population < 100000 then '100000-'
    when total_population < 300000 then '100000+'
    when total_population < 500000 then '300000+'
    when total_population < 1000000 then '500000+'
    else '1000000+' end as population_new
    , region_name_en
    , tz_country_name_en
    , tz_aggl_name_en
    , total_population
    , null::text as courier_type
    , null::boolean as walking_courier
    , null::boolean as auto_courier
    , null::double precision as free_sh_day
    , null::double precision as transporting_sh_day
    , null::double precision as driving_sh_day
    , null::double precision as waiting_sh_day
    , null::double precision as sh_day
from economics_no_geo_booking as ec
left join geo_booking_by_rules as gb
    on ec.tariff_geo_zone_code = gb.tariff_geo_zone_code
    and ec.lcl_order_created_dt = gb.lcl_event_dt
full join n_all_orders o on o.lcl_dt=ec.lcl_order_created_dt and o.tariff = ec.tariff_class_code and o.tariff_zone_code = ec.tariff_geo_zone_code
left join regions_geo_hierarchy as r
    on (ec.tariff_geo_zone_code = r.tariff_zone or o.tariff_zone_code = r.tariff_zone)
where lcl_order_created_dt is not null or lcl_dt is not null;


-- ADDING SUPPLY TO ECONOMICS
drop table if exists snb_delivery.logvinenko_economics_full;
create table snb_delivery.logvinenko_economics_full as
select lcl_order_created_dt
    , tariff_geo_zone_code
    , courier_type--::text
    , walking_courier--::boolean
    , auto_courier--::boolean
    , free_sh_day--::double precision
    , transporting_sh_day--::double precision
    , driving_sh_day--::double precision
    , waiting_sh_day--::double precision
    , sh_day--::double precision
    , country_code
    , population
    , population_new
    , region_name_en
    , tz_country_name_en
    , tz_aggl_name_en
    , total_population
    , tariff_class_code
    , orders
--     , null as drivers
    , n_success_check
    , n_all_check
    , n_success
    , n_not_found
    , n_success_deliveries
    , trips_w_surge
    , n_order
    , n_expired
    , order_before_surge_cost
    , gmv
    , subsidy
    , discount
    , comission
    , decoupling
    , sub_geo_booking
    , cnt_seen
    , cnt_assigned
    , net_inflow
    from economics_no_supply
union all
select lcl_order_created_dt
    , tariff_geo_zone_code
    , courier_type
    , walking_courier
    , auto_courier
    , free_sh_day
    , transporting_sh_day
    , driving_sh_day
    , waiting_sh_day
    , sh_day
    , country_code
    , population
    , population_new
    , region_name_en
    , tz_country_name_en
    , tz_aggl_name_en
    , total_population
        , tariff_class_code
    , orders
--     , null as drivers
    , n_success_check
    , n_all_check
    , n_success
    , n_not_found
    , n_success_deliveries
    , trips_w_surge
    , n_order
    , n_expired
    , order_before_surge_cost
    , gmv
    , subsidy
    , discount
    , comission
    , decoupling
    , sub_geo_booking
    , cnt_seen
    , cnt_assigned
    , net_inflow
from supply_for_economics_extended;
GRANT SELECT ON snb_delivery.logvinenko_economics_full TO public;
