import argparse
# import time

import datetime

from projects.efficiency_metrics.manager import Manager
from projects.efficiency_metrics.project_config import get_project_cluster


if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    parser.add_argument('--yt-path-to', required=True, type=str)
    parser.add_argument('--from-date-hour', required=True, type=str)
    parser.add_argument('--to-date-hour', required=True, type=str)
    parser.add_argument('--city', required=True, type=str)
    parser.add_argument(
        '--steps',
        required=True,
        nargs='+',
        choices=[
            'prepare_data',
            'prepare_raw_orders_data'
            # 'calculate_metrics_by_performer',
        ],
    )

    args = parser.parse_args()

    assert datetime.datetime.strptime(args.from_date_hour, '%Y-%m-%d')
    assert datetime.datetime.strptime(args.to_date_hour, '%Y-%m-%d')

    base_yt_path_to = args.yt_path_to

    nile_pipeline_params = {
        'period_params' : {
            'begin_dttm': args.from_date_hour,
            'end_dttm': args.to_date_hour
        },
        'supply_type_yt_path': base_yt_path_to + 'alena_lukina_cube_{}_{}',
        'sessions_yt_path': base_yt_path_to + 'sessions_{}_{}',
        'sessions_by_performer_yt_path': base_yt_path_to + 'sessions_by_performer_{}_{}',
        'raw_orders_yt_path': base_yt_path_to + 'raw_orders_{}_{}',
        'claims_yt_path': base_yt_path_to + 'claims_{}_{}',
        'sessions_reqs_yt_path': base_yt_path_to + 'sessions_reqs_{}_{}',
        'tmp_burnt_orders_yt_path': base_yt_path_to + 'tmp_burnt_orders_{}_{}',
        'burnt_orders_yt_path': base_yt_path_to + 'final_burnt_orders_{}_{}',
        'final_table_yt_path': base_yt_path_to + 'final_table_{}_{}'
    }

    manager = Manager(
        yt_proxy=args.yt_proxy,
        nile_pipeline_params=nile_pipeline_params,
    )
    # TODO: по unique_driver_id - целевой сапплай
    # TODO: b2b/not b2b flag

    for step in args.steps:
        print(step)
        getattr(manager, step)()

