import argparse
# import time

import datetime

from projects.efficiency_metrics.manager import Manager
from projects.efficiency_metrics.project_config import get_project_cluster


if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    parser.add_argument('--yt-path-to', required=True, type=str)
    parser.add_argument('--from-date-hour', required=True, type=str)
    parser.add_argument('--to-date-hour', required=True, type=str)
    parser.add_argument('--city', required=True, type=str)
    parser.add_argument(
        '--steps',
        required=True,
        nargs='+',
        choices=[
            'prepare_data',
            # 'calculate_metrics_by_tz'
            # 'calculate_metrics_by_performer',
        ],
    )

    args = parser.parse_args()

    assert datetime.datetime.strptime(args.from_date_hour, '%Y-%m-%d')
    assert datetime.datetime.strptime(args.to_date_hour, '%Y-%m-%d')


    nile_pipeline_params = {
        'period_params' : {
            'begin_dttm': args.from_date_hour,
            'end_dttm': args.to_date_hour
        },
        'supply_type_yt_path': '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/alena_lukina_cube_{}_{}',
        'sessions_yt_path': '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/sessions_{}_{}',
        'sessions_by_performer_yt_path': '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/sessions_by_performer_{}_{}',
        'raw_orders_yt_path': '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/raw_orders_{}_{}',
        'claims_yt_path': '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/claims_{}_{}',
        'sessions_reqs_yt_path': '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/sessions_reqs_{}_{}',
        'tmp_burnt_orders_yt_path': '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/tmp_burnt_orders_{}_{}',
        'burnt_orders_yt_path': '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/final_burnt_orders_{}_{}',
        'final_table_yt_path': '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/final_table_{}_{}'
    }

    # manager = Manager(
    #     yt_proxy=args.yt_proxy,
    #     nile_pipeline_params=nile_pipeline_params,
    # )
    # # TODO: по unique_driver_id - целевой сапплай
    # # TODO: b2b/not b2b flag
    #
    # for step in args.steps:
    #     print(step)
    #     getattr(manager, step)()

    cluster = get_project_cluster()
    #
    import time
    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(bytes_decode_mode='strict', yt_spec_defaults={'max_failed_job_count': 1000})

    from nile.api.v1 import extractors as ne

    from projects.data_sources.data_context.eda_logs import DataContext as EdaOrdersDataContext

    # # tmp_orders = job.table('//home/taxi_ml/dev/drivers/delivery/tmp_tmp/orders_eda').project(
    # #     'order_id',
    # #     flag=ne.const(1)
    # # )
    # tmp_orders = job.table('//home/taxi_ml/dev/drivers/delivery/2021-02/orders_eda').project(
    #     'order_id',
    #     flag=ne.const(1)
    # )
    # # #
    all_eda_orders_yt_path = '//home/taxi_ml/dev/drivers/delivery/2021-02/all_orders_in_eda'
    # # # all_eda_orders_yt_path = '//home/taxi_ml/dev/drivers/delivery/2021-02/orders_eda'
    # # #
    # all_orders_eda = EdaOrdersDataContext(
    #     job,
    #     datetime.datetime.strptime(
    #         '2021-02-07', '%Y-%m-%d')
    #     ,
    #     datetime.datetime.strptime(
    #         '2021-02-09', '%Y-%m-%d'
    #     ),
    # ).get_eda_orders()
    #
    # eda = all_orders_eda.join(
    #     tmp_orders, by='order_id', type='left'
    # ).put(
    #     all_eda_orders_yt_path
    # )
    job.run()

    from projects.data_sources.data_context.raw_services_logs import \
        DataContext as RawLogs

    from projects.data_sources.data_context.cargo import \
        DataContext as CargoLogsDataContext

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(bytes_decode_mode='strict', yt_spec_defaults={'max_failed_job_count': 1000})

    #
    tmp_table = job.table(all_eda_orders_yt_path).project(
        "brand_name",
        "order_id",
        "utc_created_dttm",
        "utc_approved_dttm",
        "utc_place_confirmed_dttm",
        "utc_order_taken_plan_dttm",
        "utc_arrival_to_place_plan_dttm",
        "utc_dttm_winner_applied",
        "utc_cancelled_dttm",
        'taxi_dispatch_cargo_uuid_id'
    )



    # cargo_d_c = CargoLogsDataContext(
    #     job,
    #     datetime.datetime.strptime(
    #         '2021-02-07', '%Y-%m-%d')
    #     ,
    #     datetime.datetime.strptime(
    #         '2021-02-09', '%Y-%m-%d'
    #     ),
    # ).get_claims().project(
    #     'taxi_order_id', 'uuid_id'
    # ).join(
    #     tmp_table, type='inner', by_left='uuid_id', by_right='taxi_dispatch_cargo_uuid_id'
    # ).put(
    #     '//home/taxi_ml/dev/drivers/delivery/2021-02/claims_2_eda_orders'
    # )

    # from projects.data_sources.data_context.raworders_dmorders_sessions import \
    #     DataContext as TaxiOrdersDataContext
    #
    # taxi_orders_table = TaxiOrdersDataContext(
    #     job,
    #     datetime.datetime.strptime(
    #         '2021-02-07', '%Y-%m-%d')
    #     ,
    #     datetime.datetime.strptime(
    #         '2021-02-09', '%Y-%m-%d'
    #     ),
    # ).get_orders().project(
    #     taxi_order_id='order_id', taxi_utc_order_dttm='utc_order_dttm'
    # )
    #
    # job.table('//home/taxi_ml/dev/drivers/delivery/2021-02/claims_2_eda_orders').join(
    #     taxi_orders_table, by='taxi_order_id', type='inner',
    #     # assume_small_left=True
    # ).put(
    #     '//home/taxi_ml/dev/drivers/delivery/2021-02/claims_2_eda_orders_w_taxi_orders'
    # )

    from nile.api.v1 import filters as nf

    # job.table('//home/taxi_ml/dev/drivers/delivery/2021-02/claims_2_eda_orders_w_taxi_orders').join(
    #     job.table(
    #         '//home/taxi_ml/dev/drivers/delivery/2021-02/orders_eda'
    #     ).project('order_id'), by='order_id', type='inner'
    #
    # ).put(
    #     '//home/taxi_ml/dev/drivers/delivery/2021-02/claims_2_eda_orders_w_taxi_orders_burnt'
    # )

    job.table('//home/taxi_ml/dev/drivers/delivery/2021-02/claims_2_eda_orders_w_taxi_orders').join(
        job.table(
            '//home/taxi_ml/dev/drivers/delivery/2021-02/orders_eda'
        ).project('order_id'), by='order_id', type='left_only'

    ).put(
        '//home/taxi_ml/dev/drivers/delivery/2021-02/claims_2_eda_orders_w_taxi_orders_not_burnt'
    )

    # tmp = job.table('//home/taxi_ml/dev/drivers/delivery/tmp_tmp/claims_2_eda_orders')
    # тут нет поля timestapm
    # #
    # all_orders_eda = (
    #
    #     RawLogs(
    #         job,
    #         datetime.datetime.strptime(
    #             '2021-01-30', '%Y-%m-%d')
    #         ,
    #         datetime.datetime.strptime(
    #             '2021-01-31', '%Y-%m-%d'
    #         ),
    #     ).get_taxi_dispatch().join(
    #         tmp, type='inner',
    #         by_left='order_id',
    #         by_right='taxi_order_id'
    #         # TODO - есть заказы, для которых не создался исполнитель ??
    # TODO - видиммо, есть еще новый диспатч ???
    #     )
    #     .put(
    #         '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/inner_orders_candidates'
    #     )

    # )

    from nile.api.v1 import filters as nf
    # job.table('//home/taxi_ml/dev/drivers/delivery/tmp_tmp/inner_orders_candidates').filter(
    #     nf.custom(lambda x: x == 1, 'flag'),
    #     nf.custom(lambda x: x =='Москва', 'region_name'),
    #     nf.custom(lambda x: x == True, 'winner_applied')
    # ).sort(
    #     'taxi_order_id', 'timestamp'
    # ).put(
    #     '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/inner_orders_candidates_burnt_msc_applied'
    # TODO: тут некоторые заказа зудаблированы. потому что отказывались таксисты
    # )
    #
    # job.table('//home/taxi_ml/dev/drivers/delivery/tmp_tmp/inner_orders_candidates').filter(
    #     nf.custom(lambda x: x is None, 'flag')
    # ).put(
    #     '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/inner_orders_candidates_not_burnt'
    # )

    # tmp_table = job.table(
    #     '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/inner_orders_candidates_burnt_msc_applied'
    # ).project(
    #     ne.all('timestamp'),
    #     timestamp_taxi_dispatch='timestamp'
    # )
    # from qb2.api.v1 import filters as qf
    #
    # TRACE_ID_S = ['28cd0a24933b485bbf7ff1cb3015ad19',
    #    '2f78f71862a94d5f8237f5a7194ac2fa',
    #    '1e056df5d2cf43e2badeb7af65e8ce55',
    #    'd3972264f06f4a709ea5ac615a8fc88b',
    #    'dabb4b6d7f574746bbcae7bf4f8ecf9b',
    #    '6db8971adc604eb49ca4cb223a19927d',
    #    'd92e6a2ef09d4da988e5f4f45d6f6a68',
    #    '7a1cfd6ade534475a8305d4848f8e2c4',
    #    'bc35a2ca6b62430881c0780f8d42db9a',
    #    'fff5003003af4d41bb4ce329b60ba904',
    #    'eeaeda4fad3d4f59ba74cbb938e61bb6',
    #    '7064dbfcc6904430a7e831fb6929ff85',
    #    'be1a745ea3c44ab19c2385fb19b7d8f0',
    #    '4207187470a5469e8d0f0a5478928f50',
    #    '0b08310f932f4b03b27a224890f11544',
    #    'a3d3ad83a0e74dc3beaed03e47ccced0',
    #    '75db7b9dfb734c759bb0b3d326b4b99f',
    #    '48378d8f2f1348709ff116ef6334f9c6',
    #    '3d3aea7b2daa4a429937f8aee7b59cd4',
    #    '71283f307b6f4866ad16883efd37d9c8',
    #    '75846a32c3634d6ea59eac3eaad67139',
    #    '018d86c698374b87a4157889218ad601',
    #    '9245bca9fe404cc88a817b4ba1710e6d',
    #    '675330a363784483831c4ba87005d6ac',
    #    'f643062d60c549c1a56f696488e60bca',
    #    '86ac190a6cff4a68a0e1de4ae23584e5',
    #    'cf6870c1768e418d877482d6fdcd7c19',
    #    '71962de57458466794d79935137f14d0',
    #    '5a857465b9c241eb930006a50fdfe01a']
    #
    # RawLogs(
    #     job,
    #     datetime.datetime.strptime(
    #         '2021-01-30', '%Y-%m-%d')
    #     ,
    #     datetime.datetime.strptime(
    #         '2021-01-31', '%Y-%m-%d'
    #     ),
    # ).get_taxi_candidates().filter(
    #     qf.defined('trace_id'),
    #     nf.custom(lambda x: x in TRACE_ID_S, 'trace_id')
    # ).join(
    #     tmp_table, by='trace_id', type='inner', assume_small_right=True
    # ).put(
    #     '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/inner_orders_candidates_burnt_msc_applied_cands_service'
    # )

    # "taxi_order_id"
    # "timestamp" (candidates, not dispath)
    # "not_filtered_candidates"
    # "candidates_meta"
    # "trace_id"
    # "utc_created_dttm"
    # "text"
    # "timestamp_taxi_dispatch"
    # (
    #     job.table(
    #         '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/inner_orders_candidates_burnt_msc_applied_cands_service'
    #     ).project(
    #         "taxi_order_id",
    #         "timestamp",# (candidates, not dispath)
    #         "not_filtered_candidates",
    #         "candidates_meta",
    #         "trace_id",
    #         "utc_created_dttm",
    #         "text",
    #         "timestamp_taxi_dispatch"
    #     ).map(
    #         parse_text_field_mapper
    #     )
    #     .project(
    #         ne.all(['text'])
    #     )
    #     .put(
    #         '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/inner_orders_candidates_burnt_msc_applied_cands_service_final'
    #     )
    # )

    from projects.efficiency_metrics.nile_blocks.junk import (
        not_filtered_candidates_reducer, parse_text_field_mapper
    )



    # job.table(
    #     '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/inner_orders_candidates_burnt_msc_applied_cands_service_final'
    # ).groupby(
    #     'taxi_order_id', 'trace_id', "utc_created_dttm", "timestamp_taxi_dispatch"
    # ).reduce(
    #     not_filtered_candidates_reducer,
    #     memory_limit=50000
    # ).put(
    #     '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/causes'
    # )

    # А сколько по времени искали исполнителя ?

    # order_id -> several trace_id (розыгрышей) -> ..

    # job.table('//home/taxi_ml/dev/drivers/delivery/tmp_tmp/inner_orders_candidates_burnt_msc_applied').project(
    #     ne.all(),
    #     utc_dttm_winner_applied= ne.custom(
    #         lambda x: datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%dT%H:%M:%S'),
    #         'timestamp'
    #     )
    # ).put(
    #     '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/inner_orders_candidates_burnt_msc_applied_2_dttm'
    # )


    from nile.api.v1 import filters as nf


    # job.table('//home/taxi_ml/dev/drivers/delivery/tmp_tmp/inner_orders_candidates').filter(
    #     nf.custom(lambda x: x == 1, 'flag'),
    #     nf.custom(lambda x: x =='Москва', 'region_name'),
    # ).project(
    #     ne.all(),
    #     utc_dttm_candidates= ne.custom(
    #         lambda x: datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%dT%H:%M:%S'),
    #         'timestamp'
    #     )
    # ).groupby(
    #     'taxi_order_id'
    # ).sort(
    #     'timestamp'
    # ).reduce(
    #     _reducer
    # ).put(
    #     '//home/taxi_ml/dev/drivers/delivery/tmp_tmp/inner_orders_candidates_burnt_msc_applied_not'
    # # TODO: тут некоторые заказа зудаблированы. потому что отказывались таксисты
    # )

    job.run()

    # yt_p = '//home/logfeller/logs/taxi-candidates-yandex-taxi-candidates-log/1d/2021-01-30[#0:#20]'
    # for r in cluster.read(yt_p):
    #     import json
    #
    #     asd = None
    #     import six
    #     text = six.ensure_str(r.text)
    #
    #     if 'results' in six.ensure_str(text):
    #         asd = text.split(' ')[1].strip()
    #         tmp = '{"results":' + text.split(' ')[1] + '}'
    #         print (json.loads(tmp)[u'results'])
