import argparse
import time

import datetime

from projects.efficiency_metrics.manager import Manager
from projects.efficiency_metrics.project_config import get_project_cluster


import time
import re

import json

import datetime
import six
from nile.api.v1 import aggregators as na
from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from nile.api.v1 import Record
from qb2.api.v1 import filters as qf
from qb2.api.v1 import typing as qt

from projects.common.nile.dates import range_selector
from projects.common.time_utils import datetime_2_timestamp, \
    parse_timestring

from projects.batching.launcher_2 import calc_time_till_cancell
from projects.batching.batching_custom_params import (
    YARCHE_ADDRESSES, VV_ADDRESSES_TMP
)
from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as OrdersSessionsLogsDataContext
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawServicesLogsDataContext
from projects.efficiency_metrics.project_config import get_project_cluster
from projects.batching.nile_blocks.corps import calc_a_density_reducer
from projects.common.gp_transfer import transfer_from_yt_2_gp

import time
import re

import json

import datetime
import six
from nile.api.v1 import aggregators as na
from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from nile.api.v1 import Record
from qb2.api.v1 import filters as qf
from qb2.api.v1 import typing as qt

from projects.common.nile.dates import range_selector
from projects.common.time_utils import datetime_2_timestamp, \
    parse_timestring

from projects.batching.launcher_2 import calc_time_till_cancell
from projects.batching.batching_custom_params import (
    YARCHE_ADDRESSES, VV_ADDRESSES_TMP
)
from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as OrdersSessionsLogsDataContext
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawServicesLogsDataContext
from projects.efficiency_metrics.project_config import get_project_cluster
from projects.batching.nile_blocks.corps import calc_a_density_reducer
from projects.common.gp_transfer import transfer_from_yt_2_gp


def extr(module, resp, text, uri):
    available_candidates = []
    # if module == 'planner-segment-edges':
    #     edges = json.loads(text)['edges']
    #     for edge in edges:
    #         contractor_id = edge['driver_id']
    #         kind = edge['kind']
    #         available_candidates.append(
    #             {
    #                 'contractor_id': contractor_id,
    #                 'kind': kind
    #             }
    #         )
    if (module == 'ServiceApi') and (resp is not None) and (uri == '/order-search'):
        response = json.loads(resp)
        if 'candidates' not in response:
            return None

        for candidate in response['candidates']:
            candidate_id = candidate['id']
            available_candidates.append(candidate_id)
    return available_candidates

if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    args = parser.parse_args()

    cluster = get_project_cluster()

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(
        bytes_decode_mode='strict',
        yt_spec_defaults={'max_failed_job_count': 1000}
    )

    to_dttm = datetime.datetime.strptime('2021-04-05', '%Y-%m-%d')
    from_dttm = to_dttm - datetime.timedelta(days=4)

    cargo_d_c = CargoLogsDataContext(
        job,
        from_dttm,
        to_dttm
    )

    points = cargo_d_c.get_points().project(ne.all(['timestamp', 'source']))

    claim_points = cargo_d_c.get_claim_points().project(
        ne.all(['timestamp', 'source'])
    )

    b2b_orders = (
        cargo_d_c.get_claims()
            .filter(
                nf.custom(lambda x: x != 'platform_usage', 'claim_kind'),
                # nf.custom(lambda x: x is not None, 'taxi_order_id')
            )
            .project(
                'taxi_order_id', 'uuid_id', 'timestamp', 'final_price',
                'corp_client_id',
                'status', 'zone_id', 'dispatch_flow', 'final_pricing_calc_id',
                'is_delayed', 'due', 'eta', 'currency',
                'last_status_change_ts',
                claim_id='id',
                utc_date=ne.custom(
                    lambda x:
                    datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%d'),
                    'timestamp'
                ),
                hour=ne.custom(
                    lambda x:
                    datetime.datetime.utcfromtimestamp(x).hour,
                    'timestamp'
                ),
                utc_date_hour=ne.custom(
                    lambda x:
                    datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%d %H'),
                    'timestamp'
                ),
                is_success_order=ne.custom(
                    lambda x: x in ['delivered_finish', 'returned_finish'],
                    'status'
                ),
                is_b2b_order=ne.const(True),
                expired_order_flg=ne.custom(
                    lambda x: x not in ['delivered_finish', 'returned_finish'],
                    'status'
                )
            )
        #     .join(
        #     cargo_d_c.get_segments().project(ne.all(['timestamp', 'source'])),
        #     # by='claim_id', type='inner'
        #     by_left='uuid_id', by_right='claim_id', type='inner'
        # )
            .join(
            claim_points, by='claim_id', type='inner'
        ).join(
            points, by='point_id', type='inner'
        ).filter(
            nf.custom(lambda x: x == 'source', 'type')
        )
    ).put(
            '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/get_b2b_orders'
        )

    from projects.data_sources.data_context.raworders_dmorders_sessions import \
        DataContext as TaxiOrdersDataContext

    # taxi_orders_table =

    # from_dttm = datetime.datetime.strptime('2021-04-01', '%Y-%m-%d')
    # to_dttm = datetime.datetime.strptime('2021-04-05', '%Y-%m-%d')

    # job.concat(
    #     b2b_orders, c2c_orders
    # )\
    # b2b_orders.groupby('claim_id', 'taxi_order_id').reduce(
    #     get_burnt_by_reducer
    # ).put(
    #     '//home/taxi-delivery/analytics/production/efficiency_metrics/orders/{}_burnt'.format(
    #         to_dttm.strftime('%Y-%m-%d'))
    # )

    # job.table('//home/taxi-delivery/analytics/production/efficiency_metrics/orders/{}'.format(
    #         to_dttm.strftime('%Y-%m-%d'))).filter(
    #     nf.custom(lambda x: x == '2021-04-03', 'utc_date')
    # ).put(
    #     '//home/taxi-delivery/analytics/production/efficiency_metrics/orders/{}_2021-04-03'.format(
    #         to_dttm.strftime('%Y-%m-%d'))
    # )


    from projects.data_sources.data_context.raw_services_logs import \
        DataContext as RawLogs

    # tmp = job.table(
    #     '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/tmp_orders_tmp_wo_taxi_order_id'
    # ).filter(
    #     nf.custom(lambda x: (x >= '2021-04-01') and (x < '2021-04-04'), 'utc_date')
    # )

    # all_orders_eda = (
    #
    #     RawLogs(
    #         job,
    #         datetime.datetime.strptime(
    #             '2021-04-01', '%Y-%m-%d')
    #         ,
    #         datetime.datetime.strptime(
    #             '2021-04-04', '%Y-%m-%d'
    #         ),
    #     ).get_taxi_dispatch().join(
    #         tmp, type='inner',
    #         by_left='order_id',
    #         by_right='taxi_order_id'
    #         # TODO - есть заказы, для которых не создался исполнитель ??
    #         # TODO - видиммо, есть еще новый диспатч ???
    #     ).filter(
    #         nf.custom(lambda x: x == True, 'winner_applied')
    #     ).put(
    #         '//home/taxi-delivery/analytics/production/efficiency_metrics/orders/inner_orders_candidates_not_fake_tmp'
    #     )
    # )

    import geohash as gh

    # TODO: FINAL

    # job.table(
    #     '//home/taxi-delivery/analytics/production/efficiency_metrics/orders/inner_orders_candidates_not_fake_tmp'
    # ).join(
    #     job.table(
    #         '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/realtime_schema_cp_05_04'
    #     ).project(
    #         'group', 'taxi_order_id'
    #     ).filter(
    #         nf.custom(
    #             lambda x:
    #             x == 'ld_vs_taxi_dispatch_experiment_2021-03-11_control',
    #             'group'
    #         )
    #     ),
    #     type='inner', by='taxi_order_id'
    # ).project(
    #     "geo_point",
    #     "taxi_order_id",
    #     "utc_date_hour",
    #     'candidates_meta',
    #     'zone_id',
    #     'claim_id',
    #     'segment_id',
    #     minute=ne.custom(
    #         lambda x:
    #         datetime.datetime.utcfromtimestamp(x).minute,
    #         'timestamp'
    #     ),
    #     geo_hash=ne.custom(lambda x: gh.encode(x[1], x[0], precision=6), 'geo_point')#'lat', 'lon')
    # ).put(
    #     '//home/taxi-delivery/analytics/production/efficiency_metrics/orders/inner_orders_candidates_not_fake_taxi_dispatch_group'
    # )
    # TODO: FINAL

    # tmp = (
    #     job.table(
    #         '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/realtime_schema_cp_05_04'
    #     ).project(
    #         'group', 'claim_id',
    #         # "chosen_waybill"
    #         # "dispatch_flow"
    #         # "group"
    #         "status",
    #         "utc_date",
    #         "timestamp",
    #         # "c_i"
    #         # "claim_id"
    #         "corp_client_id",
    #         # "currency"
    #         # "dist"
    #         # "eta"
    #         # "look_for_performer_time"
    #         # "n_cands"
    #         # "sp"
    #         # "tariff_class"
    #         "taxi_order_id",
    #         # "taxi_order_status"
    #         # "ts_created"
    #         # "employer"
    #         "zone_id",
    #         "hour",
    #         "utc_date_hour",
    #         "type_of_dispatch",
    #         "sec_till_cancelled",
    #         "sec_till_performer_lookup",
    #         "sec_till_performer_found",
    #         "sec_till_delivered_returned",
    #         "sec_till_delivered"
    #     ).filter(
    #         nf.custom(
    #             lambda x:
    #             x == 'ld_vs_taxi_dispatch_experiment_2021-03-11',
    #             'group'
    #         )
    #     )
    #     .join(
    #         cargo_d_c.get_segments().project(ne.all(['timestamp', 'source'])),
    #         by_left='claim_id',#'uuid_id',
    #         by_right='claim_id', type='inner'
    #     )
    #         .put(
    #         '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/realtime_schema_cp_05_04_2_segment_id'
    #     )
    # )

    # tmp = (
    #     job.table(
    #         '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/realtime_schema_cp_05_04_2_segment_id'
    #     )
    #         .join(
    #         b2b_orders,
    #         type='inner', by='claim_id'
    #     )
    #         .put(
    #         '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/get'
    #     )
    # )

    # all_orders_eda = (
    #
    #     RawLogs(
    #         job,
    #         datetime.datetime.strptime(
    #             '2021-04-01', '%Y-%m-%d')
    #         ,
    #         datetime.datetime.strptime(
    #             '2021-04-04', '%Y-%m-%d'
    #         ),
    #     ).get_ld_dispatch()
    #         .join(
    #         tmp.join(
    #             cargo_d_c.get_waybills(),
    #             by_left='chosen_waybill',
    #             by_right='external_ref', type='inner'
    #         ), type='inner',
    #         by='segment_id'
    #         # TODO - есть заказы, для которых не создался исполнитель ??
    #         # TODO - видиммо, есть еще новый диспатч ???
    #     ).project(
    #     'segment_id', 'claim_id', 'taxi_order_id', 'utc_date', 'zone_id',
    #     'module', 'response', 'text', 'uri',
    #     # candidates_meta=ne.custom(
    #     #     lambda x, y, z, w: extr(x, y, z, w),
    #     #     'module', 'response', 'text', 'uri'
    #     # ),
    #
    #     minute=ne.custom(
    #         lambda x:
    #         datetime.datetime.utcfromtimestamp(x).minute,
    #         'timestamp'
    #     ),
    #     utc_date_hour=ne.custom(
    #         lambda x:
    #         datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%d %H'),
    #         'timestamp'
    #     ),
    #     geo_hash=ne.custom(lambda x, y: gh.encode(x, y, precision=6),
    #                        'latitude', 'longitude')#'lat', 'lon')
    #
    # ).filter(
    #     nf.custom(lambda x: x == "planner-segment-edges", 'module'),
    #     nf.custom(lambda x: x is None, 'taxi_order_id')
    # ).put(
    #     '//home/taxi-delivery/analytics/production/efficiency_metrics/orders/inner_orders_candidates_not_fake_log_dispatch_tmp'
    # )
    # )
    # all_orders_eda = (
    #
    #     RawLogs(
    #         job,
    #         datetime.datetime.strptime(
    #             '2021-04-01', '%Y-%m-%d')
    #         ,
    #         datetime.datetime.strptime(
    #             '2021-04-04', '%Y-%m-%d'
    #         ),
    #     ).get_taxi_dispatch().join(
    #         c2c_orders, type='inner',
    #         by_left='order_id',
    #         by_right='taxi_order_id'
    #         # TODO - есть заказы, для которых не создался исполнитель ??
    #         # TODO - видиммо, есть еще новый диспатч ???
    #     ).filter(
    #         nf.custom(lambda x: x == True, 'winner_applied')
    #     ).put(
    #         '//home/taxi-delivery/analytics/production/efficiency_metrics/orders/inner_orders_candidates_not_fake_c2c'
    #     )
    # )

    job.run()