from typing import Dict, Optional
import six

from nile.api.v1.job import Job
from nile.api.v1 import clusters
from nile.api.v1 import Cluster

from projects.common.nile.environment import DEFAULT_CLUSTER
from projects.common.decorators import required_fields
from projects.efficiency_metrics.pipeline import NilePipeline
from projects.efficiency_metrics.project_config import get_project_cluster

# DEFAULT_POOL = 'taxi-delivery'


class Manager:
    def __init__(
            self,
            *,
            yt_proxy: str = DEFAULT_CLUSTER,
            # yt_pool: str = DEFAULT_POOL,
            nile_pipeline_params: Optional[Dict[str, str]] = None,
    ):
        self.yt_proxy = yt_proxy
        self.nile_pipeline_params = nile_pipeline_params or {}
        # self.yt_pool = yt_pool

    def _get_cluster(self) -> Cluster:
        return get_project_cluster(
            parallel_operations_limit=10,
            proxy=self.yt_proxy,
            # yt_pool=self.yt_pool
        )

    @staticmethod
    def _run_job(job: Job) -> None:
        with job.driver.transaction():
            job.run()

    def _get_nile_pipeline(self, job: Optional[Job] = None) -> NilePipeline:
        if job is None:
            job = self._get_cluster().job()
            job = job.env(bytes_decode_mode='strict')
        return NilePipeline(
            job=job,
            **self.nile_pipeline_params,
        )

    def prepare_supply_type_data(self):
        job = self._get_cluster().job()
        job = job.env(bytes_decode_mode='strict')

        supply_type_yt_path_to = (self.nile_pipeline_params['supply_type_yt_path'].format(
                self.nile_pipeline_params['period_params']['begin_dttm'],
                self.nile_pipeline_params['period_params']['end_dttm']
            ))

        self._get_nile_pipeline(job).get_supply_type_data().put(
            supply_type_yt_path_to
        )

        self._run_job(job)

    def prepare_raw_orders_data(self):
        job = self._get_cluster().job()
        job = job.env(bytes_decode_mode='strict')

        print(self.nile_pipeline_params)

        print(self.nile_pipeline_params['raw_orders_yt_path'],
                self.nile_pipeline_params['period_params']['begin_dttm'],
                self.nile_pipeline_params['period_params']['end_dttm']
            )

        raw_orders_yt_path_to = (
            self.nile_pipeline_params['raw_orders_yt_path'].format(
                self.nile_pipeline_params['period_params']['begin_dttm'],
                self.nile_pipeline_params['period_params']['end_dttm']
            )
        )
        #
        self._get_nile_pipeline(job).get_raw_orders_in_courier_delivery(

        ).put(raw_orders_yt_path_to)

        self._run_job(job)

    def prepare_data(self) -> None:
        job = self._get_cluster().job()
        job = job.env(bytes_decode_mode='strict')

        supply_type_yt_path_to = (self.nile_pipeline_params['supply_type_yt_path'].format(
                self.nile_pipeline_params['period_params']['begin_dttm'],
                self.nile_pipeline_params['period_params']['end_dttm']
            ))
        supply_type_table = self._get_nile_pipeline(job).get_supply_type_data().put(
            supply_type_yt_path_to
        )

        sessions_yt_path_to = (
            self.nile_pipeline_params['sessions_yt_path'].format(
                self.nile_pipeline_params['period_params']['begin_dttm'],
                self.nile_pipeline_params['period_params']['end_dttm']
            )
        )

        sessions_table = self._get_nile_pipeline(job).get_sessions_w_log_couriers_data().put(
            sessions_yt_path_to
        )


        # TODO: filter performer_id, who has another profiles with econom and other tariffs
        sessions_py_performer_yt_path_to = (
            self.nile_pipeline_params['sessions_by_performer_yt_path'].format(
                self.nile_pipeline_params['period_params']['begin_dttm'],
                self.nile_pipeline_params['period_params']['end_dttm']
            )
        )

        # sessions_table = job.table(sessions_yt_path_to)

        self._get_nile_pipeline(job).create_sessions_py_performer_table(
            sessions_table
        ).put(
            sessions_py_performer_yt_path_to
        )


        raw_orders_yt_path_to = (
            self.nile_pipeline_params['raw_orders_yt_path'].format(
                self.nile_pipeline_params['period_params']['begin_dttm'],
                self.nile_pipeline_params['period_params']['end_dttm']
            )
        )
        #
        self._get_nile_pipeline(job).get_raw_orders_in_courier_delivery(

        ).put(raw_orders_yt_path_to)
        # TODO: настроить выгрузку все спец условий (чтобы знать, появились ли новые)


        claims_yt_path_to = (
            self.nile_pipeline_params['claims_yt_path'].format(
                self.nile_pipeline_params['period_params']['begin_dttm'],
                self.nile_pipeline_params['period_params']['end_dttm']
            )
        )
        #
        self._get_nile_pipeline(job).get_claims_data(

        ).put(
            claims_yt_path_to
        )


        from nile.api.v1 import filters as nf
        # job.table('//home/taxi_ml/dev/drivers/delivery/tmp_/claims_2021-01-24_2021-01-25').filter(
        #     # nf.custom(lambda x: x == 'performer_not_found', 'status')
        #     nf.custom(lambda x: x != 'delivered_finish', 'status')
        # ).put('//home/taxi_ml/dev/drivers/delivery/tmp_/claims_not_finished_2021-01-24_2021-01-25')

        # performer_not_found
        # delivered_finish
        # returned_finish
        # cancelled
        # cancelled_with_payment
        # cancelled_by_taxi
        # cancelled_with_items_on_hands
        # failed

        # sessions_reqs_yt_path_to = (
        #     self.nile_pipeline_params['sessions_reqs_yt_path'].format(
        #         self.nile_pipeline_params['period_params']['begin_dttm'],
        #         self.nile_pipeline_params['period_params']['end_dttm']
        #     )
        # )
        #
        # self._get_nile_pipeline(
        #     job
        # ).join_driver_sessions_with_drier_reqs_type(supply_type_yt_path_to).put(
        #     sessions_reqs_yt_path_to
        # )

        # burnt_orders_yt_path_to = (
        #     self.nile_pipeline_params['tmp_burnt_orders_yt_path'].format(
        #         self.nile_pipeline_params['period_params']['begin_dttm'],
        #         self.nile_pipeline_params['period_params']['end_dttm']
        #     )
        # )
        #
        # self._get_nile_pipeline(job).create_burnt_orders_by_req_type().put(
        #     burnt_orders_yt_path_to
        # )

        # burnt_orders_yt_path_to = (
        #     self.nile_pipeline_params['burnt_orders_yt_path'].format(
        #         self.nile_pipeline_params['period_params']['begin_dttm'],
        #         self.nile_pipeline_params['period_params']['end_dttm']
        #     )
        # )
        #
        # self._get_nile_pipeline(job).create_causes_type_of_supply_for_burnt().put(
        #     burnt_orders_yt_path_to
        #     # только заказы, в которых есть теги
        #     # из 60к - 1200 штук
        # )


        # final_table_to = (
        #     self.nile_pipeline_params['final_table_yt_path'].format(
        #         self.nile_pipeline_params['period_params']['begin_dttm'],
        #         self.nile_pipeline_params['period_params']['end_dttm']
        #     )
        # )
        #
        # self._get_nile_pipeline(job).final_join_sessions_and_orders().put(
        #     final_table_to
        # )
        #
        # self._get_nile_pipeline(job).final().put(
        #     '//home/taxi_ml/dev/drivers/delivery/tmp_/final_table_2021-01-24_2021-01-25_only_auto'
        # )

        # from projects.efficiency_metrics.by_performer_reducer import utilization_and_efficiency_by_performer_mapper
        #
        # job.table(args.yt_path_to.format('sessions_by_performer_{}'.format(date))).map(
        #     utilization_and_efficiency_by_performer_mapper
        # ).put(
        #     args.yt_path_to.format('eff_metrics_by_performer_{}'.format(date))
        # )



        self._run_job(job)

