import argparse
import time

import datetime

from projects.efficiency_metrics.manager import Manager
from projects.efficiency_metrics.project_config import get_project_cluster


import time
import re

import json

import datetime
import six
from nile.api.v1 import aggregators as na
from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from nile.api.v1 import Record
from qb2.api.v1 import filters as qf
from qb2.api.v1 import typing as qt

from projects.common.nile.dates import range_selector
from projects.common.time_utils import datetime_2_timestamp, \
    parse_timestring

from projects.batching.launcher_2 import calc_time_till_cancell
from projects.batching.batching_custom_params import (
    YARCHE_ADDRESSES, VV_ADDRESSES_TMP
)
from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as OrdersSessionsLogsDataContext
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawServicesLogsDataContext
from projects.efficiency_metrics.project_config import get_project_cluster
from projects.batching.nile_blocks.corps import calc_a_density_reducer
from projects.common.gp_transfer import transfer_from_yt_2_gp

import time
import re

import json

import datetime
import six
from nile.api.v1 import aggregators as na
from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from nile.api.v1 import Record
from qb2.api.v1 import filters as qf
from qb2.api.v1 import typing as qt

from projects.common.nile.dates import range_selector
from projects.common.time_utils import datetime_2_timestamp, \
    parse_timestring

from projects.batching.launcher_2 import calc_time_till_cancell
from projects.batching.batching_custom_params import (
    YARCHE_ADDRESSES, VV_ADDRESSES_TMP
)
from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as OrdersSessionsLogsDataContext
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawServicesLogsDataContext
from projects.efficiency_metrics.project_config import get_project_cluster
from projects.batching.nile_blocks.corps import calc_a_density_reducer
from projects.common.gp_transfer import transfer_from_yt_2_gp



if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    # parser.add_argument('--yt-path-to', required=True, type=str)
    # parser.add_argument('--from-date-hour', required=True, type=str)
    # parser.add_argument('--to-date-hour', required=True, type=str)
    # parser.add_argument('--city', required=True, type=str)
    # parser.add_argument(
    #     '--steps',
    #     required=True,
    #     nargs='+',
    #     choices=[
    #         'prepare_data',
    #         # 'calculate_metrics_by_tz'
    #         # 'calculate_metrics_by_performer',
    #     ],
    # )

    args = parser.parse_args()

    # assert datetime.datetime.strptime(args.from_date_hour, '%Y-%m-%d')
    # assert datetime.datetime.strptime(args.to_date_hour, '%Y-%m-%d')

    cluster = get_project_cluster()

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(
        bytes_decode_mode='strict',
        yt_spec_defaults={'max_failed_job_count': 1000}
    )

    # utc_datetime = datetime.datetime.utcnow()  # not .utcnow()
    # # from_dttm = (utc_datetime - datetime.timedelta(hours=N_HOURS))
    # from_dttm = datetime.datetime.strptime('2021-01-01', '%Y-%m-%d')
    # print(from_dttm)
    # to_dttm = utc_datetime#.strftime('%Y-%m-%dT%H:%M:%S')

    # from_dttm = datetime.datetime.strptime('2021-04-01', '%Y-%m-%d')
    to_dttm = datetime.datetime.strptime('2021-04-05', '%Y-%m-%d')
    from_dttm = to_dttm - datetime.timedelta(days=7)

    cargo_d_c = CargoLogsDataContext(
        job,
        from_dttm,
        to_dttm
    )

    b2b_orders = (
        cargo_d_c.get_claims()
            .filter(
                nf.custom(lambda x: x != 'platform_usage', 'claim_kind'),
                # nf.custom(lambda x: x is not None, 'taxi_order_id')
            )
            .project(
                'taxi_order_id', 'uuid_id', 'timestamp', 'final_price',
                'corp_client_id',
                'status', 'zone_id', 'dispatch_flow', 'final_pricing_calc_id',
                'is_delayed', 'due', 'eta', 'currency',
                'last_status_change_ts',
                claim_id='id',
                utc_date=ne.custom(
                    lambda x:
                    datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%d'),
                    'timestamp'
                ),
                hour=ne.custom(
                    lambda x:
                    datetime.datetime.utcfromtimestamp(x).hour,
                    'timestamp'
                ),
                utc_date_hour=ne.custom(
                    lambda x:
                    datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%d %H'),
                    'timestamp'
                ),
                is_success_order=ne.custom(
                    lambda x: x in ['delivered_finish', 'returned_finish'],
                    'status'
                ),
                is_b2b_order=ne.const(True),
                expired_order_flg=ne.custom(
                    lambda x: x not in ['delivered_finish', 'returned_finish'],
                    'status'
                )
            ).join(
            cargo_d_c.get_segments().project(ne.all(['timestamp', 'source'])),
            by_left='uuid_id', by_right='claim_id', type='inner'
        )
    )

    from projects.data_sources.data_context.raworders_dmorders_sessions import \
        DataContext as TaxiOrdersDataContext

    c2c_orders = TaxiOrdersDataContext(
        job,
        from_dttm,
        to_dttm,
    ).get_orders().filter(
        nf.custom(lambda x: x == False, 'corp_order_flg'),
        nf.custom(lambda x: x in set(['express', 'courier']), 'order_tariff')
    ).project(
        'status', 'taxi_status', 'expired_order_flg',
        'order_source_lon', 'order_source_lat',
        taxi_order_id='order_id', taxi_utc_order_dttm='utc_order_dttm',
        is_b2b_order=ne.const(False),
        zone_id='tariff_zone',
        utc_date=ne.custom(
            lambda x:
            x[:10],
            'utc_order_dttm'
        ),
        utc_date_hour=ne.custom(
            lambda x:
            x[:13],
            'utc_order_dttm'
        ),
    )

    # job.concat(
    #     b2b_orders, c2c_orders
    # ).put(
    #     '//home/taxi-delivery/analytics/production/efficiency_metrics/orders/{}'.format(
    #         to_dttm.strftime('%Y-%m-%d'))
    # )

    def get_burnt_by_reducer(groups):
        for key, records in groups:
            is_b2b_order = None
            utc_date = None
            utc_date_hour = None
            zone_id = None

            status = None
            taxi_status = None

            is_expired_flag = True

            for record in records:
                is_b2b_order = record.is_b2b_order
                utc_date = record.utc_date
                utc_date_hour = record.utc_date_hour
                zone_id = record.zone_id
                status = record.status
                taxi_status = record.get('taxi_status')
                if record.status in set([
                    'delivered_finish', 'returned_finish', 'finished'
                ]):
                    if taxi_status is None:
                        is_expired_flag = False
                    elif taxi_status == 'complete':
                        is_expired_flag = False

            yield Record(
                key,
                is_b2b_order=is_b2b_order,
                utc_date=utc_date,
                utc_date_hour=utc_date_hour,
                zone_id=zone_id,
                is_expired_flag=is_expired_flag,
                taxi_status=taxi_status,
                status=status
            )

    # job.table(
    #     '//home/taxi-delivery/analytics/production/efficiency_metrics/orders/{}'.format(
    #         to_dttm.strftime('%Y-%m-%d'))
    # ).groupby('claim_id', 'taxi_order_id').reduce(
    #     get_burnt_by_reducer
    # ).put(
    #     '//home/taxi-delivery/analytics/production/efficiency_metrics/orders/{}_burnt'.format(
    #         to_dttm.strftime('%Y-%m-%d'))
    # )

    def calc_burnt_stats_reducer(groups):
        for key, records in groups:
            n_orders = 0
            n_expired_orders = 0
            for record in records:
                n_orders += 1
                n_expired_orders += record.is_expired_flag
            yield Record(
                key,
                n_orders=n_orders,
                n_expired_orders=n_expired_orders
            )

    job.table(
        '//home/taxi-delivery/analytics/production/efficiency_metrics/orders/{}_burnt'.format(
            to_dttm.strftime('%Y-%m-%d'))
    ).groupby(
        'zone_id', 'utc_date_hour', 'is_b2b_order'
    ).reduce(
        calc_burnt_stats_reducer
    ).put(
        '//home/taxi-delivery/analytics/production/efficiency_metrics/orders/{}_burnt_by_hour'.format(
            to_dttm.strftime('%Y-%m-%d'))
    )

    # job.table('//home/taxi-delivery/analytics/production/efficiency_metrics/orders/{}'.format(
    #         to_dttm.strftime('%Y-%m-%d'))).filter(
    #     nf.custom(lambda x: x == '2021-04-03', 'utc_date')
    # ).put(
    #     '//home/taxi-delivery/analytics/production/efficiency_metrics/orders/{}_2021-04-03'.format(
    #         to_dttm.strftime('%Y-%m-%d'))
    # )


    from projects.data_sources.data_context.raw_services_logs import \
        DataContext as RawLogs

    # tmp = job.table(
    #     '//home/taxi-delivery/analytics/production/ld_ab_test/monitorings/tmp_orders_tmp_wo_taxi_order_id'
    # ).filter(
    #     nf.custom(lambda x: (x >= '2021-04-01') and (x < '2021-04-04'), 'utc_date')
    # )

    # all_orders_eda = (
    #
    #     RawLogs(
    #         job,
    #         datetime.datetime.strptime(
    #             '2021-04-01', '%Y-%m-%d')
    #         ,
    #         datetime.datetime.strptime(
    #             '2021-04-04', '%Y-%m-%d'
    #         ),
    #     ).get_taxi_dispatch().join(
    #         tmp, type='inner',
    #         by_left='order_id',
    #         by_right='taxi_order_id'
    #         # TODO - есть заказы, для которых не создался исполнитель ??
    #         # TODO - видиммо, есть еще новый диспатч ???
    #     ).filter(
    #         nf.custom(lambda x: x == True, 'winner_applied')
    #     ).put(
    #         '//home/taxi-delivery/analytics/production/efficiency_metrics/orders/inner_orders_candidates_not_fake'
    #     )
    # )

    # all_orders_eda = (
    #
    #     RawLogs(
    #         job,
    #         datetime.datetime.strptime(
    #             '2021-04-01', '%Y-%m-%d')
    #         ,
    #         datetime.datetime.strptime(
    #             '2021-04-04', '%Y-%m-%d'
    #         ),
    #     ).get_taxi_dispatch().join(
    #         c2c_orders, type='inner',
    #         by_left='order_id',
    #         by_right='taxi_order_id'
    #         # TODO - есть заказы, для которых не создался исполнитель ??
    #         # TODO - видиммо, есть еще новый диспатч ???
    #     ).filter(
    #         nf.custom(lambda x: x == True, 'winner_applied')
    #     ).put(
    #         '//home/taxi-delivery/analytics/production/efficiency_metrics/orders/inner_orders_candidates_not_fake_c2c'
    #     )
    # )

    job.run()
