from collections import Counter

from nile.api.v1 import Record


def by_statuses_reducer(groups):
    for key, records in groups:
        cnt = Counter()
        for record in records:
            cnt[record.status] += 1

        n_orders = sum(cnt.values())
        yield Record(
            key,
            n_orders=n_orders,
            **cnt
        )
