from nile.api.v1 import extractors as ne
from nile.api.v1 import Record


def parse_alena_mapper(records):
    for record in records:
        tags = []
        if record.thermobox_option_on_tag:
            tags.append('thermobox_option_on')
        if record.thermobag_confirmed_tag:
            tags.append('thermobag_confirmed')
        if record.multipoints_tag:
            tags.append('multipoint')
        if record.expeditor_tag:
            tags.append('expeditor')

        # # Russia - autocourier_sh_share >= 0.8,
        # # Abroad - auto_courier_tag >= 0.8
        # # walk courier - walking_courier_tag >= 0.8
        # nf.custom(lambda x: x or 0 >= 0.8, 'autocourier_sh_share'),
        # nf.custom(lambda x: x >= 0.8, 'auto_courier_tag'),
        # nf.custom(lambda x: x >= 0.8, 'walking_courier_tag')
        supply_type = None
        if ((record.get('autocourier_sh_share', 0) or 0 >= 0.8) or (
                record.get('auto_courier_tag', 0) or 0 >= 0.8
        )):
            supply_type = 'auto_courier'
        if record.get('walking_courier_tag', 0) or 0 >= 0.8:
            supply_type = 'walking_courier'

        for tag in tags:
            yield Record(
                dbid_uuid=record.dbid_uuid,
                utc_dt=record.utc_dt,
                supply_type=supply_type,
                additional_requirements=tag
            )
