from collections import Counter
import json

import six
from nile.api.v1 import Record


def not_filtered_candidates_reducer(groups):
    # "taxi_order_id"
    # "trace_id"
    # "utc_created_dttm"
    # "timestamp_taxi_dispatch"

    # "timestamp" (candidates, not dispath)
    # "not_filtered_candidates"
    # "candidates_meta"
    for key, records in groups:
        candidates_w_filters = {}

        for record in records:
            # does not change
            candidates_meta = record.get('candidates_meta')

            if record.get('not_filtered_candidates') is None:
                continue

            not_filtered_candidates = (
                record.get('not_filtered_candidates', {'results': []})
                    .get('results', [])
            )

            unique_candidates = set()
            unique_candidates_filters = set()
            filters_counter = Counter()
            ts = record.timestamp

            for dbid_uuid, some_filter, _ in not_filtered_candidates:
                # candidates_w_filters.append(
                #     [dbid_uuid, some_filter, record.timestamp]
                # )
                unique_candidates.add(dbid_uuid)
                unique_candidates_filters.add(
                    '{}_{}'.format(dbid_uuid, some_filter))
                filters_counter[some_filter] += 1

            candidates_w_filters[str(ts)] = {
                'n_unique_candidates': len(unique_candidates),
                'n_unique_candidates_filters': len(unique_candidates_filters),
                # 'filters_counter': dict(filters_counter)
            }

        yield Record(
            key,
            candidates_w_filters=candidates_w_filters,
            candidates_meta=candidates_meta
        )

#
# def _reducer(groups):
#     for key, records in groups:
#         earliest_ts=None
#         ts_2_cands={}
#         for record in records:
#             if earliest_ts is None:
#                 earliest_ts = record.utc_dttm_candidates
#             n_cands = len(record.get('candidates_meta').keys())
#             ts_2_cands[record.utc_dttm_candidates] = n_cands
#
#         for k, v in
#         yield Record(
#             key,
#             ts_2_cands=ts_2_cands,
#             earliest_ts=earliest_ts
#         )

def parse_text_field_mapper(records):
    for record in records:
        text = six.ensure_str(record.text)

        not_filtered_candidates = None
        if ('results' in text):
            asd =  text.split(' ')[1]
            tmp = '{"results":' + asd + '}'
            try:
                # TODO - оч плохо. обрабатываем "{\"results\":to}"
                not_filtered_candidates=json.loads(tmp)
            except:
                continue
        yield Record(
            record,
            not_filtered_candidates=not_filtered_candidates
        )
