from nile.api.v1 import Record


def extract_order_proc_mapper(records):
    for record in records:
        # help fields
        utc_order_dttm = record.get('order_created')
        doc = record.get('doc')
        doc_order = doc.get('order')
        doc_candidates = doc.get('candidates')
        doc_order_performer = doc_order.get('performer', {})

        # extracting fields
        virtual_tariffs = doc_order.get('virtual_tariffs')
        # doc.order.virtual_tariffs[0].special_requirements

        request_class = doc_order.get('request', {}).get('class', [])
        # might be not only 1 element in list.
        # in logs there are elements like this[ "express", "courier"]

        doc_order_pricing_data = doc_order.get('pricing_data')
        # "corp_decoupling" = %false

        candidates_list = []
        for candidate_dict in doc_candidates:
            db_id = candidate_dict['db_id']
            uuid = candidate_dict['driver_id'].split('_')[1]
            # candidate_dict['tags']
            candidates_list.append({
                'dbid_uuid': '{}_{}'.format(db_id, uuid),
                'driver_classes': candidate_dict['driver_classes']
            })

        special_order_reqs = {}
        if virtual_tariffs is not None:
            for element in virtual_tariffs:
                tariff = element['class']
                tariff_reqs=[]
                for item in element['special_requirements']:
                    tariff_reqs.append(item['id'])
                special_order_reqs[tariff] = tariff_reqs

        if (
                (doc_order_performer.get('db_id') is None) or
                (doc_order_performer.get('uuid') is None)
        ):
            dbid_uuid = None
        else:
            dbid_uuid = '{}_{}'.format(
                doc_order_performer.get('db_id'),
                doc_order_performer.get('uuid')
            )

        yield Record(
            order_id=doc.get('_id'),
            # TODO [alarm]: None in dbid, uuid done?
            dbid_uuid=dbid_uuid,
            waiting_cost=doc_order.get('calc_info', {}).get('waiting_cost'),
            waiting_time=doc_order.get('calc_info', {}).get('waiting_time'),
            candidates=candidates_list,
            utc_order_dttm=utc_order_dttm,
            special_order_reqs=special_order_reqs,
            request_class=request_class,
            # change
            doc_order_pricing_data=doc_order_pricing_data
        )
        # TODO: doc.order.pricing_data.user.data.tariff.waiting_price.free_waiting_time) as free_waiting_time,
        # doc.order.pricing_data.user.data.tariff.waiting_price.price_per_minute) as price_per_minute
