from nile.api.v1 import Record

def parse_orders_with_special_reqs(records):
    for record in records:
        # "order_id"
        # "special_order_reqs"
        # "status"
        # "taxi_order_id"
        # "timestamp"
        # "utc_dt"
        # "zone_id"
        reqs = record.special_order_reqs

        _reqs = set()
        for k, v in reqs.items():
            for _el in v:
                _reqs.add(_el)

        _tags = []
        if 'cargo_eds' in _reqs:
            _tags.append('expeditor')
        if 'thermobag_confirmed' in _reqs:
            _tags.append('thermobag_confirmed')
        if 'cargo_multipoints' in _reqs:
            # TODO: multipoints -> cargo_multipoints
            _tags.append('multipoints')
        if 'thermobox_option_on' in _reqs:
            _tags.append('thermobox_option_on')

        if ('thermobag_confirmed' in _reqs) and (
                'thermobox_option_on' in _reqs):
            _tags.append('thermobox_option_on_AND_thermobag_confirmed')

        # TОDO: учитывать тип сапплая (менять его)
        # if 'car_couriers' in reqs:
        #     _tags.append('')
        for _tag in _tags:
            yield Record(
                order_id=record.order_id,
                status=record.status,
                zone_id=record.zone_id,
                utc_dt=record.utc_dt,
                _tag=_tag,
                # _reqs=reqs
            )
