from nile.api.v1 import Record

# TODO: drop from this file of from by_performer_reducer
STATUSES_SH = ["free", "driving", "waiting", "transporting"]  # "verybusy",
STATUSES_EXCEPT_FREE = ["driving", "waiting", "transporting"]
STATUS_PAID_SH = ['transporting']


def make_fst_efficiency_metrics(groups):
    for key, records in groups:
        nomin_utilization = 0
        denom_utilization = 0

        nomin_efficiency = 0
        denom_efficiency = 0

        for record in records:
            nomin_utilization += sum(
                [el[2] for el in record.get('element')
                 if el[1] in STATUSES_EXCEPT_FREE])
            denom_utilization += sum(
                [el[2] for el in record.get('element')
                 if el[1] in STATUSES_SH])
            nomin_efficiency += sum(
                [el[2] for el in record.get('element')
                 if el[1] in STATUS_PAID_SH])
            denom_efficiency += sum(
                [el[2] for el in record.get('element')
                 if el[1] in STATUSES_SH])
            # pass
        yield Record(
            key,
            utilization=nomin_utilization * 1. / denom_utilization  if denom_utilization != 0 else None,
            efficiency=nomin_efficiency * 1. / denom_efficiency if denom_efficiency != 0 else None
        )


def utilization_and_efficiency_by_performer_mapper(records):
    for record in records:
        nomin_utilization = sum(
            [el[2] for el in record.get('queue')
             if el[1] in STATUSES_EXCEPT_FREE])
        denom_utilization = sum(
            [el[2] for el in record.get('queue')
             if el[1] in STATUSES_SH])
        nomin_efficiency = sum(
            [el[2] for el in record.get('queue')
             if el[1] in STATUS_PAID_SH])
        denom_efficiency = sum(
            [el[2] for el in record.get('queue')
             if el[1] in STATUSES_SH])
        yield Record(
            mixed_driver_id=record.mixed_driver_id,
            supply_type=record.supply_type,
            utc_session_dt=record.utc_session_dt,
            utilization=(
                nomin_utilization * 1. / denom_utilization
                if denom_utilization != 0 else None
            ),
            efficiency=(
                nomin_efficiency * 1. / denom_efficiency
                if denom_efficiency != 0 else None
            )
        )


def make_queue_statuses_aggregated(groups):
    for key, records in groups:

        queue = []
        utc_session_dt = None

        tariff_zone = None
        # TODO: rename tariff_zone 2 most_common_tariff_zone for drivver +
        #  change calculation

        duration_sec_sum = 0
        cur_status = None
        cur_dttm = None
        order_id = None
        for record in records:
            # TODO: не оч правильно так делать. надо сделать отдельно по тз тогда,
            if record.tariff_geo_zone_code is not None:
                tariff_zone = record.tariff_geo_zone_code
            if record.order_id is not None:
                order_id=record.order_id
            # TODO: обрывается ли сессия, если водител ьоказывается в другой ТЗ
            if cur_status is None:
                cur_status = record.status
                duration_sec_sum += record.duration_sec
                cur_dttm = record.utc_valid_from_dttm
                continue
            else:
                if record.status == cur_status:
                    duration_sec_sum += record.duration_sec
                else:
                    queue.append([cur_dttm, cur_status, duration_sec_sum])
                    cur_status = record.status
                    duration_sec_sum = record.duration_sec
                    cur_dttm = record.utc_valid_from_dttm
            utc_session_dt = record.utc_session_dt

        queue.append([cur_dttm, cur_status, duration_sec_sum])

        yield Record(
            key,
            queue=queue,
            utc_session_dt=utc_session_dt,
            tariff_zone=tariff_zone
        )


def duplicate_sessions_mapper_in_time_intervals(time_intervals_in_local_sec):
    def mapper(records):
        for record in records:
            # "2021-01-25 09:02:21"
            # TODO: check lcl_valid_from_dttm is None only in 'off' status
            # local_hour = int(record.lcl_valid_from_dttm[11:13])
            # local_hour_in_sec = int(record.lcl_valid_from_dttm[11:13]) * 3600

            new_record = Record(
                mixed_driver_id=record.mixed_driver_id,
                # supply_type=record.supply_type,
                utc_session_dt=record.utc_session_dt,
                tariff_zone=record.tariff_zone
            )

            for element in record.queue:
                local_hour = int(element[0][11:13])
                local_hour_in_sec = int(element[0][11:13]) * 3600

                for (interval_from, interval_to) in time_intervals_in_local_sec:
                    if (
                            (local_hour_in_sec >= interval_from) and
                            (local_hour_in_sec < interval_to)
                    ):
                        yield Record(
                            new_record,
                            element=[element],
                            local_hour_in_sec=local_hour_in_sec,
                            local_hour=local_hour,
                            time_interval='{}_{}'.format(interval_from, interval_to)
                        )
    return mapper