from typing import Any, Callable, Dict, Optional
import ciso8601
import datetime
import six

from nile.api.v1 import files as nfl
from nile.api.v1.job import Job
from nile.api.v1.stream import Stream
from nile.files import BaseFile
from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from qb2.api.v1 import filters as qf

from projects.common.decorators import cached_method
from projects.data_sources.data_context.datamarts import DataContext as DatamartsDataContext
from projects.data_sources.data_context.raworders_dmorders_sessions import DataContext as DriversDataContext
from projects.data_sources.data_context.raworders_dmorders_sessions import LOGISTICS_TARIFFS
from projects.data_sources.data_context.cargo import DataContext as CargoLogsDataContext
from projects.efficiency_metrics.nile_blocks import sessions as sessions_nile_blocks
from projects.efficiency_metrics.nile_blocks import datamarts as datamarts_nile_blocks
from projects.efficiency_metrics.nile_blocks import claims as claims_nile_blocks
from projects.efficiency_metrics.nile_blocks import reqs as reqs_nile_blocks
from projects.efficiency_metrics.by_slice_reducer import make_fst_efficiency_metrics


class NilePipeline:
    def __init__(
            self,
            # *
            job,
            period_params,
            supply_type_yt_path,
            sessions_yt_path,
            sessions_by_performer_yt_path,
            raw_orders_yt_path,
            claims_yt_path,
            sessions_reqs_yt_path,
            tmp_burnt_orders_yt_path,
            burnt_orders_yt_path,
            final_table_yt_path
            # TODO: fix code here (in order not to _yt_path in this func)
            # *
    ):
        self.job = job
        self._cache = {}

        # self.supply_type_yt_path = supply_type_yt_path.format()
        self.datamart_data_context = DatamartsDataContext(
            job,
            datetime.datetime.strptime(
                period_params.get('begin_dttm'), '%Y-%m-%d')
            ,
            datetime.datetime.strptime(
                period_params.get('end_dttm'), '%Y-%m-%d'
            ),
            ['alena_lukina_cube']
        )
        self.drivers_data_context = DriversDataContext(
            job,
            datetime.datetime.strptime(
                period_params.get('begin_dttm'), '%Y-%m-%d')
            ,
            datetime.datetime.strptime(
                period_params.get('end_dttm'), '%Y-%m-%d'
            ),
            ['sessions', 'raw_orders_logistics']
        )
        self.cargo_logs_data_context = CargoLogsDataContext(
            job,
            datetime.datetime.strptime(
                period_params.get('begin_dttm'), '%Y-%m-%d')
            ,
            datetime.datetime.strptime(
                period_params.get('end_dttm'), '%Y-%m-%d'
            ),
        )

    def get_supply_type_data(self):
        return self.datamart_data_context.get_alena_lukina_cube()

    def get_orders_data_in_courier_delivery(self):
        # not used now
        # from TAXI data context
        return (
            self.drivers_data_context.get_orders()
            .filter(
                nf.custom(
                    lambda x: six.ensure_str(x) in LOGISTICS_TARIFFS,
                    'order_tariff',
                ),
            )
        )

    @cached_method
    def get_raw_orders_in_courier_delivery(self):
        return (
            self.drivers_data_context.get_raw_orders()
            .filter(
                nf.custom(lambda x: x[0] in LOGISTICS_TARIFFS, 'request_class')
            )
        )

    @cached_method
    def get_claims_data(self):
        return(
            self.cargo_logs_data_context.get_claims()
        )

    @cached_method
    def get_sessions_w_log_couriers_data(self):
        # join with target supply!!
        # TODO divide getting data_context and joining

        raw_logisitcs_orders = self.get_raw_orders_in_courier_delivery().project(
            'dbid_uuid'
        ).unique(
            'dbid_uuid'
        )

        return (
            self.drivers_data_context
            .get_sessions()
            .join(raw_logisitcs_orders, type='inner', by='dbid_uuid')
            # .join(supply_type_table, type='inner', by='dbid_uuid')
            # TODO: problem of misha mosyagin- with unique_driver_id
        )

    def create_sessions_py_performer_table(self, sessions_table):
        return (
            sessions_table
            .groupby('dbid_uuid') # TODO: - by date!?
            .sort('lcl_valid_from_dttm')
            .reduce(sessions_nile_blocks.make_queue_statuses_aggregated)
        )

    def create_burnt_orders_by_req_type(self, claims_table, raw_orders_in_courier_express):

        # //home/taxi_ml/dev/drivers/delivery/tmp_/raw_orders_2021-01-24_2021-01-25
        return (
            claims_table.project(
                "status",
                "taxi_order_id",
                "timestamp",
                "zone_id"
            ).filter(
                qf.defined('taxi_order_id')
            ).join(
                raw_orders_in_courier_express.project(
                    'order_id', 'special_order_reqs',
                    utc_dt=ne.custom(lambda x: x[:10], 'utc_order_dttm')
                ),
                by_left='taxi_order_id', by_right='order_id', type='inner'
                # TODO: сджойнится все, что не cancelles
            )
        )

    def create_causes_type_of_supply_for_burnt(self):
        return(
            self.job.table(
                '//home/taxi_ml/dev/drivers/delivery/tmp_/tmp_burnt_orders_2021-01-24_2021-01-25'
            ).map(
                reqs_nile_blocks.parse_orders_with_special_reqs
            )
            .groupby(
                'time_interval',
                '_tag',
                'zone_id',
                'supply_type' # duplicate supply_type
            ).reduce(
                claims_nile_blocks.by_statuses_reducer
            )
        )

    def final_join_sessions_and_orders(self):
        return(
            self.job.table('//home/taxi_ml/dev/drivers/delivery/tmp_/final_burnt_orders_2021-01-24_2021-01-25')
            .join(
                self.job.table('//home/taxi_ml/dev/drivers/delivery/tmp_/sessions_reqs_2021-01-24_2021-01-25').project(
                    ne.all(),
                    _tag=ne.custom(lambda x: x if x!='multipoint' else 'multipoints', 'additional_requirements')
                ),
                type='inner',
                by_left=['zone_id', '_tag'],
                # TODO: by date
                by_right=['tariff_zone', '_tag']
            )

        )

    def join_driver_sessions_with_drier_reqs_type(self, supply_type_yt_path_from):
        # reqs = self.cargo_logs_data_context.get_special_requirements()

        supply_reqs_type = self.job.table(supply_type_yt_path_from).map(
            datamarts_nile_blocks.parse_alena_mapper
        )

        # TODO: !!!
        input_yt_path = '//home/taxi_ml/dev/drivers/delivery/tmp_/sessions_by_performer_2021-01-24'

        TIME_INTERVALS = [[32400, 86400]]
        return (
            self.job.table(input_yt_path).project(
                ne.all(exclude=['supply_type'])
            ).map(
                # TODO: make duplicate mapper for different filters
                sessions_nile_blocks.duplicate_sessions_mapper_in_time_intervals(
                    TIME_INTERVALS
                    # TODO - add other timme intervals
                )
            ).join(
                supply_reqs_type,
                by_left=['utc_session_dt', 'mixed_driver_id'],
                by_right=['utc_dt', 'dbid_uuid'],
                type='inner'
                # TODO - check that inner join is correct
            ).groupby(
                'time_interval', 'supply_type', 'tariff_zone',
                'additional_requirements'
                # TODO: date
            ).reduce(
                make_fst_efficiency_metrics
            )
        )

    def final(self):
        return(
            self.job.table('//home/taxi_ml/dev/drivers/delivery/tmp_/final_table_2021-01-24_2021-01-25').project(
                "_tag",
                "efficiency",
                "supply_type",
                "utilization",
                "zone_id",
                'n_orders',

                "cancelled",
                "cancelled_by_taxi",
                "cancelled_with_items_on_hands",
                "cancelled_with_payment",
                "delivered_finish",
                "failed",
                "performer_not_found",
                "returned_finish",
                fuckup_rate=ne.custom(
                    lambda x, y: 1. - ((y or 1) * 1. / (x or 1)),
                    'n_orders', 'delivered_finish'
                ),
            ).filter(
                nf.custom(lambda x: x=='auto_courier' ,'supply_type')
            ).sort(
                'zone_id', '_tag'
            )
        )

