from nile.api.v1 import clusters
from projects.common.nile import environment as penv


def get_extra_nile_requirements():
    return ['mmh3', 'ciso8601', 'haversine']


def prepare_environment(obj, parallel_operations_limit=None, use_cxx=False):
    return penv.configure_environment(
        obj,
        requirements=(),#['haversine']),
        extra_requirements=get_extra_nile_requirements(),
        parallel_operations_limit=parallel_operations_limit,
        add_cxx_bindings=use_cxx,
    )


def get_project_cluster(
        parallel_operations_limit=None,
        use_cxx=False,
        proxy=penv.DEFAULT_CLUSTER,
        pool=penv.DEFAULT_POOL,
        use_yql=False,
):
    print ('get_project_cluster: ',pool)
    if use_yql:
        cluster = clusters.yql.YQLProduction(proxy=proxy, pool=pool)
    else:
        cluster = clusters.yt.YT(proxy=proxy, pool=pool)
    return prepare_environment(
        cluster,
        parallel_operations_limit=parallel_operations_limit,
        use_cxx=use_cxx,
    )